functor DefineTool (ToolDef:TOOLDEF) :TOOL = struct

val toolName = ToolDef.toolName
val validTarget = ToolDef.validTarget
val targetNamer = ToolDef.targetNamer
val processor = ToolDef.processor
fun targetNameOf (sourceName:string) = (!targetNamer) sourceName

val genTarget = ToolDef.genTarget

fun loadSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  (ToolDef.loadSource group sourceName targetName;
   SourceGroup.ToolInternals.updateEnv (group, sourceName, targetName, true))

fun loadTarget (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  (ToolDef.loadTarget group sourceName targetName;
   SourceGroup.ToolInternals.updateEnv (group, sourceName, targetName, false))

fun compileSource (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  (ToolDef.compileSource group sourceName targetName;
   SourceGroup.ToolInternals.updateEnv (group, sourceName, targetName, true))

fun checkLoad (group:SourceGroup.group) (sourceName:string) (targetName:string) =
  (ToolDef.checkLoad group sourceName targetName;
   SourceGroup.ToolInternals.updateEnv
     (group, sourceName, targetName,
      (not (ToolDef.validTarget group sourceName targetName))))

val _ = SourceGroup.ToolInternals.defineTool (SourceGroup.ToolInternals.Tool
 {toolName = toolName,
  targetNameOf = targetNameOf,
  loadSource = loadSource,
  genTarget = genTarget,
  loadTarget = loadTarget,
  compileSource = compileSource,
  validTarget = validTarget,
  checkLoad = checkLoad})

end
