structure AML = struct
 val dummyEOF = AMLLrVals.Tokens.EOF(0,0)
 val dummySEMI = AMLLrVals.Tokens.SEMICOLON(0,0)

 exception Quit

 fun analyze'file (noPervasives:bool) (out:outstream) (filename:string) =
  let val source'stream = open_in filename 
            handle Io s => (outputc std_err ("? sml-conn: "^s^"\n");raise Quit)
      fun cleanup () = close_in source'stream in
  let val (context as {sourceStream,linePos,lineNum,anyErrors,...}) =
            ErrorMsg.newSource(filename,source'stream,false,std_err,NONE)
      val complain = ErrorMsg.error context
      fun parseerror(s,p1,p2) = complain (p1,p2) ErrorMsg.COMPLAIN s
      val lexarg = {comLevel = ref 0, lineNum = lineNum,
			linePos = linePos,
			charlist = ref (nil : string list),
			stringstart = ref 0,
                        err = complain}
     val startingLexer' = AML_Lex.makeLexer (inputc sourceStream) lexarg
     val startingLexer  = LrParser.Stream.streamify startingLexer'
     val lookahead = 30
     val pr = (outputc out)

     fun do'parse (lexer) =
	 let val (nextToken, restLexer) = LrParser.Stream.get lexer
	 in linePos := [hd(!linePos)];
	    if AMLParser.sameToken(nextToken,dummySEMI) then do'parse restLexer
	     else if AMLParser.sameToken(nextToken,dummyEOF) then ()
	     else 
		let val (_, lexer') =
                      AMLParser.parse (lookahead, lexer, parseerror, complain)
		 in if !anyErrors then raise Quit else do'parse lexer'
	        end handle LrParser.ParseError => raise Quit
	  end
 in
   Namespace.init noPervasives;
   do'parse startingLexer;
   pr "source sml \""; pr filename; pr "\"";
   cleanup();
   Namespace.printAll out
 end
   handle Quit => cleanup()
        | other => (cleanup(); raise other)
 end
   handle Quit => ()

 fun analyze (noPervasives:bool) (sources:string list) (outfile:string) :unit =
   let val out = if outfile = "" then std_out else open_out outfile
       fun cleanup () = if outfile = "" then () else close_out out
   in
     (map (analyze'file noPervasives out) sources) handle e => (cleanup(); raise e);
     cleanup()
   end
end
