 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lvhgline.c
 >>>>
 >>>>      Program Name: vhgline
 >>>>
 >>>> Date Last Updated: Thu Mar 26 10:43:15 1992 
 >>>>
 >>>>          Routines: lvhgline - the library call for vhgline
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vinclude.h"


/* -library_includes */
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lvhgline - library call for vhgline
*
* Purpose:
*    
*    Draw lines for Fast Inverse Hough (Grey level) Transforms.
*    
*    

* Input:
* Output:
*
* Written By: Patrick Arnoul, Jean-Pierre Guerin, Jean-Francois Larue
****************************************************************/


/* -library_def */
int lvhgline(grid_file, image_xy, draw_fg, one_px_fg)
FILE *grid_file;
struct xvimage  *image_xy;
int             draw_fg, one_px_fg;

/* -library_def_end */

/* -library_code */
/*************************************************************
 *  Draw lines for Inverse Fast (Grey level) Hough Transform *
 *************************************************************/
{
#define BORCOL  255
#define LINCOL  255

int  x_off, y_off, size, rowsxcols, fract_int;

double  a_off, z_off;         /* az coord. points in hough domain (input file) */
double  a_dbl, b_dbl, c_dbl;  /* Coeff of line Ax+By+C=0 */
double  x_double, y_double, fract, fract_1, grey, px_tmp;

unsigned char  *image_pointer_xy, *ipixel_ptr ;


    size = image_xy->row_size;       /* number of cols   */
    if (size != image_xy->col_size)  /* number of rows   */
    {
        (void)fprintf(stderr,"lvhgline: error, output image should be square\n");
        return(0);
    }
    if ( (image_xy->data_storage_type) != VFF_TYP_1_BYTE)
    {
        (void)fprintf(stderr,
                   "lvhgline : error, Output Image format should be BYTE...\n");
        return(0);
    }

    rowsxcols = size * size;     /* number of pixels */
    image_pointer_xy = (unsigned char *)image_xy->imagedata;
/*
... first of all clear up the whole image.
*/

    ipixel_ptr = image_pointer_xy;
    for ( x_off = 0 ; x_off < rowsxcols ; x_off++ )
        *ipixel_ptr++ = 0;

/*
... and fill the image.
*/

while ( fscanf(grid_file,"%lf%lf%lf", &a_off, &z_off, &grey) != EOF )
{
    if ( grey > 255.0 )
    {
        fprintf(stderr,"Grey Value %f is out of range (255 used)\n",(float)grey);
        grey = 255;
    }
    if ( grey < 0.0 )
    {
        fprintf(stderr,"Grey Value %f is negative (0 used)\n",(float)grey);
        grey = 0.0;
    }
    if ((a_off > size)||(a_off < 0))
    {
        fprintf(stderr,"a_off Value %f is out of range...(not used pixel)\n",(float)a_off);
    }
    if ( (z_off > size)||(z_off < 0) )
    {
        fprintf(stderr,"z_off Value %f is out of range...(not used pixel)\n",(float)z_off);
    }
    if ( (z_off >= size)||(z_off < 0) || (a_off >= size)||(a_off < 0) || (grey==0) )
        ;
    else
    {
         
/*
... Then draw lines:
*/

/* descending lines (ascending in xy image) (right of hough image)
 * equation of the line, with x=0, y=0 at left bottom in xy :
 * Ax + By + C = 0
 * A + B = size
 * A = 2a_off - size
 * C = -z_off * size
 * ==> B = size - A = 2.size - 2.a_off
 * ==> (2a_off - size)x + (2.size - 2a_off)y  -z_off * size = 0 
 * equation of the line, with x_off=0, y_off=0 at right up in xy image:
 * x_off = (size-1)x
 * y_off = (size-1)y
 * ==>  (2.a_off - size)x_off + 2.(size - a_off)y_off + size(z_off - (size-1)) = 0 
 */

   /* high slope descending lines (climbing in image) (right most of hough image) */
   if ( (a_off >= size*3./4.) && (a_off < size*4./4.) )
   {
      a_dbl = 2.*a_off - size ;
      b_dbl = 2.*(size - a_off);
      c_dbl = size*( z_off - (size -1.) );

      for ( y_off = 0 ; y_off < size ; y_off++ )    /* scan along y axis */
      {
            x_double = ( - c_dbl - b_dbl*y_off) / a_dbl + 2.00001;
            x_off = x_double;
            x_off -= 2;

            if ( ( x_off >= -1 ) && ( x_off < size ) ) /* if within image size */
            {
                fract = x_double-(double)(x_off) - 2.0;
                if (one_px_fg)
                {
                       fract_int = fract + 0.5;
                       fract_1   = fract_int;
                }
                else
                       fract_1   = fract;

                ipixel_ptr = (unsigned char *)image_pointer_xy + y_off*size + x_off;
                if (x_off >= 0)
                {
                    px_tmp = *ipixel_ptr + (1.0-fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
                if (x_off < size-1)
                {
                    ipixel_ptr ++;   
                    px_tmp = *ipixel_ptr + (fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
            }

       }   /* end for y_off */
   }       /* end 1st a_off case */

   /* gentle slope descending lines (asc imag)  (middle right of hough image) */
   else if ( (a_off >= size*2./4.) && (a_off < size*3./4.) )
   {
       a_dbl = 2.*a_off - size ;
       b_dbl = 2.*(size - a_off);
       c_dbl = size*( z_off - (size -1.) );

       for ( x_off = 0 ; x_off < size ; x_off++ )        /* scan along x axis */
       {
            y_double = ( - c_dbl - a_dbl*x_off) / b_dbl + 2.00001;
            y_off = y_double;
            y_off -= 2;

            if ( ( y_off >= -1 ) && ( y_off < size ) )     /* if within image size */
            {
                fract = y_double - (double)(y_off) - 2.0;
                if (one_px_fg)
                {
                       fract_int = fract + 0.5;
                       fract_1   = fract_int;
                }
                else
                       fract_1   = fract;

                ipixel_ptr = (unsigned char *)image_pointer_xy + y_off*size + x_off;
                if (y_off >= 0)
                {
                    px_tmp = *ipixel_ptr + (1.0-fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
                if (y_off < size-1)
                {
                    ipixel_ptr += size;   
                    px_tmp = *ipixel_ptr + (fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
            }
        }      /* end for x_off */
    }          /* end 2nd a_off case */

/* climbing lines (descending in xy image) (left of hough image) A VERIFIER
 * equation of the line, with x=0, y=0 at left bottom in xy :
 * Ax + By + C = 0
 * A - B = size
 * A = size - 2a_off
 * C = - size*(z_off + B) + B
 * ==> B = A - size = -2a_off
 * ==> (size - 2a_off)x - 2a_off.y  -z_off * size = 0 
 * ==> C = - size*(z_off + B) + B = - size*(z_off - 2a_off) - 2a_off
 * equation of the line, with x_off=0, y_off=0 at right up in xy image:
 * x_off = x
 * y_off = y
 */

    /* gentle slope climbing lines (descending in xy image)  (middle left of hough  image)*/
    else if ( (a_off >= size*1./4.) && (a_off < size*2./4.) )
    {
        a_dbl = size - 2.*a_off;
        b_dbl = - 2*a_off;
        c_dbl = - size*(z_off + b_dbl ) + b_dbl;

        for ( x_off = 0 ; x_off < size ; x_off++ )        /* scan along x axis */
        {
            y_double = ( - c_dbl - a_dbl*x_off) / b_dbl + 2.00001;
            y_off = y_double;
            y_off -= 2;

            if ( ( y_off >= -1 ) && ( y_off < size ) )     /* if within image size */

            {
                fract = y_double - (double)(y_off) - 2.0;
                if (one_px_fg)
                {
                       fract_int = fract + 0.5;
                       fract_1   = fract_int;
                }
                else
                       fract_1   = fract;

                ipixel_ptr = (unsigned char *)image_pointer_xy + y_off*size + x_off;
                if (y_off >= 0)
                {
                    px_tmp = *ipixel_ptr + (1.0-fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
                if (y_off < size-1)
                {
                    ipixel_ptr += size;   
                    px_tmp = *ipixel_ptr + (fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
            }
        }      /* end for x_off */
    }       /* end 3rd a_off case */

    /* high slope climbing lines (descending in xy image) (left most of hough image) */
    else if ( (a_off >= 0.) && (a_off < size*1./4.) )
    {
        a_dbl = size - 2.*a_off;
        b_dbl = - 2*a_off;
        c_dbl = - size*(z_off + b_dbl ) + b_dbl;

        for ( y_off = 0 ; y_off < size ; y_off++ )    /* scan along y axis */
        {
            x_double = ( - c_dbl - b_dbl*y_off) / a_dbl + 2.00001;
            x_off = x_double;
            x_off -= 2;

            if ( ( x_off >= -1 ) && ( x_off < size ) ) /* if within image size */
            {
                fract = x_double - (double)(x_off) - 2.0;
                if (one_px_fg)
                {
                       fract_int = fract + 0.5;
                       fract_1   = fract_int;
                }
                else
                       fract_1   = fract;

                ipixel_ptr = (unsigned char *)image_pointer_xy + y_off*size + x_off;

                if (x_off >= 0)
                {
                    px_tmp = *ipixel_ptr + (1.0-fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
                if (x_off < size-1)
                {
                    ipixel_ptr ++;   
                    px_tmp = *ipixel_ptr + (fract_1)*grey + 0.5;
                    if (px_tmp > 255)
                        *ipixel_ptr = 255;
                    else
                        *ipixel_ptr = px_tmp;
                }
            }

        }  /* end for y_off */
    } /* end 4th case*/

   }  /* end if */
 }    /* end EOF */
/*
... draw surrounding lines if asked for.
*/

  if ( draw_fg != 0 )
  {
    ipixel_ptr = (unsigned char *)image_pointer_xy;

    for ( x_off = 0 ; x_off < size ; x_off++ )      /* upper and lower lines */
    {
        *ipixel_ptr = BORCOL;                  /* grey value */
        *(ipixel_ptr+size*(size-1)) = BORCOL;
        ipixel_ptr++;
    }

    ipixel_ptr = (unsigned char *)image_pointer_xy;

    for ( y_off = 0 ; y_off < size ; y_off++ )      /* left and right lines */
    {
        *ipixel_ptr = BORCOL;                  /* grey value */
        *(ipixel_ptr+size-1) = BORCOL;
        ipixel_ptr += size;
    }
  }
       
   return(1);

}
/* -library_code_end */
