
#include <gl/image.h>
#include "rtep.h"

/***************************************************************************/
/* FUNCTION: int irisimg_io()
/*
/* DESCRIPTION:
/*    Performs input/output on 'iris' format images.
/*
/* USAGE:
/*    error_ret = irisimg_io(fname,xsiz,ysiz,zsiz,imgio_cmd,buff);
/*
/* ARGUMENTS:
/*    char           *fname     (in)     : filename of image
/*    int            *xsiz      (in/out) : X dimension of image
/*    int            *ysiz      (in/out) : Y dimension of image
/*    int            *zsiz      (in/out) : Z dimension of image [1 or 3]
/*    char           imgio_cmd  (in)     : i/o operation (rb,wb)
/*    unsigned char  buff[]     (in/out) : image array
/*
/* RETURNS: (int)
/*    0 : function call completed successfully
/*    1 : illegal value for zsiz
/*    2 : i/o open error with imgio_cmd = "rb"
/*    3 : i/o read error with imgio_cmd = "wb"
/*    4 : invalid imgio_cmd argument
/*
/* COMMENTS:
/*    The "iris" image file format is supported by the /usr/lib/libimage.a
/*    C subroutine library on SGI IRIS 4D/?? series workstations.  The
/*    include file <gl/image.h> is necessary when using these subroutines.
/*    The variable 'zsiz' refers to the number of byte-planes, i.e. 
/*    zsiz=1 would correspond to an 8-bit per pixel image, and zsiz=3
/*    would correspond to a 24-bit per pixel image.
/*
/* EXAMPLE:
/* SEE ALSO:
/*    iris_getdims()
/*
/* INFO:
/*    Author : Ray Idaszak
/*    Date   : March 1, 1989
/*    email  : rayi@ncsa.uiuc.edu
/***************************************************************************/

int irisimg_io(fname,xsiz,ysiz,zsiz,imgio_cmd,buff)
char *fname;
int *xsiz,*ysiz,*zsiz;
char *imgio_cmd;
unsigned char buff[];
{
	register int i;
	int err_ret;
	int num_bytes,num_rec;
	IMAGE *image;
	int xsize,ysize,zsize;
	short rbuf[4096],gbuf[4096],bbuf[4096];
	unsigned char *buf_ptr;
	short *rptr,*gptr,*bptr;
	int y;

	err_ret = 0;

	if ((*zsiz != 1) && (*zsiz != 3)){
		err_ret = 1;
		goto error;
	}

	if ((*zsiz == 1) && (!strcmp(imgio_cmd,"rb"))){
		if ( (image=iopen(fname,"r")) == NULL){
			err_ret = 2;
			goto error;
		}
		xsize = image->xsize;
		ysize = image->ysize;
		zsize = image->zsize;
		buf_ptr = &buff[0];
		for(y=ysize-1; y>=0; y--){
			getrow(image,rbuf,y,0);
			i = xsize;
			rptr = &rbuf[0];
			do{
				i--;
				*buf_ptr++ = *rptr++;
			}while(i);
		}
		iclose(image);
		*xsiz = xsize;
		*ysiz = ysize;
		*zsiz = zsize;
	}
	else if ((*zsiz == 3) && (!strcmp(imgio_cmd,"rb"))){
		if ( (image=iopen(fname,"r")) == NULL){
			err_ret = 2;
			goto error;
		}
		xsize = image->xsize;
		ysize = image->ysize;
		zsize = image->zsize;
		buf_ptr = &buff[0];
		for(y=ysize-1; y>=0; y--){
			getrow(image,rbuf,y,0);
			getrow(image,gbuf,y,1);
			getrow(image,bbuf,y,2);
			i = xsize;
			rptr = &rbuf[0];
			gptr = &gbuf[0];
			bptr = &bbuf[0];
			do{
				i--;
				*buf_ptr++ = *rptr++;
				*buf_ptr++ = *gptr++;
				*buf_ptr++ = *bptr++;
			}while(i);
		}
		iclose(image);
		*xsiz = xsize;
		*ysiz = ysize;
		*zsiz = zsize;
	}
	else if ((*zsiz == 1) && (!strcmp(imgio_cmd,"wb"))){
		xsize = *xsiz;
		ysize = *ysiz;
		zsize = *zsiz;
	   if ( (image=iopen(fname,"w",RLE(1),3,xsize,ysize,zsize)) == NULL){
			err_ret = 3;
			goto error;
		}
		buf_ptr = &buff[0];
		for(y=ysize-1; y>=0; y--){
			rptr = &rbuf[0];
			i = xsize;
			do{
				i--;
				*rptr++ = *buf_ptr++;
			}while(i);
			putrow(image,rbuf,y,0);
		}
		iclose(image);
	}
	else if ((*zsiz == 3) && (!strcmp(imgio_cmd,"wb"))){
		xsize = *xsiz;
		ysize = *ysiz;
		zsize = *zsiz;
	   if ( (image=iopen(fname,"w",RLE(1),3,xsize,ysize,zsize)) == NULL){
			err_ret = 3;
			goto error;
		}
		buf_ptr = &buff[0];
		for(y=ysize-1; y>=0; y--){
			rptr = &rbuf[0];
			gptr = &gbuf[0];
			bptr = &bbuf[0];
			i = xsize;
			do{
				i--;
				*rptr++ = *buf_ptr++;
				*gptr++ = *buf_ptr++;
				*bptr++ = *buf_ptr++;
			}while(i);
			putrow(image,rbuf,y,0);
			putrow(image,gbuf,y,1);
			putrow(image,bbuf,y,2);
		}
		iclose(image);
	}
	else{
		err_ret = 4;
		goto error;
	}

error:
#if RTE_PRERR
	err_msg("irisimg_io",err_ret);
#endif
	return(err_ret);
}
