
#include "zdb.h"

char tempMess[5000];


ZSQL::ZSQL(ZDBConnection* p)
{
if(!p)
	return;
Connection=p;
Initialize();
}

ZSQL::~ZSQL()
{
Close();
}

void ZSQL::Initialize()
{
IsOpen=0;
SQLString[0]='\0';
*ErrorMessage=0;
}

BOOL ZSQL::SetCurrentRecord(long rn)
{
if(rn<GetCurrentRecord())
	return FALSE;
while(rn-GetCurrentRecord())	{
	if(!GetNextRecord())
		return FALSE;
	}
return TRUE;
}


//***********************************************************************
//			ZDBConnection definitions
//***********************************************************************
#pragma argsused
ZDBConnection::ZDBConnection(char *x,char*y,char*z)
{
Initialize();
}

ZDBConnection::~ZDBConnection()
{
ShutDown();
}

void ZDBConnection::FreeFields()
{
for(int i=0;i<MAXFLDLIST;i++)	{
	if(Field[i]!=NULL)
		delete(Field[i]);
	}
return;
}

//****************************************************************************
//				ShutDown
//****************************************************************************
void ZDBConnection::ShutDown()
{
if(!ConnectedToServer)
	return;
Initialize();
}

//****************************************************************************
//				Initialize
//****************************************************************************
void ZDBConnection::Initialize()
{
Server[0]='\0';
DBName[0]='\0';
User[0]='\0';
Password[0]='\0';
ErrorMessage[0]='\0';
ConnectedToServer=FALSE;
ConnectedToDB=FALSE;
Type=UNKNOWN_DB;
}

#pragma argsused
void ZDBConnection::Log(char* x,char* y)
{
}



