---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, note de bas de page, reledmac, manyfoot
              plusieurs plages de notes de bas de page
---

# Comment obtenir plus d'une plage de notes de bas de page ?

Pouvoir disposer de plusieurs plages de notes en bas de page est un besoin courant 
dans les éditions critiques (ou éditions savantes) pour mettre en forme 
[l'apparat critique](wpfr:Apparat_critique). Ce besoin peut parfois survenir 
aussi dans d'autres domaines.


## Avec l'extension <ctanpkg:reledmac>

L'extension la plus récente pour l'édition critique est <ctanpkg:reledmac>, 
de Maïeul Rouquette. 

En voici un exemple fonctionnel d'utilisation dont le résultat n'est cependant pas 
disponible avec cette FAQ. Il illustre en particulier différentes commandes nécessaires 
pour obtenir l'apparat critique, à savoir :
- `\beginnumbering` et `\endnumbering` pour pouvoir numéroter (sans les afficher) 
  les lignes du texte ;
- `\pstart` et `\pend` pour indiquer les débuts et fin de paragraphe du texte ; 
- `\edtext{⟨texte⟩}{⟨note de bas de page⟩}` qui associe un extrait texte (qui est cité) 
  à une note de bas de page ;  
- les commandes `\Afootnote` et `\Bfootnote` (entre autres) pour introduire le texte 
  des notes en bas de page.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{reledmac}

\begin{document}
\beginnumbering
\pstart
Mon cher voisin, si vous persistez à vitupérer 
\edtext{perpétuellement}{\Afootnote{sans cesse}} contre mon humble personne, 
je vais être saisi \edtext{de l'extrême obligeance}{\Afootnote{du 
douloureux devoir}} de vous \edtext{\edtext{dire \og Na ! 
\fg{}.}{\Afootnote{mettre les points sur les I.}}}{\Bfootnote{mettre mon 
poing dans la figure.}}
\pend
\endnumbering
\end{document}
```

Cette extension est beaucoup plus riche que ne le montre ce seul exemple, 
comme l'illustre la [documentation](texdoc:reledmac) de l'extension.

Historiquement, l'extension <ctanpkg:EDMAC> a d'abord été développée 
par Dominik Wujastyk, pour TeX seulement. Son portage sous LaTeX a été fait 
par Peter R. Wilson et a pris le nom de <ctanpkg:ledmac> (*LaTeX-EDMAC*). 
Une version étendue a été développée par Maïeul Rouquette et s'est appelée <ctanpkg:eledmac> 
(*extended ledmac*). Enfin, la réimplémentation actuelle, <ctanpkg:reledmac>, rend obsolète
toutes les précédentes et son [développement](https://github.com/maieul/ledmac/) 
reste très actif. La [documentation](texdoc:reledmac) de l'extension précise 
comment passer de <ctanpkg:ledmac> et <ctanpkg:eledmac> à l'extension actuelle.


## Avec l'extension <ctanpkg:manyfoot> et les extensions liées

L'extension <ctanpkg:manyfoot> propose aussi des plages de notes de bas de page multiples 
aux utilisateurs de LaTeX. Elle fournit d'ailleurs un large éventail d'options 
de présentation.

Voici un exemple basé sur la [documentation](texdoc:manyfoot) de l'extension.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[para]{manyfoot}

  \newfootnote{A}
  \newfootnote[para]{B}

  \newcounter{footnoteA}
  \newcounter{footnoteB}

  \newcommand{\footnoteA}{%
    \stepcounter{footnoteA}%
    \Footnotemark\thefootnoteA \FootnotetextA{}
  }
  
  \newcommand{\footnoteB}{%
    \stepcounter{footnoteB}%
    \Footnotemark\thefootnoteB \FootnotetextB\thefootnoteB}
    \renewcommand{\thefootnoteB}{\roman{footnoteB}
  }

\begin{document}
Pour toute personne souhaitant des notes\footnoteA{Comme celle-ci.} de bas 
de page\footnoteA{Donc, ici} se séparant en plusieurs 
catégories\footnoteB{Par exemple, cette seconde catégorie}, 
l'extension \textsf{manyfoot} peut fournir une réponse 
intéressante, avec en particulier la possibilité de changer les mises en 
forme associées\footnoteB{Dans cette catégorie, les notes se 
suivent comme dans un paragraphe ordinaire, à la différence de la première
catégorie au format plus usuel.}.
\end{document}
```

Deux autres extensions traitant de l'édition critique se basent sur <ctanpkg:manyfoot> :

- <ctanpkg:ednotes> qui inclut <ctanpkg:manyfoot> comme mécanisme 
  pour mettre en place plusieurs plages de notes de bas de page ;
- <ctanpkg:bigfoot> utilise tout autant <ctanpkg:manyfoot> dans le cadre 
  de sa structure sophistiquée de fonctions de note de bas de page.

:::{sources}
[More than one sequence of footnotes](faquk:FAQ-multfoot)
:::