---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, graphiques, forme des points,
              apparence des points, format du graphique, statistiques, TikZ,
              tracer une fonction, mathématiques
---

# Comment changer la forme des points avec <ctanpkg:pgfplots> ?

L'extension <ctanpkg:pgfplots> permet de présenter des graphiques couramment
utilisés en analyse de données. Elle dipose de nombreuses options 
de configuration.


## Une forme des points simple

Dans l'exemple suivant, la forme des points est déterminée par l'option 
`mark`. De nombreuses possibilités existent : `*`, `+`, `triangle`,`square`.
Vous pouvez en trouver une liste dans la section "Markers" 
de la [documentation](texdoc:pgfplots) de <ctanpkg:pgfplots>. 

```
% Un fichier de données créé par le document avec l'environnement filecontents
\begin{filecontents*}{donnees.dat}
  x  y label
  0.12 15 c
  0.35 42 c
  0.27 8 c
  0.86 56 a
  0.83 37 b
  0.90 35 b
  0.64 62 a
  0.67 28 b
  0.30 23 c
\end{filecontents*}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pgfplots}

\begin{document}
\begin{tikzpicture}
  \begin{axis}[enlargelimits=0.1]
    \addplot+[
      only marks,
      mark=square*,
      mark size=0.1cm]
      table[meta=label] {donnees.dat};
  \end{axis}
\end{tikzpicture}
\end{document}
```


## Une forme des points conditionnelle

Il est possible d'avoir une forme des points fonction de certaines variables,
comme le fait l'exemple suivant.

``` 
% Un fichier de données créé par le document avec l'environnement filecontents
\begin{filecontents*}{donnees.dat}
  x  y label
  0.12 15 c
  0.35 42 c
  0.27 8 c
  0.86 56 a
  0.83 37 b
  0.90 35 b
  0.64 62 a
  0.67 28 b
  0.30 23 c
\end{filecontents*}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{pgfplots}

\begin{document}
\begin{tikzpicture}
  \begin{axis}[enlargelimits=0.1]
    \addplot+[
      only marks,
      scatter,
      point meta=explicit symbolic,
      scatter/classes={
        a={mark=square*},
        b={mark=triangle*},
        c={mark=o}
        },
      mark size=0.1cm]
      table[meta=label] {donnees.dat};
  \end{axis}
\end{tikzpicture}
\end{document}
``` 


## Pour avoir encore plus de formes

L'extension <ctanpkg:oPlotSymbl> fournit un grand nombre de formes 
supplémentaires. Ici, la liste des hexagones disponibles :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}
  \usepackage{oplotsymbl}

\begin{document}
\begin{tabular}{cll}
\hline
Symbole       & Commande             & Description                       \\ \hline
\hexago       & \verb+\hexago+       & Forme standard                    \\
\hexagofill   & \verb+\hexagofill+   & Hexagone plein                    \\
\hexagodot    & \verb+\hexagodot+    & Hexagone avec un point            \\
\hexagolinev  & \verb+\hexagolinev+  & Hexagone avec un trait vertical   \\
\hexagolineh  & \verb+\hexagolineh+  & Hexagone avec un trait horizontal \\
\hexagolinevh & \verb+\hexagolinevh+ & Hexagone avec une croix grecque   \\
\hexagocross  & \verb+\hexagocross+  & Hexagone avec une croix décussée  \\
\hexagofillha & \verb+\hexagofillha+ & Hexagone à moitié plein (haut)    \\
\hexagofillhb & \verb+\hexagofillhb+ & Hexagone à moitié plein (bas)     \\
\hexagofillhr & \verb+\hexagofillhr+ & Hexagone à moitié plein (droite)  \\
\hexagofillhl & \verb+\hexagofillhl+ & Hexagone à moitié plein (gauche)  \\
\hline
\end{tabular}
\end{document}
```

La [documentation](texdoc:oPlotSymbl) donne une liste complète.

:::{todo} Faire le lien entre cette solution et les précédentes
:::