#!/usr/bin/perl
@tex_tfm_h=(0x00, 0x0B, 0x00, 0x01, 0x00, 0x2B, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x0E, 0x54, 0x45, 0x58, 0x20, 0x4B, 0x41, 0x4E, 0x4A, 0x49, 0x20, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x4F, 0x54, 0x46, 0x20, 0x4B, 0x41, 0x4E, 0x4A, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x14, 0x7B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEB, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x99, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x33, 0x33, 0x00, 0x02, 0x00, 0x00);
@tex_tfm_v=(0x00, 0x09, 0x00, 0x01, 0x00, 0x2B, 0x00, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x0E, 0x54, 0x45, 0x58, 0x20, 0x4B, 0x41, 0x4E, 0x4A, 0x49, 0x20, 0x54, 0x45, 0x58, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x4F, 0x54, 0x46, 0x20, 0x4B, 0x41, 0x4E, 0x4A, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x99, 0x9A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x03, 0x33, 0x33, 0x00, 0x02, 0x00, 0x00);
@dvips_tfm_h=(0x00, 0x0B, 0x00, 0x01, 0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x14, 0x7B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xEB, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);
@dvips_tfm_v=(0x00, 0x09, 0x00, 0x01, 0x00, 0x1B, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00);

opendir(TFM, "tfm") || mkdir("tfm",0755) || die "cannot mkdir tfm";
opendir(OVP, "ovp") || mkdir("ovp",0755) || die "cannot mkdir ovp";
opendir(VF, "vf") || mkdir("vf",0755) || die "cannot mkdir vf";
&make_utf_tfm;
&makejvf;

sub make_utf_tfm {
	for ($k=0; $k<=6; $k++){#face
		if ($k==0) {$face="mr";}elsif ($k==1){$face="gr";}elsif ($k==2){$face="mb";}
			elsif ($k==3){$face="gb";}elsif ($k==4){$face="mgr";}elsif ($k==5){$face="ml";}
			elsif ($k==6){$face="ge";}
		for ($l=0; $l<=0; $l++){#language
			if ($l==0) {$lang="j";} elsif ($l==1) {$lang="k";} 
				elsif ($l==2) {$lang="c";} elsif ($l==3){$lang="t";}
			for ($i=0; $i<=1; $i++){#direction
				if ($i==0) {$dir="h";}elsif ($i==1){$dir="v";}
				$varfilename="otf-u$lang$face"."n-$dir";
				open(DVIPSTFM,">tfm/$varfilename.tfm") || die "Can't make \'tfm/$varfilename.tfm\'!\n";
				if ($i==0) {
					foreach $binary(@dvips_tfm_h) {$_ = pack("C", $binary);print DVIPSTFM "$_";}
				}elsif ($i==1){
					foreach $binary(@dvips_tfm_v) {$_ = pack("C", $binary);print DVIPSTFM "$_";}
				}
				close(DVIPSTFM);
				for ($first_hex=0x0; $first_hex <= 0xf; $first_hex++){
					$filename="utf$lang$face"."n".sprintf("%x",$first_hex)."-$dir";
					open(TEXTFM,">tfm/$filename.tfm") || die "Can't make \'tfm/$filename.tfm\'!\n";
					if ($i==0) {
						foreach $binary(@tex_tfm_h) {$_ = pack("C", $binary);print TEXTFM "$_";}
					}elsif ($i==1){
						foreach $binary(@tex_tfm_v) {$_ = pack("C", $binary);print TEXTFM "$_";}
					}
					close(TEXTFM);
				}
			}
		}
	}
}

sub makejvf {
	for ($k=0; $k<=6; $k++){#face
		if ($k==0) {$face="mr";}elsif ($k==1){$face="gr";}elsif ($k==2){$face="mb";}
			elsif ($k==3){$face="gb";}elsif ($k==4){$face="mgr";}elsif ($k==5){$face="ml";}
			elsif ($k==6){$face="ge";}
		for ($l=0; $l<=0; $l++){#language
			if ($l==0) {$lang="j";} elsif ($l==1) {$lang="k";} 
				elsif ($l==2) {$lang="c";} elsif ($l==3){$lang="t";}
			for ($i=0; $i<=1; $i++){#direction
				if ($i==0) {$dir="h";}elsif ($i==1){$dir="v";}
				for ($first_hex=0x0; $first_hex <= 0xf; $first_hex++){
					$filename="utf$lang$face"."n".sprintf("%x",$first_hex)."-$dir";
					open(OUT, ">ovp/$filename.ovp")||die "$!";
					&fonthead;
					print OUT "   (FONTNAME otf-u$lang$face"."n-$dir)\n";
					&fontfoot;
					&writechar($first_hex);
					close(OUT);
					system("ovp2ovf ovp/$filename.ovp vf/$filename.vf vf/$filename.ofm");
					unlink "vf/$filename.ofm";
				}
			}
		}
	}
}

sub fonthead {
print OUT <<END_OF_DATA;
(VTITLE JVF for UTF16)
(OFMLEVEL D 0)
(DESIGNSIZE R 10.000000)
(CHECKSUM O 0)
(MAPFONT D 0
END_OF_DATA
}

sub fontfoot {
print OUT <<END_OF_DATA;
   (FONTCHECKSUM O 0)
   (FONTAT R 1.0)
   (FONTDSIZE R 10.000000)
   )
END_OF_DATA
}

sub writechar {
	($hex) = @_;
	for ($ku=1; $ku <= 79; $ku++){
		for ($ten=1; $ten <= 94; $ten++){
			$jis=sprintf("%X", $ku*256 + $ten + 0x2020);
			if ($ku>=16 && $ku<=79 && $ten>=16 && $ten<=79){
				$uni=sprintf("%X", $hex*4096 + ($ku-16)*64 + ($ten-16));
			} else {
				$uni="3013";
			}
			print OUT "(CHARACTER H $jis (CHARWD R 1.0) (MAP (SETCHAR H $uni)))\n";
		}
	}
}
