#!/usr/bin/perl -w

#       CopyLeft
#
#       Paolo Lulli paolo@lulli.net
#          
#       www.lulli.net 



if ( $#ARGV == -1 ) 
	{
	print "\tInserisci il nome del file su cui scrivere \n\t";
	$nomefile = <STDIN>;
	}
else	{
	$nomefile = $ARGV[0];
	}


$author="Paolo Lulli";

$author_email="<paolo\@lulli.net>";



# < Definizione variabili >


chop($nomefile);
$insout=$nomefile.".ins";
$dtxout=$nomefile.".dtx";
$clsnomefile=$nomefile.".cls";
$stynomefile=$nomefile.".sty";


# < /Definizione variabili >


($ins)=<<EOT;
%%
%% Copyright (C) 2003 by $author $author_email
%%
%% This file may be distributed and/or modified under the conditions of
%% the LaTeX Project Public License, either version 1.2 of this license
%% or (at your option) any later version.  The latest version of this
%% license is in:
%% 
%%    http://www.latex-project.org/lppl.txt
%% 
%% and version 1.2 or later is part of all distributions of LaTeX version
%% 1999/12/01 or later.
%%

\\input docstrip.tex
\\keepsilent

\\usedir{tex/latex/$nomefile}

\\preamble

This is a generated file.

Copyright (C) 2003 by $author $author_email

This file may be distributed and/or modified under the conditions of
the LaTeX Project Public License, either version 1.2 of this license
or (at your option) any later version.  The latest version of this
license is in:

   http://www.latex-project.org/lppl.txt

and version 1.2 or later is part of all distributions of LaTeX version
1999/12/01 or later.

\\endpreamble

\\generate{\\file{$nomefile.sty}{\\from{$nomefile.dtx}{package}}}

\\obeyspaces
\\Msg{*************************************************************}
\\Msg{*                                                           *}
\\Msg{* To finish the installation you have to move the following *}
\\Msg{* file into a directory searched by TeX:                    *}
\\Msg{*                                                           *}
\\Msg{*     $nomefile.sty                                         *}
\\Msg{*                                                           *}
\\Msg{* To produce the documentation run the file $nomefile.dtx   *}
\\Msg{* through LaTeX.                                            *}
\\Msg{*                                                           *}
\\Msg{* Happy TeXing!                                             *}
\\Msg{*                                                           *}
\\Msg{*************************************************************}

\\endbatchfile

EOT

($dtx)=<<EOX;
% \\iffalse meta-comment
%
% Copyright (C) 2003 by $author $author_email
% --------------------------------------------------
% 
% This file may be distributed and/or modified under the
% conditions of the LaTeX Project Public License, either version 1.2
% of this license or (at your option) any later version.
% The latest version of this license is in:
%
%    http://www.latex-project.org/lppl.txt
%
% and version 1.2 or later is part of all distributions of LaTeX 
% version 1999/12/01 or later.
%
% \\fi
%
% \\iffalse
%<package>\\NeedsTeXFormat{LaTeX2e}[1999/12/01]
%<package>\\ProvidesPackage{$nomefile}
%<package>   [2002/03/21 v1.0 .dtx $nomefile file] 
%
%<*driver>
\\documentclass{ltxdoc}
\\usepackage{$nomefile}
\\EnableCrossrefs         
\\CodelineIndex
\\RecordChanges
\\begin{document}
  \\DocInput{$nomefile.dtx}
\\end{document}
%</driver>
% \\fi
%
% \\CheckSum{0}
%
% \\CharacterTable
%  {Upper-case    \\A\\B\\C\\D\\E\\F\\G\\H\\I\\J\\K\\L\\M\\N\\O\\P\\Q\\R\\S\\T\\U\\V\\W\\X\\Y\\Z
%   Lower-case    \\a\\b\\c\\d\\e\\f\\g\\h\\i\\j\\k\\l\\m\\n\\o\\p\\q\\r\\s\\t\\u\\v\\w\\x\\y\\z
%   Digits        \\0\\1\\2\\3\\4\\5\\6\\7\\8\\9
%   Exclamation   \\!     Double quote  \\"     Hash (number) \\#
%   Dollar        \\\$     Percent       \\%     Ampersand     \\&
%   Acute accent  \\'     Left paren    \\(     Right paren   \\)
%   Asterisk      \\*     Plus          \\+     Comma         \\,
%   Minus         \\-     Point         \\.     Solidus       \\/
%   Colon         \\:     Semicolon     \\;     Less than     \\<
%   Equals        \\=     Greater than  \\>     Question mark \\?
%   Commercial at \\@     Left bracket  \\[     Backslash     \\\\
%   Right bracket \\]     Circumflex    \\^     Underscore    \\_
%   Grave accent  \\`     Left brace    \\{     Vertical bar  \\|
%   Right brace   \\}     Tilde         \\~}
%
%
% \\changes{v1.0}{2002/03/25}{Initial version}
%
% \\GetFileInfo{$nomefile.sty}
%
% \\DoNotIndex{\\newcommand,\\newenvironment}
% 
%
% \\title{The \\textsf{$nomefile} package\\thanks{This document
%   corresponds to \\textsf{$nomefile}~\\fileversion, dated \\filedate.}}
% \\author{Scott Pakin \\\\ \\texttt{pakin@uiuc.edu}}
%
% \\maketitle
%
% \\section{Introduction}
%
% Put text here.
%
% \\section{Usage}
%
% Put text here.
%
% \\DescribeMacro{\\dummyMacro}
% This macro does nothing.\\index{doing nothing|usage} It is merely an
% example.  If this were a real macro, you would put a paragraph here
% describing what the macro is supposed to do, what its mandatory and
% optional arguments are, and so forth.
%
% \\DescribeEnv{dummyEnv}
% This environment does nothing.  It is merely an example.
% If this were a real environment, you would put a paragraph here
% describing what the environment is supposed to do, what its
% mandatory and optional arguments are, and so forth.
%
% \\StopEventually{\\PrintChanges\\PrintIndex}
%
% \\section{Implementation}
%
% \\begin{macro}{\\dummyMacro}
% This is a dummy macro.  If it did anything, we'd describe its
% implementation here.
%    \\begin{macrocode}
\\newcommand{\\dummyMacro}{}
%    \\end{macrocode}
% \\end{macro}
%
% \\begin{environment}{dummyEnv}
% This is a dummy environment.  If it did anything, we'd describe its
% implementation here.
%    \\begin{macrocode}
\\newenvironment{dummyEnv}{%
}{%
%    \\end{macrocode}
% \\changes{v1.0a}{2002/03/25}{Added a spurious change log entry to
%   show what a change \\emph{within} an environment definition looks
%   like.}
% Don't use |%| to introduce a code comment within a |macrocode|
% environment.  Instead, you should typeset all of your comments with
% \\LaTeX---doing so gives much prettier results.  For comments within a
% macro/environment body, just do an |\\end{macrocode}|, include some
% commentary, and do another |\\begin{macrocode}|.  It's that simple.
%    \\begin{macrocode}
}
%    \\end{macrocode}
% \\end{environment}
%
% \\Finale
\\endinput

EOX


open( MIO_CINS, "> $insout");
print MIO_CINS "$ins";
close( MIO_CINS ); 

open( MIO_CDTX, "> $dtxout");
print MIO_CDTX"$dtx";
close( MIO_CDTX ); 

print"$insout and $dtxout have been generated into the current directory \n\n";
