// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
static const char rcsid[] = "$Header: main.C,v 1.32 91/05/17 16:28:22 hmgr Exp $";

// TeX DVI filter main() - just parses arguments and calls functions
//
// by Parag Patel

#include "defs.h"

static char *const whatid = "@(#)dvi 1.7 (02 April 1991)";

static void say_hello()
{
    // hello message like (but unlike) TeX - the following mess should
    // strip out the revision number out of the build ID string "whatid"
    char *s = strchr(whatid, ' ');
    while (*s == ' ')
	s++;
    char *t = s;
    while (*t != ' ' && *t != '$' && *t != '\0')
	t++;
    *t = '\0';
    mesg("TeX DVI filter version %s for ", s);
}

static long strtonum(char *s, char **ptr)
{
    long ret = 0;
    int neg = 0;

    while (isspace(*s))
	s++;
    if (*s == '-')
    {
	neg = 1;
	s++;
    }
    while (*s == '0')
	s++;
    while (isdigit(*s))
	ret = ret * 10 + *s++ - '0';
    if (ptr != NULL)
	*ptr = s;
    return neg ? -ret : ret;
}


extern char *optarg;
extern int optind;

main(int argc, char *argv[])
{
    int op;
    char *next, *str;
    Pagespec pages;
#ifdef	__ZTC__
    // there must be a function for this somewhere!
    // we do not want <CR> prepended to an <NL> on a putchar('\n')
    stdout->_flag &= ~_IOTRAN;
#endif
    while ((op = getopt(argc, argv, "vcd:i:rp:o:l2:m:=:")) != EOF)
	switch (op)
	{
	Case '=': 		// debug mode - undocumented!!!
	    debuglevel = atoi(optarg);

	Case 'v': 		// verbose mode
	    verbose = TRUE;

	Case 'c': 		// no checksum checking
	    dochecksum = FALSE;

	Case 'l': 		// landscape (sideways) mode
	    landscape = TRUE;

	Case 'r': 		// do not reverse pages
	    reverse = FALSE;

	Case '2': 		// double-sided output
	    duparg = TRUE;
	    if (*optarg == '-' || *optarg == '!')
		duplexh = duplexv = FALSE;
	    else if (*optarg == 'h' || *optarg == 'H')
		duplexh = TRUE, duplexv = FALSE;
	    else
		duplexh = FALSE, duplexv = TRUE;

	Case 'o': 		// get device type for output
	    devname = optarg;

	Case 'd': 		// set font directory search path
	    fontpath = optarg;

	Case 'i': 		// set special file search path
	    dviinput = optarg;

	Case 'm':		// user-specified magnification value
	    if (strchr(optarg, '.') != NULL)
		usermag = (long)(atof(optarg) * 1000.0);
	    else
		usermag = atol(optarg);

	Case 'p': 		// specific pages only
	    // format: -p page[.num[-endpage[.endsect]]][,more]
	    // the following code is really really ugly...
	    for (str = optarg; str != NULL && *str != '\0'; str = next)
	    {
		// setup for the next page spec in the list
		next = strchr(str, ',');
		if (next != NULL)
		    *next++ = '\0';

		// get the next entry
		char *ptr = str;// generic string pointer
		long p = 0;	// page to print
		long s = MAXLONG;	// section of page

		// get the first number
		p = strtonum(ptr, &ptr);

		// empty spec - ignore it
		if (ptr == str)
		    continue;

		// a '*' here doesn't mean anything so skip it
		if (*ptr == '*')
		    ptr++;

		// do we have a section spec?
		if (*ptr == '.')
		{
		    s = strtonum(ptr + 1, &ptr);
		    if (*ptr == '*')	// ignore '*'
			ptr++;
		}

		long pe = p;	// ending page for range
		long se = s;	// ending section for range

		// do we have a range?
		if (*ptr == '=')
		{
		    // get ending page
		    pe = strtonum(ptr + 1, &ptr);
		    if (*ptr == '*')
		    {
			// this means "to the end"
			pe = MAXLONG;
			ptr++;
		    }

		    // ending section?
		    if (*ptr == '.')
		    {
			se = strtonum(ptr + 1, &ptr);
			if (*ptr == '*')    // to the end
			    se = MAXLONG;
		    }
		}

		// setup this page specifier
		long pg = pages.size();
		pages[pg].page = p;
		pages[pg].section = s;
		pages[pg].endpage = pe;
		pages[pg].endsection = se;
	    }

	Default: 
	    fprintf(stderr,
		    "Usage:\t%s [-vrlc] [-d fontpath] [-i inputpath] [-2 -|v|h]\n\t[-o device] [-p page[.sect[=page2[.sect2]]][, ...]] [file]\n",
		    argv[0]);
	    exit(11);
	}

    // initialize
    say_hello();
    init_globals();
    mesg(NULL);

    // no arguments? assume stdin is set to a DVI file
    if (optind >= argc)
    {
	dodvi(stdin, pages);
	fini_globals();
	return 0;
    }

    // else the first file argument
    // - ignore other args since this code is currently not re-entrant
    FILE *fp = fopen(argv[optind], F_READ);
    if (fp == NULL)
    {
	char *name = new char[strlen(argv[optind]) + 10];
	strcpy(name, argv[optind]);
	strcat(name, ".dvi");
	if ((fp = fopen(name, F_READ)) == NULL)
	    quit("Cannot open %s for reading", argv[optind]);
    }
    dodvi(fp, pages);
    fclose(fp);
    fini_globals();
    return 0;
}
