/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.command;

import com.google.inject.Injector;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.traccar.command.ClientCommandSender;
import org.traccar.command.CommandSender;
import org.traccar.command.FindHubCommandSender;

@Singleton
public class CommandSenderManager {
    private static final Map<String, Class<? extends CommandSender>> SENDERS_ALL = Map.of("client", ClientCommandSender.class, "findHub", FindHubCommandSender.class);
    private final Injector injector;

    @Inject
    public CommandSenderManager(Injector injector) {
        this.injector = injector;
    }

    public CommandSender getSender(String type) {
        Class<? extends CommandSender> clazz = SENDERS_ALL.get(type);
        CommandSender sender = (CommandSender)this.injector.getInstance(clazz);
        if (sender != null) {
            return sender;
        }
        throw new RuntimeException("Failed to get command sender " + type);
    }
}

