#include <stdio.h>
#include <midi.h>
/*
**	KMAP		psl 10/85
**	Copy midi data, remapping the key numbers.
*/

#define	MINOCT	-2
#define	MAXOCT	8

char	Noteval[]	= { 9, 11, 0, 2, 4, 5, 7, };
int	Map[128];		/* key mappings */
int	Alloct;			/* set by keynum() */

main(argc,argv)
char	*argv[];
{
	register char *cp;
	int i, j, args, only, noct;
	long now;
	MCMD *mp;

	for (i = 128; --i >= 0; Map[i] = -1);
	args = only = 0;
	while (--argc > 0) {
            cp = argv[argc];
            if (*cp == '-') {
                if (*++cp == 'o')
                    only = 1;
		else
		    goto syntax;
		continue;
            }
	    i = keynum(cp);
	    noct = Alloct;
	    while (*cp && *cp != '=')
		cp++;
	    if (*cp++ != '=')
		goto syntax;
	    j = keynum(cp);
	    if (Alloct && noct)
		for (; i < 128 && j < 128; i += 12, j+= 12)
		    Map[j] = i;
	    else if (Alloct)
		for (; j < 128; j += 12)
		    Map[j] = i;
	    else
		Map[j] = i;
	    args++;
        }
	if (args == 0) {
syntax:
	    fprintf(stderr, "Usage: %s [-only] new=old ...\n", argv[0]);
	    fprintf(stderr, "where 'new' is the destination key,\n");
	    fprintf(stderr, "      'old' is the original key\n");
	    fprintf(stderr, "  and 'only' means ignore other keys.\n");
	    fprintf(stderr, "Keys may be specified as:\n");
	    fprintf(stderr, "	octal -- '075', '072'\n");
	    fprintf(stderr, "	dec -- '61', '58'\n");
	    fprintf(stderr, "	hex -- '0X3D', '0x3D', '0X3a', or '0x3a'\n");
	    fprintf(stderr, "	name -- 'c#3', 'Bb2'\n");
	    fprintf(stderr, "	        'c*', or 'G#*' imply all octaves.\n");
	    fprintf(stderr, "C4=C*, C*=D* are legal, but C*=D4 is not\n");
	    exit(2);
	}
	if (only == 0)
	    for (i = 128; --i >= 0; )
		if (Map[i] == -1)
		    Map[i] = i;
	for (now = 0l; mp = getmcmd(stdin, now); now = mp->when) {
	    cp = (char *) mp->cmd;
	    if ((*cp & M_CMD_MASK) == CH_KEY_ON
	     || (*cp & M_CMD_MASK) == CH_KEY_OFF)
		if ((cp[1] = Map[cp[1]]) == -1)
		    continue;
	    putmcmd(stdout, mp);
	}
	exit(0);
}

keynum(str)
char	*str;
{
	register char *cp;
	int note, oct;

	Alloct = 0;
	cp = str;
	if ('0' <= *cp && *cp <= '9') {		/* octal, decimal, or hex */
	    return(myatoi(cp));
	} else {				/* note name */
	    if ('A' <= *cp && *cp <= 'G')
		note = Noteval[*cp++ - 'A'];
	    else if ('a' <= *cp && *cp <= 'g')
		note = Noteval[*cp++ - 'a'];
	    else
		goto oops;
	    while (*cp == '#' || *cp == 'b') {
		note += (*cp == '#')? 1 : -1;
		cp++;
	    }
	    if (*cp == '*') {
		Alloct = 1;
		return((note + 120) % 12);
	    }
	    oct = atoi(cp);
	    if (oct < MINOCT || oct > MAXOCT) {
oops:
		fprintf(stderr, "Note format error: %s\n", str);
		exit(2);
	    }
	}
	return(12 * (oct - MINOCT) + note);
}

hex(c)
char	c;
{
	if ('0' <= c && c <= '9')
	    return(c - '0');
	if ('A' <= c && c <= 'F')
	    return(c - 'A' + 10);
	if ('a' <= c && c <= 'f')
	    return(c - 'a' + 10);
	fprintf(stderr, "Error in hex digit '%c'\n", c);
	return(0);
}
