/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that directly interface with the
 * kernel.  Currently, they are simulated in user-space.
 */

#include <sys/audit.h>
#include "audit.h"

/* p127 - return list of non-negative values that can be used for
   valid audit types recognized by the auditing component of the
   system.  The list is terminated by a negative value which is
   invalid as an audit type. */

const int *aud_get_all_evid(void)
{
    errno = ENOSYS;
    return NULL;
}

/* p114 - copy internal record to external representation. size is the 
   available space for the external representation - return its size. */

ssize_t aud_copy_ext(void *aud_rec_ext_p, aud_rec_t aud_rec_int, ssize_t size)
{
    errno = ENOSYS;
    return -1;
}

/* p115 - convert an external representation to an internal one -
   return handle to internal representation. */

aud_rec_t aud_copy_int(const void *aud_rec_ext_p)
{
    errno = ENOSYS;
    return NULL;
}

/* p160 - obtain the size (of external representation) of the audit
   record */

ssize_t aud_size(aud_rec_t ar)
{
    errno = ENOSYS;
    return -1;
}

/*
 * $Log$
 */
