#include <sys/time.h>

owait(fd,timeout)
	unsigned long timeout;	/* in seconds */
/*
 * Wait to write on 'fd' until it is ready, or timeout.
 * Return '>0' when 'fd' is ready, '0' if timeout, '-1' if error.
 * Example: after sending `play` data to the midi device,
 * you need to wait for it to finish playing before closing
 * the device:
 *
 * .in +5
 *	'while (owait(midi,0) == 0) ;'
 * .br
 *	'close(midi);'
 */
{
	struct timeval t;
	int writefd = 1 << fd;
	t.tv_sec = timeout, t.tv_usec = 0;
	return select(sizeof(int)*8, (int *)0, &writefd, (int *)0, &t);
}
