/* @(#)mpureg.h 1.4 87/05/06
** $Header: mpureg.h,v 1.6 89/01/05 17:40:47 psl Exp $
*/

/*
 * This driver currently attempts to support:
 *	MULTIBUS  -  Andy Voelkel's MultiBus card (single MPU)
 *	VMEBUS    -  Don Jackson's VMEBus card (four MPUs)
 *	VMEBUS    -  Dave Cumming's VMEBus card (four MPUs)
 */

#ifdef MULTIBUS

/* Each MultiBus board supports 1 MPU interface */
#define MPUS_PER_BOARD	1

/* MultiBus memory space required */
#define MPU_SIZE	0x100
#else /*VMEBUS*/

#define MPUS_PER_BOARD	4	/* Each VME board supports 4 MPU interfaces */
#define MPU_INTMASK	0x0F	/* interrupt bit mask (in mpuc_intmask) */

/* VMEBus memory space required */
#define MPU_SIZE	0x020
#endif /*VMEBUS*/

/* registers of each roland mpu-401 interface */
struct mpu_reg {
#ifdef MULTIBUS
	unsigned char	mpur_csr;	/* 00101 */
	unsigned char	mpur_data;	/* 00100 */
#else /*VMEBUS*/
	char _x0;			/* 00000 */
	unsigned char	mpur_data;	/* 00001 */
	char _x2;			/* 00010 */
	unsigned char	mpur_csr;	/* 00011 */
#endif /*VMEBUS*/
};

/* define some equivalences for readability */
#define	mpur_stat	mpur_csr
#define	mpur_com	mpur_csr


/* registers of the mpu-401 interface card */
struct mpu_ctlr {
	struct mpu_reg	mpur[MPUS_PER_BOARD];		/* each MPU's regs */
#ifndef MULTIBUS
    /* don jackson's board lets you know which MPUs are interrupting */
	char		_x16;		/* 10000 */
	unsigned char	mpuc_intmask;	/* 10001 */
#endif /*VMEBUS*/
};

/* where do we look to see if the interface card is there at all? */
#ifdef MULTIBUS
#define mpu_alive	mpur[0].mpur_stat
#else /*VMEBUS*/
#define mpu_alive	mpuc_intmask
#define mpu_reset	mpuc_intmask
#endif /*VMEBUS*/

#define bit(n)			(1 << (n))
#define UCH(ch)			((unsigned char) ch)

/* mpur_stat bits */
#define MPU_STAT_DRR		bit(6)
#define MPU_STAT_DSR		bit(7)

/* mpu commands (on command track) */
#define MPU_COM_CLRPLAYCNTRS	UCH(0xB8)
#define MPU_COM_CLRPLAYMAP	UCH(0xB9)
#define MPU_COM_RESET		UCH(0xFF)

/* mpu time tags (on play or conductor tracks) */
#define	MPU_TT_MAX		UCH(0xEF)
#define	MPU_TT_TCIP		UCH(0xF8)

/* mpu data (on play or conductor tracks) */
#define MPU_DAT_NOP		UCH(0xF8)
#define MPU_DAT_TCWME		UCH(0xF9)
#define MPU_DAT_DATAEND		UCH(0xFC)

/* mpu messages (sent by the MPU) */
#define	MPU_MESS_TRAKREQ0	UCH(0xF0)
#define	MPU_MESS_TRAKREQ7	UCH(0xF7)
#define	MPU_MESS_TIMOFLO	UCH(0xF8)
#define MPU_MESS_CONDREQ	UCH(0xF9)
/*#define MPU_MESS_CASSREQ	UCH(0xFA)	/* ??? */
#define MPU_MESS_DATAEND	UCH(0xFC)
#define MPU_MESS_CLK2HST	UCH(0xFD)
#define MPU_MESS_ACK		UCH(0xFE)
#define MPU_MESS_SYS		UCH(0xFF)

/* midi misc */
#define	MIDI_CMD_MASK		UCH(0xF0)
#define	MIDI_SX			UCH(0xF0)
#define	MIDI_END_SX		UCH(0xF7)

/* anything with bit 7 on ends sys excl, except RT and MIDI_SX itself */
#define	MIDI_EOX(b)		(((b)&bit(7))&&(b)<UCH(0xF8)&&(b)!=MIDI_SX)
