/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>
#include <time.h>
#include <math.h>
/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include <sys/param.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/errno.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/resource.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <ctype.h>

#include "bench.h"
#include "timefunc.h"
#include "get.h"
#include "load_percent.h"
#include "parse_file_list.h"
#include "debug.h"
#include "sysdep.h"

#define _BSD_SIGNALS
#define INFINITY 20000
#define DEFAULTWWWPORT 80
#define LOG_FILE "logfile"
#define CONNECT_TIMES 3
#define NCCARGS 4096

char 	webserver[MAXHOSTNAMELEN];

int	savefile = 0;
int 	portnum = DEFAULTWWWPORT;    

/* static int timeexpired = 0; */
int timeexpired = 0;

int	keepalive = 0;

int     debug = 0;

FILE    *debugfile = stderr;
FILE *logfile;

stats_t	timestat;

rqst_timer_t	timerarray[MAXNUMOFFILES];

file_list_t load_file_list[MAXNUMOFPAGES];

page_stats_t page_stats[MAXNUMOFPAGES];
page_stats_t page_stats_tmp;

/* End of globals */

static void
usage(const char *progname)
{
	fprintf(stderr,"Usage: %s [-d]  -w webserver  [-p port_num]\n", progname);
        fprintf(stderr,"          [-c masterhost:port]  [-t run_time | -l loops]\n");
        fprintf(stderr,"          [-n numclients]  [-R]\n");
	fprintf(stderr,"          [-f config_file]  [-u uilfile | uil ...]\n");
	errexit("\n");
} /* END usage() */


static void
alarmhandler()
{
  /* RECEIVED AN ALARM SIGNAL */
  D_PRINTF "Received alarm\n" D_FLUSH;
  timeexpired = 1;
} /* END alarmhandler() */

static void
childhandler()
{
  int status;

  /* RECEIVED A SIGNAL THAT A CHILD PROCESS HAS DIED */
  D_PRINTF "A child process has died\n" D_FLUSH;
  while (wait3(&status, WNOHANG, (struct rusage *)0) > 0)
    {
      /* do nothing */
      ;
    }
} /* END childhandler() */

char*
upper_case(char *name)
{
    int loop;
    int letter;
    for (loop=0; loop < 14; loop++)
    {
        letter = toupper(name[loop]);
	name[loop] = letter;
    }
    return name;
} /* END upper_case() */

int
connectsock(char *host, ushort portnum, char *protocol)
{
  struct hostent     *phe; /* pointer to host info */
  /* struct servent     *pse; NOT USED pointer to service info entry */
  /* struct protoent    *ppe; NOT USED pointer to protocol info entry */
  struct sockaddr_in sin;  /* an Internet endpoint address */
  int s;                   /* socket descriptor */
  int type;                /* socket type */
  int returnval;	   /* temporary return value */
  extern int h_errno;

  D_PRINTF "Beginning connectsock %s %d %s\n", host, portnum, protocol D_FLUSH;

  sin.sin_family = AF_INET;
  memset((char *)&sin, 0, sizeof(sin));
  D_PRINTF "Zeroed address structure, errno %d\n", errno D_FLUSH;

  
  /* NOT USED: map service name to port number
     We're taking the port number as an argument */
  sin.sin_port = htons(portnum);
  D_PRINTF "Set port number %d, errno %d\n", portnum, errno D_FLUSH;

  /* Map host name to IP address, allowing for dotted-decimal */
  phe = gethostbyname(host);
#ifdef SOLARIS
  D_PRINTF "Mapping host name %s returned %d errno %d, h_errno %d\n", 
    host, phe, errno, h_errno D_FLUSH;
#else
  D_PRINTF "Mapping host name %s returned %d errno %d, h_errno %d: %s\n", 
    host, phe, errno, h_errno, hstrerror(h_errno) D_FLUSH;
#endif

  if (phe == NULL)
    {
      return(returnerr("Can't get %s host entry\n",host));
    }
  memcpy((char *)&sin.sin_addr, phe->h_addr, phe->h_length);
  D_PRINTF "Memcpy hostname, errno %d\n", errno D_FLUSH;

  /* set address family to same type as master address */
  sin.sin_family = phe->h_addrtype;
  D_PRINTF "sin_family %d, errno %d\n", sin.sin_family, errno D_FLUSH;

  /* 
   * Don't map protocol name to protocol number 
   * some systems do a YP lookup every time
   *
   *  D_PRINTF "Mapping protocol name %s to number, errno %d\n",
   *    protocol, errno D_FLUSH;
   *  if ((ppe = getprotobyname(protocol)) == 0)
   *    {
   *      D_PRINTF "protobyname returned %d, errno %d: %s\n",
   *	ppe, errno, strerror(errno) D_FLUSH;
   *      return(returnerr("Can't get %s protocol entry\n",protocol));
   *    }
   *
   *  D_PRINTF "Protocol number %d, errno %d\n", ppe->p_proto, errno D_FLUSH;
   *
   */

  /* Use protocol to choose a socket type */
  if (strcmp(protocol,"udp") == 0)
      {
	type = SOCK_DGRAM;
      }
  else
      {
	type = SOCK_STREAM;
	D_PRINTF "Choosing SOCK_STREAM %d type %d, errno %d: %s\n", 
	  SOCK_STREAM, type, errno, strerror(errno) D_FLUSH;
      }

  /* Allocate a socket */
  s = socket(PF_INET, type, 0);
  D_PRINTF "Socket %d %d returned %d, errno %d\n",
	type, s, errno D_FLUSH;
  
  if (s < 0)
    {
      D_PRINTF "Can't create socket: %s\n",strerror(errno) D_FLUSH;
      return(returnerr("Can't create socket: %s\n",strerror(errno)));
    }
  
  /* Connect the socket */
  D_PRINTF "Trying to connect %d with size %d, errno %d\n",
	s, sizeof(sin), errno D_FLUSH;
  D_PRINTF "Address is family %d, port %d, addr %s, zero %s\n", 
	sin.sin_family, ntohs(sin.sin_port),
	inet_ntoa(sin.sin_addr), sin.sin_zero D_FLUSH;
  returnval = connect(s, (struct sockaddr *)&sin, sizeof(sin));
  D_PRINTF "Connect returned %d, errno %d: %s\n", 
	returnval, errno, strerror(errno) D_FLUSH;
  if (returnval < 0)
    {
      D_PRINTF "Connect error\n" D_FLUSH;
      D_PRINTF "Can't connect: %s\n", strerror(errno) D_FLUSH;
      close(s);
      if (timeexpired) { return(-1); }
      return(returnerr("Can't connect %s\n", strerror(errno)));
    }

  /* all done, returning socket descriptor */
  D_PRINTF "Returning %d, errno %d after connectsock call\n", 
	s, errno D_FLUSH;
  return(s);

} /* END connectsock() */

int
connecttomaster(char *ConnectStr)
{
    char   *tempch;
    int	   sock;
    char	msg[GOSTRLEN+1];

    /*
     * BREAK UP THE connectstr INTO A HOSTNAME/HOST-IP AND A PORT NUMBER.
     */
    if((tempch = strpbrk(ConnectStr,":")) == NULL)
    {
        /*
         * INCORRECT FORMAT OF ConnectStr. CORRECT FORMAT IS
         * HOSTNAME:PORT OR HOST-IP:PORT
         */
        D_PRINTF "Incorrect format %s: use hostname:port or ip_addr:port\n",
	  ConnectStr D_FLUSH;
        return(returnerr("Incorrect format %s: use host:port or ip_addr:port\n"
		,ConnectStr));
    }

    /*
     * ZERO OUT THE COLON SO WE HAVE TWO STRINGS, THE HOSTNAME AND THE PORT
     */
    *tempch = '\0';
    tempch++;
    
    sock = connectsock(ConnectStr,atoi(tempch),"tcp");

    if (sock < 0)
      {
       	/*
       	  ERROR CONNECTING TO MASTER PROCESS.
       	*/
       	return(returnerr("Could not connect to master process\n"));
      }

    /*
     * SIGNAL THE MASTER THAT WE ARE READY TO PROCEED.  WHEN ALL
     * CHILD PROCESSES HAVE CONNECTED AND SENT THIS SIGNAL,
     * THE MASTER WILL ISSUE US A GO SIGNAL.
     */
    if(write(sock,READYSTR,READYSTRLEN) != READYSTRLEN)
      {
        return(returnerr("Error sending READY message to master: %s\n",
		strerror(errno)));
      }
   
    memset(msg,0,GOSTRLEN+1);
    if(read(sock,msg,GOSTRLEN) != GOSTRLEN)
    {
	D_PRINTF "Error receiving GO message from master, %d: %s\n",
	   errno, strerror(errno) D_FLUSH;

        return(returnerr("Error receiving GO message from master\n"));
    }

    if(strncmp(GOSTR,msg,GOSTRLEN))
    {
       /*
        * WE RECEIVED A MESSAGE OTHER THAN GO. PRINT IT OUT AND RETURN ERROR
        */
       return(returnerr("Received non-GO message %s\n",msg));
    }

    /* RETURN sock DESCRIPTOR */
      return(sock);

} /* END connecttomater() */


void
accumpagestats(rqst_timer_t *rqsttimer, page_stats_t *pagestats)
{
    struct timeval	dtime;
    rqst_stats_t	rqststats; 

    rqstat_times(&(rqststats), rqsttimer);
    rqstat_sum(&(pagestats->rs), &(rqststats));

} /* END accumpagestats() */

void
accumtimestats(rqst_timer_t *rqsttimer, stats_t *timestat)
{
    struct timeval	dtime;
    struct timeval	sqdtime;
    rqst_stats_t	rqststats; 

    /*
     * DUMP THE TIMING INFORMATION HERE, OR COMPUTE WHAT YOU WANT TO
     * PRINT OUT LATER.
     */

    D_PRINTF "Total bytes read: %d \t Body size read: %d\n",
	rqsttimer->totalbytes,
	rqsttimer->bodybytes D_FLUSH;
    D_PRINTF "Enter time:     %10d.%06d \t Exit Time:     %10d.%06d\n",
	rqsttimer->entertime.tv_sec,
	rqsttimer->entertime.tv_usec,
	rqsttimer->exittime.tv_sec,
	rqsttimer->exittime.tv_usec D_FLUSH;
    D_PRINTF "Before connect: %10d.%06d \t After connect: %10d.%06d\n",
	rqsttimer->beforeconnect.tv_sec,
	rqsttimer->beforeconnect.tv_usec,
	rqsttimer->afterconnect.tv_sec,
	rqsttimer->afterconnect.tv_usec D_FLUSH;
    D_PRINTF "Before header:  %10d.%06d \t After header:  %10d.%06d\n",
	rqsttimer->beforeheader.tv_sec,
	rqsttimer->beforeheader.tv_usec,
	rqsttimer->afterheader.tv_sec,
	rqsttimer->afterheader.tv_usec D_FLUSH;
    D_PRINTF "After body:     %10d.%06d\n",
	rqsttimer->afterbody.tv_sec,
	rqsttimer->afterbody.tv_usec D_FLUSH;

    rqstat_times(&(rqststats), rqsttimer);
    rqstat_sum(&(timestat->rs), &(rqststats));

    if (rqsttimer->page_number != 999)
    {
	timestat->page_numbers[rqsttimer->page_number] += 1;
    }

} /* END accumtimestats */

int 
makeload(int maxcount, int pageval)
{
  int cnt;
  int returnval;
  
  D_PRINTF "Starting makeload()\n" D_FLUSH;

  page_stats_init(&page_stats_tmp);
  
  for (cnt = 0; cnt < maxcount; cnt++)
    { 
      if (pageval == -1)
	{
	  pageval = cnt;
	}
      if (timeexpired) 
	{
	  break;
	}
      returnval = get(webserver, portnum, 
		      load_file_list[pageval].filename[cnt],
		      &(timerarray[cnt]), (keepalive && cnt < (maxcount-1)));
      if (returnval < 0)
	{
	  D_PRINTF "get() returned an error\n" D_FLUSH;
	}
      
      /* 
       * DID GET() RETURN A VALID TIME?
       * WHY NOT USE returnval HERE?
       */
      if ((returnval == 0) && (timerarray[cnt].valid == 2))
	{
	  timerarray[cnt].page_number = 999;
	  timerarray[cnt].page_number = pageval;
	  
	  accumpagestats(&(timerarray[cnt]),&page_stats_tmp);
	  accumtimestats(&(timerarray[cnt]),&timestat);
	}
      else if (!timeexpired) /* INVALID, INCREMENT THE ERROR COUNTER */
	{
	  D_PRINTF "GET error counter incremented\n" D_FLUSH;
	  timestat.rs.totalerrs++;
	}

      if (timeexpired)
	{
	  break;
	}
    } /* END for cnt */
  
   
  /* 
   * DO WE HAVE A VALID RETURN FROM GET()? 
   * WHY NOT USE returnval HERE?
   */
  if ((returnval == 0) &&
      (cnt == load_file_list[pageval].num_of_files) && 
      (timerarray[(cnt)-1].valid == 2))
    {
      rqst_stats_t *ps_rs;
      rqst_stats_t *pst_rs;
      
      ps_rs = &(page_stats[pageval].rs);
      pst_rs = &(page_stats_tmp.rs);
      
      rqstat_sum(ps_rs, pst_rs);
      
      page_stats[pageval].totalpages++;
      
      if (page_stats[pageval].page_size == 0)
	{
	  page_stats[pageval].page_size = 
	    page_stats_tmp.rs.totalbody;
	}
    }
  else if (!timeexpired) /* INVALID, SO INCREMENT THE ERROR COUNT */
    {
      D_PRINTF "GET error counter incremented\n" D_FLUSH;
      timestat.rs.totalerrs++;
    }

  D_PRINTF "Makeload output: %d errors, %d pages\n",
            timestat.rs.totalerrs, page_stats[pageval].totalpages D_FLUSH;
  D_PRINTF "Makeload returning %d\n", cnt D_FLUSH;
  
  return(cnt);

} /* END makeload() */

void
main(int argc, char *argv[])
{
    int 	numfiles;
    int		testtime = 0;
    int		havewebserver = 0;
    int 	numloops = 0;
    int		cnt;
    int		returnval;
    int         error;
    int		amclient = 0;
    int		numclients = 0;
    int		record_all_transactions = 0;
    int		sock;
    int		loopcnt = 0;
    int		filecnt;
    int		loop;
    int		uil_filelist_f = 0; /* filedescriptor of URLs to fetch? */
    int		number_of_pages;
    int		ran_number;
    int		page_index;
    int		page_number;
    int		tmp_file_cnt=0;
    int		file_count=0;
    double	sec;
    double	usec;
    char	uil_filelist[NCCARGS];
    char	configfile[MAXPATHLEN];
    char 	filelist[256][MAXPATHLEN];
    char	connectstr[MAXHOSTNAMELEN+10];
    char	format_string[255];
    char	file_name[50];
    int		getoptch;
    int		currarg;
    int		bytes_written;
    double 	thruput;
    struct timeval	dtime;
    struct timeval	sqdtime;
    struct timeval	runningtime;
    extern char	*optarg;
    extern int	optind;
    FILE    *file_list_fp;
    int  pages[MAXNUMOFPAGES];
    time_t  running_time;
    time_t  junk;
    int		i;

int bytes_to_write;
void *wptr;

    struct sigaction csact, asact, ocsact, oasact;

    /*
     * INITIALIZE DATA
     */

    D_PRINTF "Running in debug mode\n" D_FLUSH;

    memset(webserver, 0, MAXHOSTNAMELEN);
    page_stats_init(&page_stats_tmp);

    for (i=0; i < MAXNUMOFPAGES; i++) {
        page_stats_init(&(page_stats[i]));
    }


    /* 
     * PARSE THE COMMAND LINE OPTIONS
     */

    while((getoptch = getopt(argc,argv,"f:t:l:p:u:R:w:c:n:sdk")) != EOF)
    {
        switch(getoptch)
        {
	    case 'c':
                sprintf(connectstr,"%s",optarg);
	        amclient = 1;
                printf("%s",OKSTR);
                fflush(stdout);
	        break;
            case 'd':
                debug = 1;
                break;
            case 'f':
                sprintf(configfile,"%s",optarg);
                break;
	    case 'k':
		keepalive = 1;
		break;
            case 'l':
                numloops = atoi(optarg);
	        if(testtime != 0)
                {
	            /*
                     * EITHER numloops OR testtime, BUT NOT BOTH.
                     */
                    usage(argv[0]);
                }
                break;
            case 'n':
                numclients = atoi(optarg);
                break;
	    case 'u':
		sprintf(uil_filelist, "%s", optarg);
		uil_filelist_f = 1;
		break;
	    case 'p':
                portnum = atoi(optarg);
                break;
	    case 's':
	        savefile = 1;
                break;
            case 't':
                testtime = 60 * atoi(optarg);
	        if(numloops != 0)
                {
	            /*
                     * EITHER numloops OR testtime, BUT NOT BOTH.
                     */
                    usage(argv[0]);
                }
                break;
            case 'w':
                havewebserver = 1;
                sprintf(webserver,"%s",optarg);
                break;
	    case 'R':	
		record_all_transactions = 1;
		break;
            default:
                usage(argv[0]);
        }
    }

    if(havewebserver != 1)
    {
        /*
         * THE SERVER'S NAME MUST BE SPECIFIED
         */
        fprintf(stderr,"No WWW Server specified\n");
        usage(argv[0]);
    }

    currarg = optind;
    numfiles = 0;
    while(currarg != argc)
    {
       /*
        * GET THE URLS TO RETRIEVE.
        */        
       sscanf(argv[currarg],"%s",filelist[numfiles]);
       numfiles++;
       currarg++;
    }

    if((numfiles == 0) && !(uil_filelist_f))
    {
        /*
         * AT LEAST ONE FILE MUST BE SPECIFIED
         */
	fprintf(stderr,"No UIL resources or filelist specified \n");
        usage(argv[0]);
    }

    if((numloops == 0) && (testtime == 0))
    { 
        /*
         * NO SPECIFIED NUMBER OF LOOPS, AND NO TEST TIME
         */
       usage(argv[0]);
    }

    /*
     * IF WE ARE TO FORK ADDITIONAL CLIENTS ON THIS MACHINE,
     * WE MUST DO IT BEFORE WE CONNECT TO THE MASTER.
     *
     * FIRST, SET UP SIGNAL HANDLING
     */
#ifdef SOLARIS
    csact.sa_handler = childhandler;
    csact.sa_flags = SA_RESTART;
    sigaction(SIGCHLD, &csact, &ocsact);
#else
    signal(SIGCHLD, childhandler);
#endif

    while(numclients > 1)
    {
        switch(fork())
        {
            case 0:
                /*
                 * CHILD
                 */
                numclients = 1;
                break;
            case -1:
                /*
                 * ERROR
                 */
                errexit("Error forking child processes\n");
                exit(1);
            default:
               /*
                * PARENT
                */
               numclients--;
               break;
        }	
	/* SLEEP CALL SO WE DON"T FLOOD THE SERVER */
#ifdef NAP
	nap(10);
#else
	sleep(1);
#endif
    }

    /* Let the user know we're up */
    fputc('.', stdout);
    fflush(stdout);
    
    if (debug)
      {
	/*
	 *  OPEN A DEBUG FILE
	 */
	fflush(stderr);
	sprintf(file_name,"/var/tmp/webstone-debug.%d",getpid());
	debugfile = fopen(file_name, "w+");
	D_PRINTF "Running in debug mode, %d\n",amclient D_FLUSH;
      }
    if (record_all_transactions)
      {
	/* 
	 *  OPEN A LOG FILE.
	 */
	sprintf(file_name, "%s%d", LOG_FILE, getpid());
	fprintf(stdout, "%s\n", file_name);
	logfile = fopen(file_name, "w+");
      }

    /* Initialize random number generator */
    junk = getpid();
    srandom (junk);
    D_PRINTF "Random seed: %d\n", junk D_FLUSH;

    if (uil_filelist_f)
    {
      /* IF WE HAVE A FILELIST, PARSE IT */	
      parse_file_list(uil_filelist, load_file_list, 
		      &number_of_pages, &numfiles);
      load_percent (load_file_list, number_of_pages, pages);
    }

    for (i=0; i < MAXNUMOFFILES; i++) 
      {
	rqtimer_init(&(timerarray[i]));
      }
    stats_init(&timestat);

    D_PRINTF "Number of files %d\n", numfiles D_FLUSH;

    timestat.total_num_of_files = numfiles;

    if(amclient)
    {	
        /*
         * WE ARE A CLIENT PROCESS. (i.e. WE ARE NOT RUN BY A USER, BUT BY
         * THE MASTER WWWSTONE PROCESS. WE NEED TO CONNECT TO THE
         * MASTER WHO WILL SYNCHRONIZE ALL THE CLIENTS.
         */
      D_PRINTF "Trying to connect with %s\n",connectstr D_FLUSH;

      sock = connecttomaster(connectstr);

      D_PRINTF "connecttomaster returns %d, errno %d: %s\n",
	sock, errno, strerror(errno) D_FLUSH; 

      if(sock < 0)
        {
            /*
             * ERROR CONNECTING TO THE MASTER. ABORT.
             */
            errexit("Error connecting to the master: %s\n",strerror(errno));
        }
    } /* END IF CLIENT */

    /*
     * AND THEY'RE OFF...
     */

    if(testtime != 0)
    {
       /*
        * IF RUNNING A TIMED TEST, WE WILL LOOP 
	* UNTIL THE ALARM GOES OFF.
        * WE'LL ALSO NEED TO SET THE SIGNAL HANDLER
        */
       numloops = INFINITY;

#ifdef SOLARIS
	asact.sa_handler = alarmhandler;
	asact.sa_flags = SA_RESTART;
	sigaction(SIGALRM, &asact, &oasact);
#else
	signal(SIGALRM, alarmhandler);
#endif

       /*
        * SEND SIGALRM IN testtime SECONDS
        */
       alarm(testtime);
    }

    /* GET START TIME, ZERO LOOP COUNTER */
    loopcnt = 0;
    gettimeofday(&(timestat.starttime), NULL);

    /* LOOP UNTIL WE HIT numloops, OR WE RUN OUT OF TIME */
    while((loopcnt < numloops) && !(timeexpired))
    {
	/*
	 * THIS IS WHERE LOAD TESTING IS DONE. 
	 * GET A RANDOM NUMBER, THEN INDEX INTO THE 
	 * PAGE, AND THEN REQUEST THAT SET OF FILES.
	 */
	if (uil_filelist_f) /* HAVE FILELIST */
	{
	    if (testtime != 0) /* RUNNING IN TIMED MODE */
	    {
		ran_number =  random_number();
		D_PRINTF "random %d  page index %d\n",
		  ran_number, pages[ran_number - 1] D_FLUSH;
	    
		page_index = pages[ran_number - 1];
		filecnt = makeload(load_file_list[page_index].num_of_files, 
				   page_index);
		
		if (filecnt > 0) 
		{
		   tmp_file_cnt += (filecnt - 1);
		   file_count += filecnt;		   
		} /* end if */
	    } 
	    else /* NOT RUNNING IN TIMED MODE */
	    {
		for (page_number = 0; 
		     page_number < number_of_pages; 
		     page_number++)
		{
		  filecnt = makeload(load_file_list[page_number].num_of_files, 
			   page_number);

		if (filecnt > 0)
		{
		   tmp_file_cnt += filecnt;
		   file_count += filecnt;
		} /* end if */
				    
		} /* END for page_number */			
	    } /* END if/else TIMED MODE */		    	    
	}
	else /* NO FILELIST */
	{
	  D_PRINTF "No filelist\n" D_FLUSH;
	   /*
	    * LOOP THROUGH UNTIL numfiles TIMES OR UNTIL TIMER EXPIRES
	    * AND ALARM SETS filecnt TO INFINITY.
	    */
	  filecnt = makeload(numfiles, -1);
		    
	  tmp_file_cnt += filecnt;
	  file_count += filecnt;		    
	} /* END if HAVE FILELIST */
	
	if (!timeexpired) /* IS TIME UP? */
	  {
	    loopcnt++;
	  } /* END if TIME'S UP */
    } /* END while loopcnt */

    gettimeofday(&(timestat.endtime), NULL);
    D_PRINTF "Time's up\n" D_FLUSH;
    signal(SIGALRM, NULL);

    if (testtime == 0)
    {
	numfiles = loopcnt;
    
	if (uil_filelist_f)
	  { 
	    numfiles = file_count;
	  }
    }

    if (record_all_transactions)
    {
       /*
	* DUMP THE LOG FILE INFORMATION.
	*/
	for (loop=0; loop < (loopcnt * file_count); loop++)
	{
	    sprintf(format_string, " entertime \t%d.%d\n beforeconnect \t%d.%d\n afterconnect \t%d.%d\n beforeheader \t%d.%d\n afterheader \t%d.%d\n afterbody \t%d.%d\n exittime \t%d.%d\n total bytes \t%d\n body \t%d\n", 
		timerarray[loop].entertime.tv_sec,
		timerarray[loop].entertime.tv_usec,
		timerarray[loop].beforeconnect.tv_sec,
		timerarray[loop].beforeconnect.tv_usec,
		timerarray[loop].afterconnect.tv_sec,
		timerarray[loop].afterconnect.tv_usec, 
		timerarray[loop].beforeheader.tv_sec,
		timerarray[loop].beforeheader.tv_usec,
		timerarray[loop].afterheader.tv_sec,
		timerarray[loop].afterheader.tv_usec, 
		timerarray[loop].afterbody.tv_sec,
		timerarray[loop].afterbody.tv_usec,
		timerarray[loop].exittime.tv_sec,
		timerarray[loop].exittime.tv_usec,
		timerarray[loop].totalbytes,
		timerarray[loop].bodybytes);  
	    fwrite(format_string, sizeof(format_string), 1, logfile);
	}
    }

    D_PRINTF "total errors: %d\n",timestat.rs.totalerrs D_FLUSH;
    gethostname(timestat.hostname,MAXHOSTNAMELEN);
    D_PRINTF "Test for host: %s\n",timestat.hostname D_FLUSH;
    D_PRINTF "Server is: %s running at port number: %d\n",
	webserver,portnum D_FLUSH;

    sprintf(timestat.hostname,"%s:%d",timestat.hostname,getpid());

    if(amclient) /* CLIENT TO A WEBMASTER */
      {
        /*
         * WRITE THE DATA ON THE SOCKET TO THE MASTER
         */
	D_PRINTF "Writing data to master, errno %d\n", errno D_FLUSH;
	bytes_to_write = sizeof(stats_t);
	bytes_written = 0;
	wptr = &timestat;
	while (bytes_to_write)
	   {
		D_PRINTF "Trying %d bytes timestats, errno %d\n", 
		   sizeof(timestat), errno D_FLUSH;
        	returnval = write(sock,wptr,bytes_to_write);
		D_PRINTF "Wrote %d bytes timestats to master, errno %d\n", 
		   returnval, errno D_FLUSH;
		bytes_written += returnval;
		wptr += returnval;
		bytes_to_write -= returnval;
           }
	if (uil_filelist_f)
	  {
	    bytes_to_write = sizeof(page_stats_t)*MAXNUMOFPAGES;
	    bytes_written = 0;
	    wptr = page_stats;
	    while (bytes_to_write)
	      {
		D_PRINTF "Trying %d bytes pagestats, errno %d\n", 
		   sizeof(page_stats), errno D_FLUSH;
	    	returnval = write(sock,wptr, bytes_to_write);
		D_PRINTF "Wrote %d bytes pagestats to master, errno %d\n", 
		   returnval, errno D_FLUSH;
		bytes_written += returnval;
		wptr += returnval;
		bytes_to_write -= returnval;
	      }
	  }
	D_PRINTF "About to close socket, errno %d\n", errno D_FLUSH;
        close(sock);
	D_PRINTF "Closed socket, errno %d\n", errno D_FLUSH;
      }
    else /* NOT A CLIENT TO A WEBMASTER */
      {
	if(testtime != 0)
	  {
	    printf("Test ran for: %d minutes\n",(testtime/60));
	  } 
	else
	  {
	    printf("Test ran for: %d iterations.\n",numloops);
	  }
	compdifftime(&(timestat.endtime), &(timestat.starttime), 
		     &(runningtime));
	printf("Total time of test (sec) %d.%d\n", runningtime.tv_sec, 
	       runningtime.tv_usec);
	printf("Files retrieved per iteration: %d\n",numfiles);
	printf("----------------------------------\n");
	rqstat_print(&(timestat.rs));
	
	printf("Thruput = %1.0lf bytes/sec\n",
	       thruputpersec(timestat.rs.totalbytes, &(timestat.datatime)));
	
	if (uil_filelist_f)
	  {
	    for (loop = 0; loop < 100; loop++)
	      {
		if (timestat.page_numbers[loop] != 0)
		  {
		    printf ("Page # %d\n", loop);
		    printf ("===============================================================================\n");
		    printf ("Total number of times page was hit %d\n",
			    page_stats[loop].totalpages); 
		    rqstat_print(&(page_stats[loop].rs));
		    printf ("Page size %d \n", page_stats[loop].page_size);
		    printf ("===============================================================================\n\n");
		  } /* END if timestat */
	      } /* END for loop */
	  } /* END if filelist */
      } /* END if client */


    /*
     * Wait for all children to exit.
     */
    for(;;) 
      {
    	int pid = wait((int*)0);
	if ((pid == -1) && errno == ECHILD) break;
      }

    if(record_all_transactions)
	fclose(logfile);
    if(debug)
      {
	D_PRINTF "Client exiting.\n" D_FLUSH;
	fclose(debugfile);
      }

    exit(0);
} /* END main() */
