/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#include <netdb.h>
#include <sys/time.h>
#include <sys/param.h>
#include <math.h>
#include <stdio.h>

#include "timefunc.h"
#include "bench.h"
#include "statistics.h"
#include "sysdep.h"

double
timevaldouble(struct timeval *tin)
{
    return ((double)tin->tv_sec + ((double)tin->tv_usec / USECINSEC));
}


void
doubletimeval(double tin, struct timeval *tout)
{
    tout->tv_sec = floor(tin);
    tout->tv_usec = (tin - tout->tv_sec) * USECINSEC ;
}


void
addtime(struct timeval *OrigTime, struct timeval *NewTime)
{
    OrigTime->tv_usec += NewTime->tv_usec;
    if(OrigTime->tv_usec >= USECINSEC)
    {
        /*
         * NEED TO CARRY 1.
         */
        OrigTime->tv_sec++;
        OrigTime->tv_usec -= USECINSEC;
    }
    OrigTime->tv_sec += NewTime->tv_sec;
}


void
compdifftime(struct timeval *EndTime, struct timeval *StartTime, struct timeval *DiffTime)
{
      struct timeval endtime = *EndTime;

      if((endtime.tv_usec - StartTime->tv_usec) < 0)
      {
         /*
          * NEED TO BORROW.
          */
          endtime.tv_usec += USECINSEC;
          endtime.tv_sec--;
      }
      DiffTime->tv_usec = endtime.tv_usec - StartTime->tv_usec;
      DiffTime->tv_sec =  endtime.tv_sec  - StartTime->tv_sec;
}


void
mintime(struct timeval *CurrMaxTime, struct timeval *CheckMaxTime)
{
    if(CheckMaxTime->tv_sec < CurrMaxTime->tv_sec)
    {
       *CurrMaxTime = *CheckMaxTime;
       return;
    }
    if(CheckMaxTime->tv_sec == CurrMaxTime->tv_sec)
    {
        if(CheckMaxTime->tv_usec < CurrMaxTime->tv_usec)
        {
           *CurrMaxTime = *CheckMaxTime;
           return;
        }
    }
}


void
maxtime(struct timeval *CurrMaxTime, struct timeval *CheckMaxTime)
{
    if(CheckMaxTime->tv_sec > CurrMaxTime->tv_sec)
    {
       *CurrMaxTime = *CheckMaxTime;
       return;
    }
    if(CheckMaxTime->tv_sec == CurrMaxTime->tv_sec)
    {
        if(CheckMaxTime->tv_usec > CurrMaxTime->tv_usec)
        {
           *CurrMaxTime = *CheckMaxTime;
           return;
        }
    }
}

void
avgtime(struct timeval *TotalTime, int NumTimes, struct timeval *AvgTime)
{
    double	meantime;

    meantime = mean(timevaldouble(TotalTime), NumTimes);

    doubletimeval(meantime, AvgTime);
}


void
sqtime(struct timeval *Time, struct timeval *SqTime)
{
    double 	sec;

    sec = timevaldouble(Time);
    sec *= sec;	 /* square */

    doubletimeval(sec, SqTime);
}


void
variancetime(struct timeval *SumTime, double SumSquareTime, int NumTimes, struct timeval *VarianceTime)
{
    double	result;

    result = variance(timevaldouble(SumTime), SumSquareTime, NumTimes);

    doubletimeval(result, VarianceTime);
}


void
stddevtime(struct timeval *SumTime, double SumSquareTime, int NumTimes, struct timeval *StdDevTime)
{
    double	result;

    result = stddev(timevaldouble(SumTime), SumSquareTime, NumTimes);

    doubletimeval(result, StdDevTime);
}

double
thruputpersec(unsigned n, struct timeval *t)
{
	return n / timevaldouble(t);
}


#if TEST
struct timeval  testtimes[] = {
	{ 0, 10000 },
	{ 1, 20000 },
	{ 2, 30000 },
	{ 3, 40000 },
	{ 4, 50000 },
	0
};

main()
{
	struct timeval  sum = { 0, 0 };
	struct timeval  sqsum = { 0, 0 };
	struct timeval  result;
	int i;

	for (i = 0; i <= 4 ; i++)
	{
		struct timeval sq;

		addtime(&sum, &(testtimes[i]));

		sqtime(&(testtimes[i]), &sq);
		addtime(&sqsum, &sq);
	}

	avgtime(&sum, i, &result);
	printf ("mean     = %d.%6.6d\n", result.tv_sec, result.tv_usec);

	avgtime(&sqsum, i, &result);
	printf ("mean sqs = %d.%6.6d\n", result.tv_sec, result.tv_usec);

	variancetime(&sum, &sqsum, i, &result);
	printf ("variance = %d.%6.6d\n", result.tv_sec, result.tv_usec);

	stddevtime(&sum, &sqsum, i, &result);
	printf ("std dev  = %d.%6.6d\n", result.tv_sec, result.tv_usec);
}
#endif /* TEST */
