/**************************************************************************
 *									  *
 * 		 Copyright (C) 1995 Silicon Graphics, Inc.		  *
 *									  *
 *  These coded instructions, statements, and computer programs  where	  *
 *  deveolped by SGI for public use.  If anychanges are made to this code *
 *  please try to get the changes back to the author.  Feel free to make  *
 *  modfications and changes to the code and release it.		  *
 *									  *
 **************************************************************************/

#ifdef NAP
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#endif

/* Sun OS */
#ifdef SUNOS

extern int sys_nerr;
extern char *sys_errlist[];
extern int errno;

char *strerror(int errnum) { /* strerror is not available on SunOS 4.1.3 */

	if (errnum<sys_nerr) {
		return(sys_errlist[errnum]);
	}

	return(NULL);
}

#endif /* SunOS */

#ifdef NAP
/*
 * Speed things up a bit by shortening synchronization delays.
 */
void
nap(usec)
	 int usec;
{
  struct timeval tv;

  tv.tv_sec = 0;
  tv.tv_usec = usec;
  select(0, 0, 0, 0, &tv);
}
#endif NAP
