/*
 * Send random bits file
 *
 * Once this service function is installed, any file with the extension
 * "dyn-send" will be serviced with this function.  An optional query
 * string may be passed to alter the amount of data in the response.
 *
 * For example:
 *      /file.dyn-send                  - returns a 10240 byte file
 *      /file.dyn-send?size=20          - returns a 20 byte file
 *      /file.dyn-send?size=1024        - returns a 1024 byte file
 *      etc.
 *
 * To install the service routine, compile it as per the makefile
 * included with your Netscape server distribution
(serverroot/nsapi/examples)
 * and then add the following lines to your netscape server
configuration:
 *
 * in magnus.conf
 *      Init fn=load-modules shlib=example.so funcs=nsapi-send
 *
 * in obj.conf
 *      Service method=(GET|HEAD) fn=nsapi-send
type=magnus-internal/dyn-send
 *
 * in mime.types
 *      type=magnus-internal/dyn-send        exts=dyn-send
 *
 * Mike Belshe
 * mbelshe@netscape.com
 * 11-5-95
 *
 */

#include "base/pblock.h"
#include "base/session.h"
#include "frame/req.h"
#include "frame/protocol.h"
#include "base/util.h"
#include "frame/http.h"

#define FILE_SIZE       10240
#define MALLOC_FAILURE  "Out of memory"

int nsapi_send(pblock *pb, Session *sn, Request *rq)
{
        char *query_string;
        char *buffer;
        int filesize;
        int index;

        /* Get the query string, if any; check to see if an alternate
         * file size was specified.
         */
        if ( !(query_string = pblock_findval("query", rq->reqpb)) )
                filesize = FILE_SIZE;
        else {
                if ( !strncmp(query_string, "size=", 5) )
                        filesize = atoi(&(query_string[5]));
                else
                        filesize = FILE_SIZE;
        }

        /* Set the context type */
        param_free(pblock_remove("content-type", rq->srvhdrs));
        pblock_nvinsert("content-type", "text/plain", rq->srvhdrs);

        /* Start the protocol response */
        protocol_status(sn, rq, PROTOCOL_OK, NULL);
        protocol_start_response(sn, rq);

        /* Allocate the output buffer */
        if ( !(buffer = (char *)malloc(filesize)) ) {
                net_write(sn->csd, MALLOC_FAILURE,
strlen(MALLOC_FAILURE));
                return REQ_ABORTED;
        }

        /* Generate the output */
        for (index=0; index < filesize; index++)
                /* generate random characters from A-Z */
                buffer[index] = rand() %26 + 63;

        /* Send the output */
        if (net_write(sn->csd, buffer, filesize) == IO_ERROR)
                return REQ_EXIT;

        free(buffer);

        return REQ_PROCEED;
}
