#@package: show_procedures showproc showprocs

# This is a replacement showproc that dumps the Default value
# information for arguments. The original did not do this.
# Thanks to Lance Ellinghouse <lance@markv.com>

proc showproc {procname} {
    if [lempty [info procs $procname]] {demand_load $procname}
	set arglist [info args $procname]
	set nargs {}
	while {[llength $arglist] > 0} {
	    set varg [lvarpop arglist 0]
	    if [info default $procname $varg defarg] {
		lappend nargs [list $varg $defarg]
	    } else {
		lappend nargs $varg
	    }
    }
    format "proc %s \{%s\} \{%s\}\n" $procname $nargs [info body $procname]
}


proc showprocs {args} {
    if [lempty $args] { set args [info procs] }
    set out ""

    foreach i $args {
	foreach j $i { append out [showproc $j] "\n"}
    }
    return $out
}




