
# line 2 "gs_pp_par.y"

/************************************************************************\
*                                                                        *
*  GS: A Generalized, stochastic petri net Simulator                     *
*      V0.01      March 1989      Andreas Nowatzyk (agn@unh.cs.cmu.edu)  *
*      Carnegie-Mellon Univerity, School of Computer Science             *
*      Schenley Park, Pittsburgh, PA 15213                               *
*                                                                        *
\************************************************************************/

/*
 *  Grammar of the GSPN-Simuator input format.
 *
 *  I know that this isn't compatible with GreatSPAN's files,
 *  but I want something that could be understood with an normal
 *  text editor as well as with a specialized graphic tool. A simple
 *  list of numbers isn't my style.
 *
 */

#include <strings.h>
#include <stdio.h>
#include "gs_pp.h"

char src_file[80] = "<stdin>", it_opr;


# line 32 "gs_pp_par.y"
typedef union  ytoken { char *SYM; double VALUE;} YYSTYPE;
# define NAME 257
# define REL_OP 258
# define VAL 259
# define END 260
# define TERM 261
# define SEP 262
# define COL 263
# define NEXT 264
# define NOT 265
# define RATE 266
# define MARKS 267
# define DEPEND 268
# define DET 269
# define IMM 270
# define EXP 271
# define TRANS 272
# define PLACE 273
# define RESULT 274
# define PARAM 275
# define PROB 276
# define OP_BR 277
# define CL_BR 278
# define OP_PAR 279
# define CL_PAR 280
# define COND 281
# define AND 282
# define OR 283
# define HASH 284
# define PLUS 285
# define MINUS 286
# define BIMOD 287
# define NORM 288
# define DWT 289
# define FIRE 290
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 149 "gs_pp_par.y"


#include "gs_pp_lex.c"
#include "gs_pp.c"
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 60
# define YYLAST 182
short yyact[]={

  73,  90,  33,  34,  35,  72,  60,  61,  87, 110,
  95,  31,  94,  95,  96, 104,  95,  96,  74,  75,
  36,  37,  88,   8,  42, 103, 107,  90,  95,  96,
 101,   8,  83, 102,  82,  13,  81,  80,  56,  10,
   9,  12,  11,  46,  67,  47,  38,  10,   9,  12,
  11,  66,  68,  39,  19,  18,  17,  16,  15,  65,
  58,  64,  57,  41, 108,  40,  59,  26,  99, 100,
  93,  92,  84,  77,  27,  22,  21,  20,  85,  89,
  62,  45,  43,  30,   3,  71,  70,  14,  53,  23,
  44,  76,  55,  32,  25,  29,  28,  24,   7,   6,
   5,   4,   2,  63,  86,  52,   1,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,  48,  49,  50,
  51,   0,   0,  54,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  69,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  78,  79,   0,   0,   0,   0,   0,   0,   0,
   0,  91,   0,   0,   0,   0,  97,  98,   0,   0,
   0,   0,   0,   0, 105, 106,   0,   0,   0,   0,
   0, 109 };
short yypact[]={

-233,-1000,-225,-1000,-203,-204,-205,-206,-207,-180,
-181,-182,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-192,-183,-256,-267,-1000,-217,-1000,-209,
-1000,-194,-239,-223,-223,-223,-223,-223,-1000,-256,
-1000,-1000,-1000,-1000,-224,-1000,-197,-193,-1000,-1000,
-1000,-1000,-279,-198,-1000,-213,-223,-1000,-1000,-1000,
-1000,-1000,-1000,-271,-1000,-1000,-1000,-1000,-184,-1000,
-198,-198,-240,-241,-243,-245,-185,-1000,-1000,-1000,
-257,-283,-186,-187,-1000,-266,-1000,-257,-257,-190,
-188,-248,-253,-263,-1000,-257,-257,-1000,-254,-195,
-1000,-1000,-257,-1000,-1000,-1000,-272,-1000,-1000,-269,
-1000 };
short yypgo[]={

   0, 106, 105,  80,  79,  78, 104, 103, 102,  84,
 101, 100,  99,  98,  97,  96,  95,  83,  94,  93,
  92,  91,  82,  90,  81,  89,  88,  86,  85 };
short yyr1[]={

   0,   1,   8,   8,   9,   9,   9,   9,   9,  12,
  14,  10,  15,  15,  16,  16,  17,  17,  18,  11,
  19,  19,  19,  19,  19,  22,  22,  23,  23,  24,
  24,  24,  20,  20,  20,  21,  21,  25,  13,  26,
   2,  27,   2,  28,   2,   3,   3,   3,   3,   3,
   7,   7,   7,   4,   5,   5,   5,   5,   5,   6 };
short yyr2[]={

   0,   2,   1,   2,   2,   2,   2,   2,   2,   3,
   0,   4,   0,   1,   1,   3,   2,   2,   0,   8,
   2,   2,   2,   2,   2,   0,   1,   1,   3,   2,
   2,   2,   0,   2,   3,   0,   2,   0,   5,   0,
   2,   0,   4,   0,   4,   5,   5,   7,   5,   5,
   0,   1,   1,   2,   1,   2,   3,   3,   3,   3 };
short yychk[]={

-1000,  -1,  -8,  -9, -10, -11, -12, -13, 256, 273,
 272, 275, 274, 260,  -9, 261, 261, 261, 261, 261,
 257, 257, 257, -25, -14, -18, 259, 257, -15, -16,
 -17, 267, -19, 269, 270, 271, 287, 288, 263, 262,
 259, 257, 263, -22, -23, -24, 266, 268, -22, -22,
 -22, -22,  -2, -26, -17, -20, 262, 259, 257, 259,
 285, 286,  -3,  -7, 259, 257, 264, 257, 265, -24,
 -27, -28, 276, 271, 289, 290, -21, 257,  -3,  -3,
 277, 277, 277, 277, 257,  -5,  -6, 265, 279,  -4,
 284,  -4, 257, 257, 278, 282, 283,  -5,  -5, 258,
 257, 278, 281, 278, 278,  -5,  -5, 280, 259,  -5,
 278 };
short yydef[]={

   0,  -2,   0,   2,   0,   0,   0,   0,   0,   0,
   0,   0,  37,   1,   3,   4,   5,   6,   7,   8,
  10,  18,   0,   0,  12,   0,   9,   0,  11,  13,
  14,   0,   0,  25,  25,  25,  25,  25,  39,   0,
  16,  17,  32,  20,  26,  27,   0,   0,  21,  22,
  23,  24,  38,  50,  15,   0,   0,  29,  30,  31,
  41,  43,  40,   0,  51,  52,  35,  33,   0,  28,
  50,  50,   0,   0,   0,   0,  19,  34,  42,  44,
   0,   0,   0,   0,  36,   0,  54,   0,   0,   0,
   0,   0,   0,   0,  45,   0,   0,  55,   0,   0,
  53,  46,   0,  48,  49,  57,  58,  56,  59,   0,
  47 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 9:
# line 60 "gs_pp_par.y"
{add_param(yypvt[-1].SYM, yypvt[-0].VALUE);} break;
case 10:
# line 64 "gs_pp_par.y"
{add_place(yypvt[-0].SYM);} break;
case 16:
# line 76 "gs_pp_par.y"
{chg_marks(yypvt[-0].VALUE);} break;
case 17:
# line 77 "gs_pp_par.y"
{chg_p_marks(yypvt[-0].SYM);} break;
case 18:
# line 81 "gs_pp_par.y"
{add_transition(yypvt[-0].SYM);} break;
case 20:
# line 85 "gs_pp_par.y"
{set_type(TTY_DET);} break;
case 21:
# line 86 "gs_pp_par.y"
{set_type(TTY_IMM);} break;
case 22:
# line 87 "gs_pp_par.y"
{set_type(TTY_EXP);} break;
case 23:
# line 88 "gs_pp_par.y"
{set_type(TTY_BIM);} break;
case 24:
# line 89 "gs_pp_par.y"
{set_type(TTY_NRM);} break;
case 29:
# line 100 "gs_pp_par.y"
{chg_rate(yypvt[-0].VALUE);} break;
case 30:
# line 101 "gs_pp_par.y"
{chg_p_rate(yypvt[-0].SYM);} break;
case 31:
# line 102 "gs_pp_par.y"
{chg_depend(yypvt[-0].VALUE);} break;
case 33:
# line 106 "gs_pp_par.y"
{add_input(yypvt[-0].SYM);} break;
case 34:
# line 107 "gs_pp_par.y"
{add_inhib(yypvt[-0].SYM);} break;
case 36:
# line 111 "gs_pp_par.y"
{add_output(yypvt[-0].SYM);} break;
case 37:
# line 115 "gs_pp_par.y"
{ini_result();} break;
case 38:
# line 116 "gs_pp_par.y"
{add_result(yypvt[-2].SYM, yypvt[-0].SYM);} break;
case 39:
# line 119 "gs_pp_par.y"
{it_opr = '+';} break;
case 40:
# line 119 "gs_pp_par.y"
{yyval.SYM = yypvt[-0].SYM;} break;
case 41:
# line 120 "gs_pp_par.y"
{it_opr = '+';} break;
case 42:
# line 120 "gs_pp_par.y"
{yyval.SYM = concat (yypvt[-3].SYM, yypvt[-0].SYM);} break;
case 43:
# line 121 "gs_pp_par.y"
{it_opr = '-';} break;
case 44:
# line 121 "gs_pp_par.y"
{yyval.SYM = concat (yypvt[-3].SYM, yypvt[-0].SYM);} break;
case 45:
# line 124 "gs_pp_par.y"
{yyval.SYM = do_prob (yypvt[-4].SYM, yypvt[-1].SYM);} break;
case 46:
# line 125 "gs_pp_par.y"
{yyval.SYM = do_exp  (yypvt[-4].SYM, yypvt[-1].SYM);} break;
case 47:
# line 126 "gs_pp_par.y"
{yyval.SYM = do_cexp (yypvt[-6].SYM, yypvt[-3].SYM, yypvt[-1].SYM);} break;
case 48:
# line 127 "gs_pp_par.y"
{yyval.SYM = do_dwell  (yypvt[-4].SYM, yypvt[-1].SYM);} break;
case 49:
# line 128 "gs_pp_par.y"
{yyval.SYM = do_fire  (yypvt[-4].SYM, yypvt[-1].SYM);} break;
case 50:
# line 131 "gs_pp_par.y"
{yyval.SYM = get_val(1.0);} break;
case 51:
# line 132 "gs_pp_par.y"
{yyval.SYM = get_val(yypvt[-0].VALUE);} break;
case 52:
# line 133 "gs_pp_par.y"
{yyval.SYM = get_para(yypvt[-0].SYM);} break;
case 53:
# line 136 "gs_pp_par.y"
{yyval.SYM = get_place (yypvt[-0].SYM);} break;
case 55:
# line 140 "gs_pp_par.y"
{yyval.SYM = c_negate (yypvt[-0].SYM);} break;
case 56:
# line 141 "gs_pp_par.y"
{yyval.SYM = do_paren (yypvt[-1].SYM);} break;
case 57:
# line 142 "gs_pp_par.y"
{yyval.SYM = do_and (yypvt[-2].SYM, yypvt[-0].SYM);} break;
case 58:
# line 143 "gs_pp_par.y"
{yyval.SYM = do_or (yypvt[-2].SYM, yypvt[-0].SYM);} break;
case 59:
# line 146 "gs_pp_par.y"
{yyval.SYM = do_cmp (yypvt[-2].SYM, yypvt[-1].SYM, yypvt[-0].VALUE);} break;
		}
		goto yystack;  /* stack new state and value */

	}
