/* $Id: fileswin.c,v 1.3 90/05/09 22:11:28 pturner Exp Locker: pturner $
 *
 * files popup
 *
 */

#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include "globals.h"
#include "defines.h"

extern Frame main_frame;
extern FILE *resfp;		/* defined in statuswin.c */
extern Pixfont *winfont;

Frame readdata_frame;
static Panel readdata_panel;
static Panel readdata_fname_item;
static Panel readdata_dir_item;
static Panel readdata_dir_message_item;
static Panel readp_fname_item;
static Panel writep_fname_item;
static Panel toggle_src_item;
static Panel toggle_ftype_item;
static Panel_item write_sets_item2;
static Panel_item write_parms_sets_item2;
static Panel_item write_sets_format_item2;
static Panel_item write_sets_file_item2;
static char cur_dir[256];

/*
 * files popup, read, write parameter files and read
 * data files
 */

/*
 * set the results file name
 */
static void results_file_proc()
{
    if (get_msg(resfile, buf, "Write the results of regression and set status to", "File:")) {
	if (resfp != stdout) {
	    fclose(resfp);
	}
	if (strcmp(resfile, buf)) {
	    strcpy(resfile, buf);
	    if (!fexists(resfile)) {
		resfp = fopen(resfile, "w");
		if (resfp == NULL) {
		    errwin("Can't open results file, using stdout");
		    resfp = stdout;
		}
	    } else {
		errwin("Writing results to stdout");
		resfp = stdout;
	    }
	}
    }
}

/*
 * change to new dir
 */
chdir_proc(item, event)
    Panel_item item;
    Event *event;
{
    char pathn[256];
    char full_path[256];

    strcpy(pathn, (char *) panel_get_value(readdata_dir_item));
    /*
     * Remember, the ESC = \033 must be included as a PANEL_NOTIFY_STRING in
     * the creation of readdata_dir_item
     */
    if (event_action(event) == '\033') {
	if (complete(pathn)) {
	    window_bell(readdata_panel);
	    panel_set(readdata_dir_item, PANEL_VALUE, pathn, 0);
	    return;
	} else
	    panel_set(readdata_dir_item, PANEL_VALUE, pathn, 0);
    }
    get_full_path(pathn, full_path);
    strcpy(pathn, full_path);
    if (full_path[0]) {
	if (!(chdir(full_path) == 0)) {
	    sprintf(buf, "Error in changing to directory %s", full_path);
	    errwin(buf);
	} else {
	    getwd(cur_dir);
	    strcpy(buf, "Current directory: ");
	    strcat(buf, cur_dir);
	    panel_set(readdata_dir_message_item, PANEL_LABEL_STRING, buf, 0);
	}
    }
}

static void do_readdata_proc(item, event)
    Panel_item item;
    Event *event;
{
    int ftype, src, i;
    char full_path[256];

    ftype = (int) panel_get_value(toggle_ftype_item);
    src = (int) panel_get_value(toggle_src_item);
    strcpy(buf, panel_get_value(readdata_fname_item));
    if (event_action(event) == '\033') {
	if (complete(buf)) {
	    window_bell(readdata_panel);
	    panel_set(readdata_fname_item, PANEL_VALUE, buf, 0);
	    return;
	} else
	    panel_set(readdata_fname_item, PANEL_VALUE, buf, 0);
    }
    get_full_path(buf, full_path);
    if (full_path[0]) {
	if (getdata(full_path, src, ftype)) {
	    for (i = 0; i < maxplot; i++) {
		update_status(i);
	    }
	    drawgraph();
	}
    } else {
	errwin("Define file name");
    }
}

static void do_readp_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i;
    char full_path[256];

    strcpy(buf, panel_get_value(readp_fname_item));
    if (event_action(event) == '\033') {
	if (complete(buf)) {
	    window_bell(readdata_panel);
	    panel_set(readp_fname_item, PANEL_VALUE, buf, 0);
	    return;
	} else
	    panel_set(readp_fname_item, PANEL_VALUE, buf, 0);
    }
    get_full_path(buf, full_path);
    if (full_path[0]) {
	getparms(full_path);
	updateparms();
	updatetics();
	for (i = 0; i < maxplot; i++) {
	    updatesymbols(i);
	}
	updatelegends();
	drawgraph();
    } else {
	errwin("Define file name");
    }
}

static void do_writep_proc(item, event)
    Panel_item item;
    Event *event;
{
    char full_path[256];
    FILE *pp;

    strcpy(buf, panel_get_value(writep_fname_item));
    if (event_action(event) == '\033') {
	if (complete(buf)) {
	    window_bell(readdata_panel);
	    panel_set(writep_fname_item, PANEL_VALUE, buf, 0);
	    return;
	} else
	    panel_set(writep_fname_item, PANEL_VALUE, buf, 0);
    }
    get_full_path(buf, full_path);
    if (full_path[0]) {
	if (fexists(full_path)) {
	    return;
	}
	if ((pp = fopen(full_path, "w")) != NULL) {
	    putparms(pp, -1, 0);
	    fclose(pp);
	} else {
	    errwin("Error open parameter file");
	}
    } else {
	errwin("Define file name");
    }
}

/*
 *  write a set or sets to a file
 */
static void do_write_sets2_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i, j, n;
    char fn[256];
    FILE *cp;
    double *getx(), *gety();
    double *x, *y;
    int setno, wpar;
    extern char format[];

    setno = (int) panel_get_value(write_sets_item2);
    setno--;			/* extra item in this menu !!! setno = -1
				 * means all sets */
    strcpy(buf, (char *) panel_get_value(write_sets_file_item2));
    if (event_action(event) == '\033') {
	if (complete(buf)) {
	    window_bell(readdata_panel);
	    panel_set(write_sets_file_item2, PANEL_VALUE, buf, 0);
	    return;
	} else
	    panel_set(write_sets_file_item2, PANEL_VALUE, buf, 0);
    }
    get_full_path(buf, fn);
    strcpy(format, (char *) panel_get_value(write_sets_format_item2));
    if (!fn[0]) {
	errwin("Define file name");
	return;
    }
    if (fexists(fn))
	return;
    if ((cp = fopen(fn, "w")) == NULL) {
	sprintf(buf, "Unable to open file %s", fn);
	errwin(buf);
    }
    wpar = (int) panel_get_value(write_parms_sets_item2);
    if (wpar) {
	putparms(cp, -1, 1);
    }
    if (setno < 0) {
	if (!activeset()) {
	    errwin("No active sets");
	    return;
	} else {
	    for (j = 0; j < maxplot; j++) {
		if (isactive(j)) {
		    x = getx(j);
		    y = gety(j);
		    n = getsetlength(j);
		    for (i = 0; i < n; i++) {
			fprintf(cp, format, x[i], y[i]);
			fputc('\n', cp);
		    }
		    fprintf(cp, "&\n");
		}
	    }
	    fclose(cp);
	}
    } else {
	if (!isactive(setno)) {
	    sprintf(buf, "Set %d not active", setno);
	    errwin(buf);
	    return;
	} else {
	    x = getx(setno);
	    y = gety(setno);
	    n = getsetlength(setno);
	    for (i = 0; i < n; i++) {
		fprintf(cp, format, x[i], y[i]);
		fputc('\n', cp);
	    }
	    fclose(cp);
	}
    }
}

/*
 * expose files popup
 */
void do_files_popup(item, event)
    Panel_item item;
    Event *event;
{
    window_set(readdata_frame, WIN_SHOW, TRUE, 0);
}

static void do_readdata_done_proc()
{
    window_set(readdata_frame, WIN_SHOW, FALSE, 0);
}

#ifdef EX
/*
 * experimental
 */
static Panel_item plot_file_item[10];
static Panel plot_file_type_item[10];
static Panel plot_file_format_item[10];
static Panel plot_file_active_item[10];

define_plot_files_proc()
{
    int i, itype, iformat, iact;

    for (i = 0; i < 5; i++) {
	strcpy(buf, (char *) panel_get_value(plot_file_item[i]));
	itype = (int) panel_get_value(plot_file_type_item[i]);
	iformat = (int) panel_get_value(plot_file_format_item[i]);
	iact = (int) panel_get_value(plot_file_active_item[i]);
	set_plotfile_parms(i, buf, itype, iformat, iact);
    }
}

#endif

void create_readdata_popup()
{
    extern char format[];
    int i;

    readdata_frame = window_create(main_frame, FRAME,
				   WIN_Y, 75,
				   WIN_X, 0,
				   WIN_FONT, winfont,
				   FRAME_LABEL, "Files",
				   FRAME_SHOW_LABEL, TRUE,
			    WIN_ERROR_MSG, "Couldn't create readdata_frame",
				   0);
    readdata_panel = window_create(readdata_frame, PANEL,
				   WIN_FONT, winfont,
				WIN_VERTICAL_SCROLLBAR, scrollbar_create(0),
				   0);

    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(0),
		      PANEL_LABEL_IMAGE,
		 panel_button_image(readdata_panel, "Read data file", 6, 0),
		      PANEL_NOTIFY_PROC, do_readdata_proc,
		      0);
    toggle_src_item = panel_create_item(readdata_panel, PANEL_CYCLE,
					PANEL_LABEL_STRING, "Read from:",
					PANEL_CHOICE_STRINGS,
					"File",
					"Pipe",
					0,
					PANEL_ITEM_X, ATTR_COL(1),
					PANEL_ITEM_Y, ATTR_ROW(2),
					0);
    toggle_ftype_item = panel_create_item(readdata_panel, PANEL_CYCLE,
					  PANEL_LABEL_STRING, "File format:",
					  PANEL_CHOICE_STRINGS,
					  "Data is X Y",
					  "Data is X Y1 Y2 Y3 ...",
					  "IHL format",
					  0,
					  PANEL_ITEM_X, ATTR_COL(25),
					  PANEL_ITEM_Y, ATTR_ROW(2),
					  0);
    readdata_fname_item = panel_create_item(readdata_panel, PANEL_TEXT,
				     PANEL_LABEL_STRING, "Data file name: ",
					    PANEL_ITEM_X, ATTR_COL(1),
					    PANEL_ITEM_Y, ATTR_ROW(1),
					  PANEL_NOTIFY_STRING, "\033\r\t\n",
					PANEL_NOTIFY_PROC, do_readdata_proc,
					    PANEL_VALUE_DISPLAY_LENGTH, 60,
					    0);
    getwd(cur_dir);
    strcpy(buf, "Current directory: ");
    strcat(buf, cur_dir);
    readdata_dir_message_item = panel_create_item(readdata_panel, PANEL_MESSAGE,
						  PANEL_LABEL_STRING, buf,
						  PANEL_ITEM_X, ATTR_COL(1),
						  PANEL_ITEM_Y, ATTR_ROW(4),
						  0);
    readdata_dir_item = panel_create_item(readdata_panel, PANEL_TEXT,
					  PANEL_LABEL_STRING, "Change to: ",
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(5),
					  PANEL_NOTIFY_PROC, chdir_proc,
					  PANEL_NOTIFY_STRING, "\033\r\t\n",
					  PANEL_VALUE_DISPLAY_LENGTH, 60,
					  0);
    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(7),
		      PANEL_LABEL_IMAGE,
	    panel_button_image(readdata_panel, "Read parameter file", 6, 0),
		      PANEL_NOTIFY_PROC, do_readp_proc,
		      0);

    readp_fname_item = panel_create_item(readdata_panel, PANEL_TEXT,
					 PANEL_LABEL_STRING, "File: ",
					 PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(8),
					 PANEL_NOTIFY_STRING, "\033\r\t\n",
					 PANEL_NOTIFY_PROC, do_readp_proc,
					 PANEL_VALUE_DISPLAY_LENGTH, 60,
					 0);
    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(10),
		      PANEL_LABEL_IMAGE,
	   panel_button_image(readdata_panel, "Write parameter file", 6, 0),
		      PANEL_NOTIFY_PROC, do_writep_proc,
		      0);
    writep_fname_item = panel_create_item(readdata_panel, PANEL_TEXT,
					  PANEL_LABEL_STRING, "File: ",
					  PANEL_ITEM_X, ATTR_COL(1),
					  PANEL_ITEM_Y, ATTR_ROW(11),
					  PANEL_NOTIFY_STRING, "\033\r\t\n",
					  PANEL_NOTIFY_PROC, do_writep_proc,
					  PANEL_VALUE_DISPLAY_LENGTH, 60, 0);
    write_parms_sets_item2 = panel_create_item(readdata_panel,
					       PANEL_CYCLE,
					       PANEL_ITEM_X, ATTR_COL(50),
					       PANEL_ITEM_Y, ATTR_ROW(13),
					       PANEL_LABEL_STRING, "Params:",
					       PANEL_CHOICE_STRINGS,
					 "No params", "Imbed params", 0, 0);
    write_sets_item2 = panel_create_item(readdata_panel,
					 PANEL_CYCLE,
					 PANEL_ITEM_X, ATTR_COL(15),
					 PANEL_ITEM_Y, ATTR_ROW(13),
					 PANEL_LABEL_STRING, "Write:",
					 PANEL_CHOICE_STRINGS,
		"All", "Set 0", "Set 1", "Set 2", "Set 3", "Set 4", "Set 5",
		     "Set 6", "Set 7", "Set 8", "Set 9", "Set 10", "Set 11",
					 "Set 12", "Set 13", "Set 14", 0, 0);
    write_sets_format_item2 = panel_create_item(readdata_panel, PANEL_TEXT,
					     PANEL_LABEL_STRING, "Format: ",
						PANEL_ITEM_X, ATTR_COL(30),
						PANEL_ITEM_Y, ATTR_ROW(13),
					 PANEL_VALUE_DISPLAY_LENGTH, 10, 0);
    write_sets_file_item2 = panel_create_item(readdata_panel, PANEL_TEXT,
					      PANEL_LABEL_STRING, "File: ",
				     PANEL_NOTIFY_PROC, do_write_sets2_proc,
					      PANEL_ITEM_X, ATTR_COL(1),
					      PANEL_ITEM_Y, ATTR_ROW(14),
					 PANEL_VALUE_DISPLAY_LENGTH, 40, 0);
    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE,
	     panel_button_image(readdata_panel, "Write set(s)", 0, winfont),
		      PANEL_NOTIFY_STRING, "\033\r\t\n",
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(13),
		      PANEL_NOTIFY_PROC, do_write_sets2_proc,
		      0);
    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(18),
		      PANEL_LABEL_IMAGE,
		      panel_button_image(readdata_panel, "Done", 6, 0),
		      PANEL_NOTIFY_PROC, do_readdata_done_proc,
		      0);
    panel_create_item(readdata_panel, PANEL_BUTTON,
		      PANEL_ITEM_X, ATTR_COL(1),
		      PANEL_ITEM_Y, ATTR_ROW(16),
		      PANEL_LABEL_IMAGE,
		   panel_button_image(readdata_panel, "Results file", 6, 0),
		      PANEL_NOTIFY_PROC, results_file_proc,
		      0);
#ifdef EX
/*
 * some experimental stuff
 */
    for (i = 0; i < 5; i++) {
	plot_file_item[i] = panel_create_item(readdata_panel, PANEL_TEXT,
					  PANEL_LABEL_STRING, "Plot file: ",
					      PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(20 + 2 * i),
					      PANEL_VALUE_DISPLAY_LENGTH, 60,
					      0);
	plot_file_type_item[i] = panel_create_item(readdata_panel, PANEL_CYCLE,
					      PANEL_LABEL_STRING, "Source:",
						   PANEL_CHOICE_STRINGS,
						   "File",
						   "Pipe",
						   0,
						   PANEL_ITEM_X, ATTR_COL(1),
					 PANEL_ITEM_Y, ATTR_ROW(21 + 2 * i),
						   0);
	plot_file_format_item[i] = panel_create_item(readdata_panel, PANEL_CYCLE,
					      PANEL_LABEL_STRING, "Format:",
						     PANEL_CHOICE_STRINGS,
						     "X Y",
						     "X Y String",
						     "X Y Hi Lo Close",
						     "X Y U V (flow)",
						     "X Y Mag Dir (flow)",
						     0,
						 PANEL_ITEM_X, ATTR_COL(17),
					 PANEL_ITEM_Y, ATTR_ROW(21 + 2 * i),
						     0);
	plot_file_active_item[i] = panel_create_item(readdata_panel, PANEL_CYCLE,
						     PANEL_CHOICE_STRINGS,
						     "OFF",
						     "ON",
						     0,
						 PANEL_ITEM_X, ATTR_COL(55),
					 PANEL_ITEM_Y, ATTR_ROW(21 + 2 * i),
						     0);
    }
#endif

    panel_set_value(write_sets_format_item2, format);
    if (plfile[0]) {
	panel_set_value(readp_fname_item, plfile);
    }
    window_fit(readdata_panel);
    window_fit(readdata_frame);
}
