
      program master1 
      include '../include/fpvm3.h'
c ---------------------------------------------------------
c Example fortran program illustrating the use of PVM 3.0
c ---------------------------------------------------------
      integer i, info, nproc, msgtype
      integer mytid, tids(0:32)
      integer who
      double precision result(32), data(100)
      character*12 nodename
      character*8 arch

c ------------ Starting up all the tasks ---------------------------

c     Enroll this program in PVM 
      call pvmfmytid( mytid )

c     Initiate nproc instances of slave1 program 
      print *,'How many slave programs (1-32)?'
      read *, nproc
c
c     If arch is set to '*' then ANY configured machine is acceptable
c     otherwise arch should be set to architecture type you wish to use.
      nodename = 'slave1'
      arch = '*'

      call pvmfspawn( nodename, 0, arch, nproc, tids, info )
      do 100 i=0, nproc-1
         print *,'tid',i,tids(i)
100   continue

c ------- Begin user program -------- 

      n = 10
c     Initiate data array
      do 20 i=1,n
         data(i) = 1
 20   continue

c     broadcast data to all node programs 
      call pvmfinitsend( 0, info )
      call pvmfpack( INTEGER4, nproc, 1, 1, info )
      call pvmfpack( INTEGER4, tids, nproc, 1, info )
      call pvmfpack( INTEGER4, n, 1, 1, info )
      call pvmfpack( REAL8,    data, n, 1, info ) 
      msgtype  = 1 
      call pvmfmcast( nproc, tids, msgtype, info )
 
c     wait for results from nodes 
      msgtype  = 2 
      do 30 i=1,nproc 
         call pvmfrecv( -1, msgtype, info ) 
         call pvmfunpack( INTEGER4, who, 1, 1, info )
         call pvmfunpack( REAL8, result(who), 1, 1, info )
         print *, 'I got',result(who), '  from', who 
 30   continue 

c --------- End user program -------- 

c     program finished leave PVM before exiting 
      call pvmfexit(info) 
      stop
      end
