#include "xo_head.h"
#include "XoWhen.h"
#include <X11/Xlib.h>

static void do_handler();

/*
** handler:	Generic handler called each time a SelectInput event
**		which maches one of our "when'ed" flags occurs.  This
**		is the "switch" routine which matches incoming events
**		with user-defined "when" events and branches if they match.
**
*/
static void handler(w, data, event)
	Widget		w;
	struct when_struct	*data;
	XButtonEvent	*event;
{
	XLeaveWindowEvent	*leave_event;
	int		type;
	int		buttons;
	int		my_concerns;
	my_concerns = EnterWindowMask | LeaveWindowMask |
			ButtonPressMask | ButtonReleaseMask;

	type = (int)(event->type); /* & my_concerns;*/
#ifdef DEBUG
	fprintf(stderr,"TYPE= %d\n", type);
	fprintf(stderr,"handler: my_concerns are %d\n", my_concerns);
	fprintf(stderr,"	: type is %d\n", type);
	fprintf(stderr,"	: event is %d\n", event->type);
	fprintf(stderr,"	: data->event_flag is %d\n", data->event_flag);
#endif

	/* if it's just a plain enter or leave do the function */
	if (event->type == ButtonPress || event->type == ButtonRelease) {
		if (event->button != data->button)  {
			return;
		}
		do_handler(w, data->exec_string);
	}
	if (event->type == EnterNotify) {
		if ((data->event_flag & EnterWindowMask) != 0) {
			if (data->event_flag == EnterWindowMask)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button1MotionMask) != 0 &&
				event->button == Button1)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button2MotionMask) != 0 &&
				event->button == Button2)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button3MotionMask) != 0 &&
				event->button == Button3)
				do_handler(w, data->exec_string);
		}
		return;
	}
	if (event->type == LeaveNotify) { 
		/* special case of leaving for a "child" window */
		leave_event = (XLeaveWindowEvent *)event;
		if (leave_event->detail == NotifyInferior)
			return; /* just moved into a child */
		if ((data->event_flag & LeaveWindowMask) != 0) {
			if (data->event_flag == LeaveWindowMask)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button1MotionMask) != 0 &&
				event->button == Button1)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button2MotionMask) != 0 &&
				event->button == Button2)
				do_handler(w, data->exec_string);
			if ((data->event_flag & Button3MotionMask) != 0 &&
				event->button == Button3)
				do_handler(w, data->exec_string);
		}
		return;
	}

}

/*
** do_handler:	Pass the script along to be executed by our generic
**		button handler.
**
*/
static void do_handler(w, str)
	Widget	w;
	char	*str;
{
	execute_button(w, str, NULL);
}

/*
** do_when: 	when element <actions> do <command(s)>
**
*/
do_when(argc, argv)
	int	argc;
	char	**argv;
{
	struct	when_struct	*my_struct;
	Widget	w;

	my_struct = (struct when_struct *)malloc(sizeof(struct when_struct));
	my_struct->exec_string = NULL;
	my_struct->button = 0;
	my_struct->event_flag = 0;

	if (parse_when(argc, argv, &w, my_struct) == 0)
		free(my_struct);
	else {
	/*
		XtAddMultiEventHandler(w, my_struct->event_flag, False, 
			handler, (caddr_t)my_struct);
	*/
	}
}

/*
** do_unwhen: 	unwhen element <actions> do <command(s)> (removes the when )
**
*/
do_unwhen(argc, argv)
	int	argc;
	char	**argv;
{
	struct	when_struct	*my_struct;
	Widget	w;

	my_struct = (struct when_struct *)malloc(sizeof(struct when_struct));
	my_struct->exec_string = NULL;
	my_struct->button = 0;
	my_struct->event_flag = 0;

	if (parse_when(argc, argv, &w, my_struct) == 0) {
		fprintf(stderr,"%s: specified event not currently registered\n",
			argv[0]);
	} else {
	/*
		XtRemoveMultiEventHandler(w, my_struct->event_flag, False, 
			handler);
		
	*/
	}
	free(my_struct);
}

/*
** parse_when:	when element action do [script]
**		0	1	2	3  4
**
*/
parse_when(argc, argv, w, my_struct)
	int	argc;
	char	**argv;
	Widget		*w;
	struct when_struct	*my_struct;
{
	char		*script;
	int		i;

	if (argc < 5) {
		fprintf(stderr,"usage: %s element <action> do <script>\n");
		fprintf(stderr,"       <action> = {left|right|middle} {up|down}\n");
		fprintf(stderr,"       <script> = {command script}\n");
		return(0);
	}
	*w = (Widget)x_ntw_get(argv[1]);


	if (*w == NULL) {
		fprintf(stderr,"%s: unable to find widget %s\n",
			argv[0], argv[1]);
		return(0);
	}

	i = 2;
	while (i < argc && strcmp(argv[i], "do") != NULL) {
		if (strcmp(argv[i], "enter") == 0) {
			my_struct->event_flag |= EnterWindowMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "leave") == 0) {
			my_struct->event_flag |= LeaveWindowMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "leftmotion") == 0) {
			my_struct->event_flag |= Button1MotionMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "middlemotion") == 0) {
			my_struct->event_flag |= Button2MotionMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "rightmotion") == 0) {
			my_struct->event_flag |= Button3MotionMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "left") == 0) {
			my_struct->button |= Button1;
			i++;
			continue;
		}
		if (strcmp(argv[i], "middle") == 0) {
			my_struct->button |= Button2;
			i++;
			continue;
		}
		if (strcmp(argv[i], "right") == 0) {
			my_struct->button |= Button3;
			i++;
			continue;
		}
		if (strcmp(argv[i], "up") == 0) {
			my_struct->event_flag |= ButtonReleaseMask;
			i++;
			continue;
		}
		if (strcmp(argv[i], "down") == 0) {
			my_struct->event_flag |= ButtonPressMask;
			i++;
			continue;
		}
		fprintf(stderr,"%s: invalid EVENT - ignoring '%s'\n", argv[0],
			argv[i]);
		i++;
	}
	if (i+1 >= argc || *argv[i] == NULL || strcmp(argv[i], "do") != 0) {
		fprintf(stderr,"usage: %s element <action> do <script>\n");
		fprintf(stderr,"       <action> = {left|right|middle} {up|down}\n");
		fprintf(stderr,"       <script> = {command script}\n");
		return(0);
	}
	i++; /* skip over the do */
	script = (char *)ArgListToString(argc-i, argv+i);
	if (script == NULL) {
		fprintf(stderr,"%s: no script specified\n", argv[0]);
		return(0);
	}
	my_struct->exec_string = script;
	return(1);
}
