/* 
** innergraph_wP.c: inner graph widget private structures & defines.
**
** Written by:	Upinder S. Bhalla 	(bhalla@aurel.caltech.edu)
**		John Uhley 		(uhley@tybalt.caltech.edu)
**
** Copyright 1988 by the California Institute of Technology
**
** Permission to use, copy, modify, and distribute this
** software and its documentation for any purpose and without
** fee is hereby granted, provided that the above copyright
** notice appear in all copies and that both that copyright
** notice and this permission notice appear in supporting
** documentation, and that the name of the California Institute
** of Technology not be used in advertising or publicity pertaining 
** to distribution of the software without specific, written prior 
** permission.  The California Institute of Technology makes no 
** representations about the suitability of this software for any purpose.
** It is provided "as is" without express or implied warranty.
** 
** The Xgraph Widget library was written by Upinder S. Bhalla and
** John Uhley.  Portions of the labeling routines were taken from
** David Harrison's xgraph (X10V4) program with his permission.
**
** The X Window system is copyright 1985, 1986, 1987 By the
** Massachusetts Institute of Technology, without whom none of this
** code would have been possible.
**
*/
#ifndef _InnerGraph_P

#define BLOCKSIZE	1000

typedef struct  array_link_struct {     
        struct array_link_struct       *next;
        struct array_link_struct       *last;
        int                     min;
        int                     max;
        char			*val[BLOCKSIZE];
} ArrayLink;

typedef struct graph_struct {
	struct graph_struct	*next;
	char			*name;
	char		*color;
	int			line;
	int			points;
	ArrayLink		*data;		/* Raw data		*/
	int			datasize;
	ArrayLink		*pts;		/* Scaled  data		*/
	int			npts;
} GraphInfo;

#include "innergraph_w.h"

typedef struct _InnerGraphClass{
  int make_compiler_happy;
}InnerGraphClassPart;

typedef struct _InnerGraphClassRec{
	CoreClassPart core_class;
	SimpleClassPart simple_class;
 	LabelClassPart label_class;
	InnerGraphClassPart innergraph_class;
}InnerGraphClassRec, *InnerGraphWidgetClass;

extern InnerGraphClassRec innergraphClassRec;

typedef struct{
  GraphInfo	*graphInfo;
  char		*xmin_str;
  char		*ymin_str;
  char		*xmax_str;
  char		*ymax_str;
  float		xmin;
  float		ymin;
  float		xmax;
  float		ymax;
}InnerGraphPart;

typedef struct _InnerGraphRec{
  CorePart core;
  SimplePart simple;
  LabelPart	label;
  InnerGraphPart graph;
}InnerGraphRec;

#define _InnerGraph_P
#endif _InnerGraph_P
