#include "gen_ext.h"
#include "xodus_args.h"
#include "ImageP.h"

extern	XtCallbackProc	ximage_callback();
extern char *fillstr();

extern	char *g_copy();
static int ximage_parser();

/*
** ximage_func:	
**
*/
ximage_func(element,action)
	struct ximage_type 	*element;
	Action			*action;
{
	LayoutWidget		widget;
	ImageWidget		iw;
	char			*field;
	char			**argv;
	char			*value;
	struct ximage_type 	*new;
	Position		x, y;

	static	XtCallbackRec	callback[2];
	static struct valid_arg ximage_args[] = {
		{"filename", 0, 2},
		{"fileformat", 0, 2},
		{"storemode", 0, 2},
		{"value", 0, 2},
		{"rescaleable", 0, 2},
		{"srcx", 0, 2},
		{"srcy", 0, 2},
		{"dstx", 0, 2},
		{"dsty", 0, 2},
		{"wx", 0, 2},
		{"wy", 0, 2},
		{"END", -1, -1}
	};

	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	callback[0].callback = (XtCallbackProc)ximage_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;


	switch(action->type) {
    		case CREATE: 
			widget = (LayoutWidget)do_image(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			break;
    		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
    		case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		XoParseCoords(&(action->argc), action->argv, argv);
			if (x_parse_set(action->argc, argv, ximage_args))
			xfunc_parse_set(element, action->argc, argv,
				ximage_parser);
			free(argv);
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
	}
	return(1);
}
/*
** ximage_callback:	When ximage is changed from the screen this is 
**			called.
**
*/
XtCallbackProc
ximage_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	ImageWidget	iw = (ImageWidget)w;
	XtCallbackRec	*callback_ptr;
	struct ximage_type *element;
	element = (struct ximage_type *)
		(((LayoutConstraints)(w->core.constraints))->
			layout.layout_element);
	if (element == NULL) {
			fprintf(stderr,"ximage_callback: null element\n");
			return;
	}
	if (element->name  == NULL || *element->name == NULL) 
		return;	/* just a realize call */
	xodus_core_set(element, w);
}

static int ximage_parser(element, i, argc, argv)
	struct ximage_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	ImageWidget	iw;
	char	*field, *value;
	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	value = argv[i];
	
	if (strcmp(field,"srcx") == 0 ||
		strcmp(field,"srcy") == 0 ||
		strcmp(field,"dstx") == 0 ||
		strcmp(field,"dsty") == 0 ||
		strcmp(field,"wx") == 0 ||
		strcmp(field,"wy") == 0) {
		iw = (ImageWidget)element->widget;
		if (strcmp(field,"srcx") == 0) iw->image.srcx = atoi(value);
		if (strcmp(field,"srcy") == 0) iw->image.srcy = atoi(value);
		if (strcmp(field,"dstx") == 0) iw->image.dstx = atoi(value);
		if (strcmp(field,"dsty") == 0) iw->image.dsty = atoi(value);
		if (strcmp(field,"wx") == 0) iw->image.wx = atoi(value);
		if (strcmp(field,"wy") == 0) iw->image.wy = atoi(value);
		ImageResize(iw, NULL);
		SetField(element,element->object->type, 
			field,value);
		return(2);
	}
	if (strcmp(field,"filename") == 0) {
		iw = (ImageWidget)element->widget;
		if (value && strlen(value) > 1) {
			if (iw->image.filename)
				free(iw->image.filename);
			iw->image.filename = fillstr(value);
		}
		LoadImage(iw);
		ImageResize(iw, NULL);
		SetField(element,element->object->type, 
			field,value);
		return(2);
	}
	return(0);
}
