
/* --------------------------------------------- */
/* The init routine for setting up a drawpix.
 * Drawpixes let the user specify the contents of a 
 * draw widget from the text interface.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "xodus_defs.h"
#include "shape_w.h"

Boolean ShapeSetHook();
void ShapeGetHook();
static char	*GetShapeValue();
static int CleanShapeHl();
int	DrawShape();
char	*fillstr();

/* --------------------------------------------- */

static XtResource DrawResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, name),
        XtRString, "shape"
    },
    {XtNpixcolor, XtCPixcolor, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, color),
        XtRString, "Black"
    },
    {XtNdrawmode, XtCDrawmode, XtRFunction, sizeof(caddr_t),
        XtOffset(ShapePixPtr, drawmode),
        XtRString, "DrawLines"
    },
    {XtNcoords, XtCCoords, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, coords),
        XtRString, NULL
    },
    {XtNlinewidth, XtCLinewidth, XtRInt, sizeof(int),
        XtOffset(ShapePixPtr, linewidth),
        XtRString, "0"
    },
    {XtNlinestyle, XtCLinestyle, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, linestyle),
        XtRString, "LineSolid"
    },
    {XtNjoinstyle, XtCJoinstyle, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, joinstyle),
        XtRString, "JoinMiter"
    },
    {XtNcapstyle, XtCCapstyle, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, capstyle),
        XtRString, "CapButt"
    },
    {XtNtextmode, XtCTextmode, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, textmode),
        XtRString, "draw"
    },
    {XtNtext, XtCText, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, text),
        XtRString, ""
    },
    {XtNtextcolor, XtCTextcolor, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, textcolor),
        XtRString, "Black"
    },
    {XtNfont, XtCFont, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, font),
        XtRString, "9x12"
    },
    {XtNiconname, XtCIconname, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, iconname),
        XtRString, NULL
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, hldispmode),
        XtRString, "star"
    },
    {XtNvalue, XtCValue, XtRString, sizeof(char *),
        XtOffset(ShapePixPtr, value),
        XtRString, "            "
    },
    {XtNtx, XtCTx, XtRFloat, sizeof(float),
        XtOffset(ShapePixPtr, tx),
        XtRString, "0.0000000000"
    },
    {XtNty, XtCTy, XtRFloat, sizeof(float),
        XtOffset(ShapePixPtr, ty),
        XtRString, "0.0000000000"
    },
    {XtNtz, XtCTz, XtRFloat, sizeof(float),
        XtOffset(ShapePixPtr, tz),
        XtRString, "0.0000000000"
    },
};

/*
**	Allowed modes are ..
** DrawPoints();
** DrawLines();
** DrawRects();
** DrawSegs();
** DrawArrows();
** FillRects();
** FillPoly();
** DrawColoredLines();
** DrawFatLines();
	* We have an array of subpixes which tell the draw routine 
	* the range of Xpoints  which they refer to and the values
	* for text, icons, value, mode and color. This is ugly, and
	* I would have preferred to use separate pixes for each, but
	* space is at a premium and it is an easier hack?
*/

Pix *
XoCreateShape(parent,args,num_args)
	DrawWidget	parent;
	ArgList		args;
	Cardinal	num_args;
{
	ShapePix	*pix;
	Pix	*image,*icon;
	CoordRescale	*rescale;
	int			i;
	int			len;

	pix = (ShapePix *)calloc(1,sizeof(ShapePix));
	pix->name = (char *)calloc(20 , sizeof(char));
	pix->color = (char *)calloc(20 , sizeof(char));
	pix->coords = (char *)calloc(200 , sizeof(char));
	pix->linestyle = (char *)calloc(20,sizeof(char));
	pix->capstyle = (char *)calloc(20,sizeof(char));
	pix->joinstyle = (char *)calloc(20,sizeof(char));
	pix->textmode = (char *)calloc(20,sizeof(char));
	pix->text = (char *)calloc(80,sizeof(char));
	pix->textcolor = (char *)calloc(20,sizeof(char));
	pix->font = (char *)calloc(20,sizeof(char));
	pix->iconname = (char *)calloc(40,sizeof(char));
	pix->hlhistmode = (char *)calloc(20,sizeof(char));
	pix->hldispmode = (char *)calloc(20,sizeof(char));
	pix->value = (char *)calloc(80,sizeof(char));

    image = parent->draw.images;
    icon = parent->draw.icons;

    XtGetSubresources(parent,pix,XtNimages,XtCPix,DrawResources,
        XtNumber(DrawResources),args,num_args);

    parent->draw.pixname = fillstr(pix->name);

	if ((len = strlen(pix->name )) > 5 && 
		strcmp(&(pix->name[len - 4]),"icon") == 0) {
	  	parent->draw.icons = (Pix *)pix;
    	pix->next = icon;
    	parent->draw.images = image;
	} else {
    	parent->draw.images = (Pix *)pix;
    	pix->next = image;
    	parent->draw.icons = icon;
	}

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);

    pix->resources = DrawResources;
    pix->num_resources = XtNumber(DrawResources);

    pix->update = (Update *) calloc(1,sizeof(Update));
    pix->update->func = UseCoords;
	pix->refresh_func = DrawShape;
    pix->set_hook = ShapeSetHook;
    pix->get_hook = ShapeGetHook;
	pix->hilight->get_value = GetShapeValue;
	pix->hilight->hl_clean_disp = CleanShapeHl;

	LoadShapeCoords(parent,pix);
	return((Pix *)pix);
}


/*
** We are doing rather a nasty hack here with the coords. We always
** put the 0,0,0 point in coords[0]. Then we put the remaining coords
** after that. The coords of the text are treated as an offset for
** the rest of the coords, and are saved in the offset area of rescale.
*/
LoadShapeCoords(dw,pix)
	DrawWidget	dw;
	ShapePix		*pix;
{
	char	*str;
	int		len = 0;
	Coord	coords[200];
	int		is_icon = 0;
	int		i,index = 0;

	str = pix->coords;
	if (str)
		len = strlen(pix->coords);

	coords[0].x = 0;
	coords[0].y = 0;
	coords[0].z = 0;

	for (i = 1 ; i < 200 ; i++) {
		for (; index < len &&  str[index] != '[' ; index++);
		if (index == len) break;
	
		if (!(sscanf(str + index,"[%f,%f,%f]",
			&coords[i].x, &coords[i].y, &coords[i].z))) {
			fprintf(stderr,"error in syntax of coords at '%s'\n",
				str + index);
			return;
		}
		index++;
	}
	if (i == 0) return;

	load_pix_coords2(pix,coords,i);

	pix->rescale->offset.x = pix->tx;
	pix->rescale->offset.y = pix->ty;
	pix->rescale->offset.z = pix->tz;

	if ((len = strlen(pix->name)) > 5)
		if (strcmp(&(pix->name[len-4]),"icon") == 0)
			is_icon = 1;
	UseCoords(dw,pix,is_icon);
}


static Boolean ShapeSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	ShapePix	*pix;
	char	**argnames;
	int		nargs;
{
	int		i;
	Boolean do_rescale = FALSE;
	Pix		*icon;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpixcolor) == 0) {
			/*
			SetPixColor(parent,pix);
			*/
		} else if (strcmp(argnames[i],XtNdrawmode) == 0) {
		} else if (strcmp(argnames[i],XtNlinewidth) == 0) {
		} else if (strcmp(argnames[i],XtNlinestyle) == 0) {
		} else if (strcmp(argnames[i],XtNjoinstyle) == 0) {
		} else if (strcmp(argnames[i],XtNcapstyle) == 0) {
		} else if (strcmp(argnames[i],XtNtextmode) == 0) {
		} else if (strcmp(argnames[i],XtNtext) == 0) {
		} else if (strcmp(argnames[i],XtNtextcolor) == 0) {
		} else if (strcmp(argnames[i],XtNfont) == 0) {
			/*
			fprintf(stderr,"font selection not yet implemented\n");
			*/
		} else if (strcmp(argnames[i],XtNiconname) == 0) {
			if (icon = find_pix2(parent,pix->iconname))
				pix->icon = icon;
				/*
			else
				printf("icon '%s' not found\n",pix->iconname);
				*/
		} else if (strcmp(argnames[i],XtNcoords) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNvalue) == 0) {
		} else if (strcmp(argnames[i],XtNtx) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNty) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNtz) == 0) {
			do_rescale = TRUE;
		} else printf("Field '%s' not known\n",argnames[i]);
	}
	if (do_rescale)
		LoadShapeCoords(parent,pix);
	return(TRUE);
}

static void	ShapeGetHook(pix,rl,args,nargs)
	ShapePix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

DrawShape(pict,pix)
	DrawPart	*pict;
	ShapePix	*pix;
{
	XPoint	*pts;
	int		npts;
	int		linestyle;
	int		joinstyle;
	int		capstyle;

	if (pix->icon)
		DrawOneIcon(pict,pix->icon,pix->pts[0].x,pix->pts[0].y);
	
/* 
** Hack to separate the shape coords from the coords of the center
** and the text string.
*/
	if (pix->npts > 1) {
		pts = pix->pts;
		pix->pts = &(pts[1]);
		npts = pix->npts;
		pix->npts = npts - 1;
/*
** Set the linestyle etc.
*/
		if (!(pix->linestyle && pix->joinstyle && pix->capstyle))
			return;
		if (strcmp(pix->linestyle,"LineSolid") == 0)
			linestyle = LineSolid;
		else if (strcmp(pix->linestyle,"LineDoubleDash") == 0)
			linestyle = LineDoubleDash;
		else if (strcmp(pix->linestyle,"LineOnOffDash") == 0)
			linestyle = LineOnOffDash;
		else
			linestyle = LineSolid;

		if (strcmp(pix->joinstyle,"JoinMiter") == 0)
			joinstyle = JoinMiter;
		else if (strcmp(pix->joinstyle,"JoinRound") == 0)
			joinstyle = JoinRound;
		else if (strcmp(pix->joinstyle,"JoinBevel") == 0)
			joinstyle = JoinBevel;
		else
			joinstyle = JoinMiter;

		if (strcmp(pix->capstyle,"CapNotLast") == 0)
			capstyle = CapNotLast;
		else if (strcmp(pix->capstyle,"CapButt") == 0)
			capstyle = CapButt;
		else if (strcmp(pix->capstyle,"CapRound") == 0)
			capstyle = CapRound;
		else if (strcmp(pix->capstyle,"CapProjecting") == 0)
			capstyle = CapProjecting;
		else
			capstyle = CapButt;

		XSetForeground(pict->display,pict->gc,name_to_color(pix->color));
		XSetLineAttributes(pict->display,pict->gc,
			pix->linewidth,linestyle,capstyle,joinstyle);

		(pix->drawmode)(pict,pix);
		pix->pts = pts;
		pix->npts = npts;

/* Restore the linestyle */
		XSetLineAttributes(pict->display,pict->gc,
			0,LineSolid,CapButt,JoinMiter);
	}
	XSetForeground(pict->display,pict->gc,
			name_to_color(pix->textcolor));
/* Draw the text string. This is done last so it will be in front */
	XSetBackground(pict->display,pict->gc,0);
	if (pix->text) {
		if (strcmp(pix->textmode,"fill") == 0)
			XoFillCenteredString(pict->display,pict->d,pict->gc,
				pix->text,pix->pts[0].x,pix->pts[0].y);
		else if (strcmp(pix->textmode,"nodraw") != 0)
			XoDrawCenteredString(pict->display,pict->d,pict->gc,
				pix->text,pix->pts[0].x,pix->pts[0].y);
	}
}

static char *
GetShapeValue(pict,pix,index)
	DrawPart	*pict;
	ShapePix		*pix;
	int			index;
{
	if (pix->value)
		return(fillstr(pix->value));
	return(NULL);
}

static int CleanShapeHl(pict,pix,index)
	DrawPart	*pict;
	ShapePix 	*pix;
	int			index;
{
	(pix->refresh_func)(pict,pix);
}

