#include <stdio.h>
#include <math.h>
#include <signal.h>

extern int harmless_sig();
extern int restore_context();
extern int sig_msg_restore_context();

SetSIGQUIT()
{

    signal(SIGQUIT,sig_msg_restore_context);
}

SetSignals()
{

    signal(SIGINT,restore_context);
    SetSIGQUIT();
    signal(SIGQUIT,SIG_IGN);
    signal(SIGSEGV,sig_msg_restore_context);
    signal(SIGILL,sig_msg_restore_context);
    /*
    signal(SIGFPE,sig_msg_restore_context);
    */
    signal(SIGBUS,sig_msg_restore_context);
    signal(SIGTRAP,sig_msg_restore_context);
}

ClearSignals()
{
    signal(SIGINT,SIG_DFL);
    signal(SIGQUIT,SIG_DFL);
    signal(SIGSEGV,SIG_DFL);
    signal(SIGILL,SIG_DFL);
    signal(SIGFPE,SIG_DFL);
    signal(SIGBUS,SIG_DFL);
}

harmless_sig(sig,code)
int sig,code;
{
	switch(sig){	
	case SIGSEGV :
		printf("segmentation violation\n");
		break;
	case SIGFPE :
		printf("floating point exception. code = %d\n",code);
		break;
	case SIGILL :
		printf("illegal instructio. code = %d\n",code);
		signal(SIGILL,harmless_sig);
		break;
	}
}

CoreRequest()
{
	printf("core dump (y/n) n? ");
	normal_tty();
	if(getchar() == 'y'){
	    signal(SIGQUIT,SIG_DFL);
	    kill(getpid(),SIGQUIT);
	}
	tset();
}

sig_msg(sig,code,scp)
int		sig,code;
struct sigcontext *scp;
{
long clock;
char *name;

    switch(sig){	
    case SIGSEGV :
	    printf("segmentation violation\n");
	    CoreRequest();
	    break;
    case SIGILL :
	    printf("illegal instruction. code = %d\n",code);
	    signal(SIGILL,sig_msg_restore_context);
	    CoreRequest();
	    break;
    case SIGFPE :
	    printf("floating point exception. code = %d\n",code);
	    CoreRequest();
	    break;
    case SIGBUS :
	    printf("bus error\n");
	    CoreRequest();
	    break;
    case SIGTRAP :
	    printf("trace trap\n");
	    CoreRequest();
	    signal(SIGTRAP,sig_msg_restore_context);
	    break;
    default:
	    printf("Fatal error *** sig %d : code %d\n",sig,code);
	    CoreRequest();
	    break;
    }
    printf("exit program (y/n) n? ");
    normal_tty();
    if(getchar() == 'y'){
	exit(0);
    }
    tset();
}

