#include <stdio.h>

#define MAXFUNCS 1000
is_space_char(c)
char	c;
{
	return(c== '\n' || c == ' ' || c=='\t');
}

GetLine(line,fp,size)
char 	*line;
FILE	*fp;
int		size;
{
int		eol;

	if(fgets(line,size,fp) == NULL) line[0] = '\0';;
	if((eol = strlen(line) - 1) >= 0){
		if(line[eol] == '\n') line[eol] = '\0';
	}
}


MakeFuncTableCode(file,funcname)
char *file;
char *funcname;
{
FILE *fp;
char line[80];
char *ptr;
char name[80];
char type[80];
struct {
    char name[40];
    char type[40];
} table[MAXFUNCS];
int count;
int i;

    /*
    ** open the function list file
    */
    if((fp = fopen(file,"r")) == NULL){
	fprintf(stderr,"unable to find function list file %s\n",file);
	return(0);
    }
    printf("#define PF(F,T) HashFunc(\"F\",F,\"T\")\n");

    printf("FUNC_%s(){\n",funcname);

    count = 0;
    while(!feof(fp) && count < MAXFUNCS){
	GetLine(line,fp,80);
	if(strlen(line) == 0) continue;
	ptr = line;
	/*
	** extract the type and name
	*/
	/*
	*** skip white space
	*/
	while(*ptr != '\0' && is_space_char(*ptr)) ptr++;
	sscanf(ptr,"%s",type);
	/*
	** scan to the next field
	*/
	while(*ptr != '\0' && !is_space_char(*ptr)) ptr++;
	while(*ptr != '\0' && is_space_char(*ptr)) ptr++;
	/*
	** there are no more fields on the line
	*/
	if(*ptr == '\0'){
	    /*
	    ** assume that the first field is the name and
	    ** the type is int
	    */
	    strcpy(name,type);
	    strcpy(type,"int");
	} else {
	    /*
	    ** skip any indirection
	    */
	    while(*ptr == '*') {
		strcat(type,"*");
		ptr++;
	    }
	    sscanf(ptr,"%s",name);
	}
	strcpy(table[count].name,name);
	strcpy(table[count].type,type);
	count++;
    }
    for(i=0;i<count;i++){
	printf("extern %s %s();\n",table[i].type,table[i].name);
    }
    for(i=0;i<count;i++){
	printf("HashFunc(\"%s\",%s,\"%s\");\n",
	table[i].name,table[i].name,table[i].type);
    }
    printf("}\n");
    printf("#undef PF\n");
}

main(argc,argv)
int argc;
char **argv;
{
    if(argc < 3) {
	printf("usage: %s file name\n",argv[0]);
	exit(0);
    }
    MakeFuncTableCode(argv[1],argv[2]);
    exit(0);
}
