
#include "sim_ext.h"
extern char *strchr();

/*
** parse a connection specification of the form
**
** 	:[a][a-b][#][@wildcard]
**
** If a path has been specified then return the list of elements
** The return value is the connection specification mode
*/
int ParseConnection(pathname,start_connection,end_connection,list)
char	*pathname;
int	*start_connection;
int	*end_connection;
ElementList	**list;
{
char	*delimiter;
int show_connections = 0;

    if(delimiter = strchr(pathname,':')){
	*delimiter = '\0';
	if(delimiter[1] == '@'){
	    /*
	    ** target path specification
	    */
	    show_connections = 4;
	    *list = WildcardGetElement(delimiter+2,0);
	} else
	if(delimiter[1] == '#'){
	    /* 
	    ** # for all connections 
	    */
	    show_connections = 3;
	} else 
	if(strchr(delimiter+1,'-')){
	    /*
	    ** range form a-b
	    */
	    show_connections = 2;
	    sscanf(delimiter+1,"%d-%d",start_connection,end_connection);
	} else {
	    /*
	    ** single connection form a
	    */
	    show_connections = 1;
	    *start_connection = atoi(delimiter+1);
	}
    }
    return(show_connections);
}

char *GetNameAndIndex(name,index)
char *name;
int *index;
{
static char elementname[100];
char *index_start;

    if(name == NULL) {
	*index = 0;
	return(NULL);
    }
    /*
    ** get the index
    */
    *index = GetIndexComponent(name);
    /*
    ** eliminate the index component from the elementname
    */
    strcpy(elementname,name);
    if((index_start = strchr(elementname,'[')) != NULL){
	*index_start = '\0';
    }
    return(elementname);
}

HasElementField(string)
char *string;
{
    if(string == NULL || strlen(string) == 0) return(0);
    return((strchr(string,':') != NULL));
}

char *SpecificField(field)
char *field;
{
char *specific_field;

    specific_field = strchr(field,'.');
    if(specific_field){
	return(specific_field+1);
    } else {
	printf("invalid specific field\n");
	return(NULL);
    }
}


char *Pathname(element)
Element 	*element;
{
static char 	name1[100];
static char 	name2[100];
char 		*name;
char 		*matchname;
static short 	which_name=0;
char 		tmp_name[100];
int 		index;
register Element 	*ptr;

    if(element == NULL){
	return("NULL");
    }
    if(element->parent == NULL){
	return("/");
    }
    if(which_name){
	name = name1;
    } else
	name = name2;
    which_name = (which_name +1)%2;
    name[0] = '\0';
    /*
    ** traverse back up the tree until reaching the root or a NULL parent
    */
    while(element->parent != NULL){
#ifdef OLD
	/*
	** find the index of the element
	** by searching the parents child tree
	*/
	index = 0;
	matchname = element->name;
	for(ptr=element->parent->child;ptr && ptr != element;ptr=ptr->next){
	    if((ptr->name != NULL) && (strcmp(ptr->name,matchname) ==0)){
		index++;
	    }
	}
#else
	index = element->index;
#endif
	if(index > 0){
	    sprintf(tmp_name,"/%s[%d]%s",element->name,index,name);
	} else {
	    sprintf(tmp_name,"/%s%s",element->name,name);
	}
	/*
	** prepend the local path name onto the running path string
	*/
	strcpy(name,tmp_name);
	element = element->parent;
    }
    return(name);
}


char *GetParentComponent(string)
char *string;
{
static char 	pathname[100];
char 		*path_ptr;

    pathname[0] = '\0';
    if(string == NULL){
	return(pathname);
    }
    /*
    ** search back for the parent element
    */
    strcpy(pathname,string);
    /*
    ** search back in the string until reaching then next level
    ** in the tree
    */
    for(path_ptr = pathname+strlen(pathname);
	(path_ptr != pathname && *path_ptr != '/'); 
	path_ptr--);
    if(*path_ptr == '/'){
	path_ptr++;
    }
    *path_ptr = '\0';
    return(pathname);
}

char *GetBaseComponent(string)
char *string;
{
static char base[100];
char tmp[100];
char *tmp_ptr;
char *end_ptr;

    base[0] = '\0';
    if(string == NULL)
	return(base);
    strcpy(tmp,string);
    /*
    ** search back for the parent element
    */
    for(tmp_ptr=tmp+strlen(tmp);((tmp_ptr!=tmp) && (*tmp_ptr!='/'));tmp_ptr--);
    if(*tmp_ptr == '/'){ 
	tmp_ptr++;
    }
    /*
    ** search forward for the end of the base
    */
    for(end_ptr = tmp_ptr;((*end_ptr != '\0') && (*end_ptr != ':')); end_ptr++);
    *end_ptr = '\0';
    strcpy(base,tmp_ptr);
    return(base);
}

/*
** extract the string up to a colon
*/
char *GetPathComponent(string)
char *string;
{
static char pathname[100];
char *path_ptr;

    pathname[0] = '\0';
    if(string == NULL)
	return(pathname);
    path_ptr = pathname;
    while(*string != '\0' && *string != ':'){
	*path_ptr++ = *string++;
    }
    *path_ptr = '\0';
    return(pathname);
}

/*
** extract the string which follows a colon in the pathname
*/
char *GetFieldComponent(string)
char *string;
{
static char field[100];
char *field_ptr;

	field[0] = '\0';
	if(string == NULL)
		return(field);
	field_ptr = field;
	while(*string != '\0' && *string != ':') string++;
	if(*string == ':') string++;
	while(*string != '\0'){
		*field_ptr++ = *string++;
	}
	*field_ptr = '\0';
	return(field);
}

GetIndexComponent(string)
char *string;
{
int index;

	if(string == NULL)
		return(0);
	while(*string != '\0' && *string != '[') string++;
	if(*string == '['){
		sscanf(string+1,"%d",&index);
		return(index);
	} else {
		return(0);
	}
}

char *do_pathname(argc,argv)
int argc;
char **argv;
{
int 	nxtarg;
char 	*path;

    if(argc < 3){
	printf("usage: %s name [-tail][-head]\n",argv[0]);
	return(NULL);
    }
    nxtarg = 1;
    path = argv[1];
    while(++nxtarg < argc){
	if(strcmp(argv[nxtarg],"-head") == 0){
	    return(CopyString(GetParentComponent(path)));
	} else
	if(strcmp(argv[nxtarg],"-tail") == 0){
	    return(CopyString(GetBaseComponent(path)));
	} else {
	    printf("invalid option '%s'\n",argv[nxtarg]);
	}
    }
    return(NULL);
}
