#include "sim_ext.h"

static int 	nsteps;
static int 	stepcount;
static int 	verbose;
static float	start_time;
static float	duration;
static double 	utime1,stime1;
static int	job = -1;
static int	current_step = 0;
static int 	break_flag = 0;
static char 	string[100];

int SetBreakFlag() { break_flag = 1; }
int GetCurrentStep(){ return(current_step); }

StepStatus()
{
    sprintf(string,"time = %f ; step = %d          ",
    simulation_time,
    current_step);
    /*
    ** try printing to the status line
    */
    if(!StatusMessage(string,30,0)){
	printf("%s\n",string);
    }
}

SetCurrentStep(val)
int val;
{
    current_step = val;
}

StepSimulation()
{
    ExecuteTasks();
    stepcount++;
    current_step++;
    nsteps--;
    simulation_time += ClockValue(0);
    if(verbose && !IsSilent()){
	StepStatus();
    }
    if(break_flag || nsteps <= 0){
	/*
	** when completed
	*/
	RemoveJob(job);
	job = -1;
	ReportStatus();
    }
}

TStepSimulation()
{
    ExecuteTasks();
    stepcount++;
    current_step++;
    simulation_time += ClockValue(0);
    if(verbose && !IsSilent()){
	StepStatus();
    }
    if(break_flag || simulation_time - start_time >= duration){
	/*
	** when completed
	*/
	RemoveJob(job);
	job = -1;
	ReportStatus();
    }
}

RemoveSimulationJob()
{
    RemoveJob(job);
    job = -1;
}

void ActivateStep(mode,start,dur,n,v)
int	mode;
float	start;
float	dur;
int	n;
int	v;
{
    /* 
    ** reset the break flag 
    */
    break_flag = FALSE;
    stepcount=0;

    start_time = start;
    nsteps = n;
    verbose = v;
    duration = dur;

    rtd(&utime1,&stime1);

    switch(mode){
    case 0:
	job = AddJob(StepSimulation,0);
	break;
    case 1:
	job = AddJob(TStepSimulation,0);
	break;
    }
}

ReportStatus()
{
double 		utime2,stime2;

    rtd(&utime2,&stime2);
    if(!IsSilent()){
	StepStatus();
	printf("completed %d steps in %f cpu seconds\n",
	stepcount,
	utime2-utime1);
    }
}



/*
** advance the simulation
*/
int do_bgsimulate(argc,argv)
int	argc;
char	**argv;
{
int		verbose = 0;
int		mode = 0;
float		duration;
int		nsteps = 1;
int		nxtarg;

    if(job >= 0){
	printf("simulation is already in progress [%d]\n",job);
	return(0);
    }
    nxtarg = 0;
    while(++nxtarg < argc ){
	if(strcmp(argv[nxtarg],"-t") == 0){
	    mode = 1;
	    duration = Atof(argv[++nxtarg]);
	} else
	if(strcmp(argv[nxtarg],"-v") == 0){
	    verbose = 1;
	} else 
	if(strcmp(argv[nxtarg],"-usage") == 0){
	    printf("usage: %s [#][-t #][-v]\n",argv[0]);
	    return(0);
	} else 
	if(argv[nxtarg][0] != '-'){
	    mode = 0;
	    nsteps = atoi(argv[nxtarg]);
	}
    }
    ActivateStep(mode,simulation_time,duration,nsteps,verbose);
    return(1);
}

int do_simulate(argc,argv)
int	argc;
char	**argv;
{
int		verbose = 0;
int		mode = 0;
float		duration;
int		nsteps = 1;
int		nxtarg;
int		bg = 0;

    if(job >= 0){
	printf("simulation is already in progress [%d]\n",job);
	return(0);
    }
    nxtarg = 0;
    while(++nxtarg < argc ){
	if(strcmp(argv[nxtarg],"-t") == 0){
	    mode = 1;
	    duration = Atof(argv[++nxtarg]);
	} else
	if(strcmp(argv[nxtarg],"-v") == 0){
	    verbose = 1;
	} else 
	if(strcmp(argv[nxtarg],"&") == 0){
	    bg = 1;
	} else 
	if(strcmp(argv[nxtarg],"-usage") == 0){
	    printf("usage: %s [#][-t #][-v][&]\n",argv[0]);
	    return(0);
	} else 
	if(argv[nxtarg][0] != '-'){
	    mode = 0;
	    nsteps = atoi(argv[nxtarg]);
	}
    }
    ActivateStep(mode,simulation_time,duration,nsteps,verbose);
    if(!bg){
	/*
	** do the simulation on the spot
	*/
	while(job != -1){
	    ExecuteJobs();
	}
	return(1);
    }
    return(1);
}
