#include "sim_ext.h"
#include "hash.h"

HASH *action_hash_table;

/*
** Hash table utilities
*/
void ActionHashInit()
{
HASH *hash_create();

    /*
    ** create the table
    */
    action_hash_table = hash_create(100);
}

int ActionHashPut(key,action)
char	*key;
Action	*action;
{
ENTRY	item,*hash_enter();

    item.data = (char *)malloc(sizeof(Action));
    bcopy(action,item.data,sizeof(Action));
    item.key = CopyString(key);
    /*
    ** put the action into the table
    */
    if(hash_enter(&item,action_hash_table) == NULL){
	Error();
	printf("action hash table full\n");
	return(0);
    };
    return(1);
}

Action *GetAction(name)
char	*name;
{
ENTRY	*found_item,*hash_find();

    /*
    ** get the action from the table
    */
    if((found_item = hash_find(name,action_hash_table)) != NULL){
	return((Action *)(found_item->data));
    } else
	return(NULL);
}

char *GetActionName(type)
int	type;
{
extern HASH *action_hash_table;
char 	*name;
int 	i;
static char	actionname[200];
int	multiple = 0;

    actionname[0] = '\0';
    for(i=0;i<action_hash_table->size;i++){
	if(name = action_hash_table->entry[i].key){
	    if(type == ((Action *)(action_hash_table->entry[i].data))->type){
		if(multiple){
		    strcat(actionname," , ");
		}
		strcat(actionname,name);
		multiple = 1;
	    }
	}
    }
    if(strlen(actionname) == 0){
	return("???");
    } else
	return(actionname);
}

AddAction(name,type)
char	*name;
int	type;
{
Action	action;

    bzero(&action,sizeof(Action));
    action.name = CopyString(name);
    action.type = type;
    ActionHashPut(action.name,&action);
}

void do_add_action(argc,argv)
int	argc;
char 	**argv;
{
char	*name;

    if(argc < 3){
	printf("usage: %s actionname value\n",argv[0]);
	return;
    }
    AddAction(argv[1],atoi(argv[2]));
}

void BasicActions()
{
    AddAction(	"INIT",		INIT		);
    AddAction(	"PROCESS",	PROCESS		);
    AddAction(	"RESET",	RESET		);
    AddAction(	"CHECK",	CHECK		);
    AddAction(	"CREATE",	CREATE		);
    AddAction(	"COPY",		COPY		);
    AddAction(	"SET",		SET		);
    AddAction(	"SHOW",		SHOW		);
    AddAction(	"RECALC",	RECALC		);
    AddAction(	"DELETE",	DELETE		);
    AddAction(	"SAVE",		SAVE		);
    AddAction(	"RESTORE",	RESTORE		);
    AddAction(	"SAVE2",	SAVE2		);
    AddAction(	"RESTORE2",	RESTORE2	);
    AddAction(	"SETUP",	SETUP		);
    AddAction(	"RESULTS",	RESULTS		);
}

void do_list_actions()
{
extern HASH *action_hash_table;
char 	*name;
int	cnt=0;
int 	i;

    printf("\DEFINED CLASSES:\n");
    for(i=0;i<action_hash_table->size;i++){
	if(name = action_hash_table->entry[i].key){
	    printf("[ %3d ] %-12s",
	    *((int *)(action_hash_table->entry[i].data)),name);
	    if(((++cnt)%4) == 0){
		printf("\n");
	    }
	}
    }
    printf("\n\n");
}

AddActionToObject(object,name,function)
GenesisObject	*object;
char	*name;
PFI	function;
{
ActionList	*new;
Action		*action;

    if(!(action = GetAction(name))){
	return(0);
    }
    /*
    ** add the new valid action to the object
    */
    new = (ActionList *)calloc(1,sizeof(ActionList));
    new->name = action->name;
    new->type = action->type;
    new->function = function;
    new->next = object->valid_actions;
    object->valid_actions = new;
    return(1);
}

char *Actionname(action)
Action		*action;
{
    return(action->name);
}

char *CheckActionType(object,type)
GenesisObject	*object;
int	type;
{
ActionList	*list;

    for(list=object->valid_actions;list;list=list->next){
	if(list->type == type){
	    return(list->name);
	}
    }
    return(NULL);
}

int CheckActionName(object,name)
GenesisObject	*object;
char	*name;
{
ActionList	*list;

    for(list=object->valid_actions;list;list=list->next){
	if(strcmp(list->name,name) == 0){
	    return(list->type);
	}
    }
    return(-1);
}

PFI GetActionFunc(object,type)
GenesisObject	*object;
int	type;
{
ActionList	*alist;

    for(alist=object->valid_actions;alist;alist=alist->next){
	if(alist->type == type){
	    return(alist->function);
	}
    }
    return(NULL);
}
