#include "sim_ext.h"

void Enable(element)
Element *element;
{
    if(element != NULL)
    element->flags &= ~BLOCKMASK;
}

void Block(element)
Element *element;
{
    if(element != NULL)
    element->flags |= BLOCKMASK;
}

int IsEnabled(element)
Element *element;
{
    if(element != NULL)
	return((element->flags & BLOCKMASK) == 0);
    else
    return(FALSE);
}

int IsActive(element)
Element *element;
{
    if(element != NULL & element->object != NULL){
	return(element->object->function != NULL);
    } else {
	return(0);
    }
}

int do_enable(argc,argv)
int	argc;
char	**argv;
{
Element		*element;

    if(argc < 2){
	printf("usage: %s element\n");
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	Error();
	printf("cannot find element '%s'\n",argv[1]);
	return(0);
    }
    Enable(element);
    OK();
    return(1);
}

int do_disable(argc,argv)
int	argc;
char	**argv;
{
Element		*element;

    if(argc < 2){
	printf("usage: %s element\n");
	return(0);
    }
    if((element = GetElement(argv[1])) == NULL){
	Error();
	printf("cannot find element '%s'\n",argv[1]);
	return(0);
    }
    Block(element);
    OK();
    return(1);
}
