#include "shell_ext.h"
#include <sys/time.h>
#include <signal.h>

#define MAXJOBS			100

Usleep(usec)
int usec;
{
struct timeval	timeout;

    timeout.tv_sec = 0;
    timeout.tv_usec = usec;
    select(32,NULL,NULL,NULL,&timeout);
}

static Job 	job[MAXJOBS];
static int	max_jobs = 0;
static int	grab_cpu = 0;

Sleep(){
#ifdef MASSCOMP
    /*
    ** sleep for .1 second
    ** WARNING may affect priority sensitive functions
    */
    astpause(0,100);
#else
    /*
    ** sleep for .1 sec
    */
    Usleep(100000);
#endif
}

void InitJobs()
{
extern int iofunc();
    max_jobs = 0;
    bzero(job,MAXJOBS*sizeof(Job));
#if(!defined(SIGIO) || defined(PLAINTERM))
    AddJob(iofunc,1);
#endif
}

ExecuteJobs()
{
int	i;

    /*
    ** scan through all the jobs
    */
    for(i=0;i<max_jobs;i++){
	/*
	** execute the job function
	*/
	if(job[i].function && ((job[i].count++ % (job[i].priority + 1)) == 0)){
	    job[i].function();
	}
    }
    /*
    ** if there is no job with maximum priority then
    ** sleep to avoid pounding on the cpu
    */
    if(!grab_cpu) Sleep();
}

AddJob(func,priority)
PFI	func;
int	priority;
{
int i;

    if(func == NULL) return(-1);
    if(priority < 0) priority = 0;
    /*
    ** find the first open job slot
    */
    for(i=0;i<max_jobs;i++){
	if(job[i].function == NULL) break;
    }
    if(i < MAXJOBS){
	job[i].function = func;
	job[i].priority = priority;
	if(i >= max_jobs) max_jobs++;
    }
    if(priority == 0) grab_cpu = 1;
    return(max_jobs-1);
}

RemoveJob(i)
int	i;
{
int j;

    /*
    ** remove it
    */
    if(i < max_jobs && i >= 0 ){
	bzero(job+i,sizeof(Job));
	if(i == max_jobs-1) max_jobs--;
    }
    /*
    ** recheck the peak priorities
    */
    grab_cpu = 0;
    for(j=0;j<max_jobs;j++){
	if(job[j].function != NULL && job[j].priority == 0) grab_cpu = 1;
    }
}

do_add_job(argc,argv)
int	argc;
char	**argv;
{
int priority = 0;

    if(argc < 2){
	printf("usage: %s function [priority (0=max)]\n",argv[0]);
	return;
    }
    if(argc > 2){
	priority = atoi(argv[2]);
    }
    if(AddJob(GetFuncAddress(argv[1]),priority) == -1){
	printf("%s unable to add job %s\n",argv[0],argv[1]);
    }
}

do_remove_job(argc,argv)
int	argc;
char	**argv;
{
    if(argc < 2){
	printf("usage: %s job#\n",argv[0]);
	return;
    }
    RemoveJob(atoi(argv[1]));
}

do_change_priority(argc,argv)
int	argc;
char	**argv;
{
int	j,n,priority;

    if(argc < 3){
	printf("usage: %s job# priority\n",argv[0]);
	return;
    }
    n = atoi(argv[1]);
    priority = atoi(argv[2]);
    if(n < max_jobs){
	printf("old priority = %d. new priority = %d\n",
	job[n].priority,
	priority);
	job[n].priority = priority;
	/*
	** reevaluate the peak priority
	*/
	grab_cpu = 0;
	for(j=0;j<max_jobs;j++){
	    if(job[j].priority == 0) grab_cpu = 1;
	}
    } else {
	printf("no such job [%d]\n",n);
    }
}

do_list_jobs()
{
int	i;

    /*
    ** scan through all the jobs
    */
    printf("\nSimulator Jobs\n\n");
    if(max_jobs == 0){
	printf("----- none ----\n");
    }
    for(i=0;i<max_jobs;i++){
	/*
	** print the function name
	*/
	if(job[i].function){
	    printf("[%d] %-20s priority %d\n",
	    i,GetFuncName(job[i].function),job[i].priority);
	}
    }
    if(grab_cpu){
	printf("\ncpu ACTIVE\n");
    } else {
	printf("\ncpu SLEEPING\n");
    }
    printf("\n");
}

