#include "per_ext.h"

/* 9/88 Matt Wilson */
int RadialDelay(argc,argv)
int argc;
char **argv;
{
float scale;
float lower,upper;
float mean,sd,var;
float x,y;
int mode;
Connection *connection;
Projection *projection;
ElementList	*list;
char *path;
int	i;

    if(argc < 3){
	printf("usage: %s path [scale][-uniform low high][-gaussian mean sd lower upper]\n",
	argv[0]);
	printf("[-exp low high]\n");
	return(0);
    }
    path = argv[1];
    /*
    ** check the distribution options
    */
    if(strcmp(argv[2],"-uniform") == 0){
	mode = 1;
	lower = Atof(argv[3]);
	upper = Atof(argv[4]);
    } else
    if(strcmp(argv[2],"-gaussian") == 0){
	mode = 2;
	mean = Atof(argv[3]);
	sd = Atof(argv[4]);
	lower = Atof(argv[5]);
	upper = Atof(argv[6]);
	var = sd*sd;
    } else 
    if(strcmp(argv[2],"-exp") == 0){
	mode = 3;
	lower = Atof(argv[3]);
	upper = Atof(argv[4]);
    } else 
    if(argv[2][0] != '-'){
	mode = 0;
	scale = Atof(argv[2]);
    } else {
	Error();
	printf("%s : invalid option '%s'\n",argv[0],argv[2]);
	return;
    }
    list = WildcardGetElement(path,1);
    for(i=0;i<list->nelements;i++){
	switch(mode){
	case 0:			/* constant */
	    break;
	case 1:			/* uniform */
	    scale = frandom(lower,upper);
	    break;
	case 2:			/* gaussian */
	    do {
		scale = rangauss(mean,var);
	    } while((scale < lower) || (scale > upper));
	    break;
	case 3:			/* exponential */
	    scale = -log(frandom(lower,upper));
	    break;
	}
	if(scale <= 0) scale = 0;
	projection = (Projection *)list->element[i];
	x = projection->x;
	y = projection->y;
	for(connection=projection->connection;connection;
	connection=connection->next){
	    /*
	    ** calculate delay based on radial distance multiplied
	    ** by inverse velocity
	    */
	    connection->delay =
	    sqrt( sqr(x - connection->target->x) +
		sqr(y - connection->target->y)) * scale;
	}
	printf("."); fflush(stdout);
    }
    printf("\n");
    FreeElementList(list);
    OK();
    return(1);
}

