#include "out_ext.h"

AscSetupFile(output)
struct ascfile_type *output;
{
float	fval;
int	i;
MsgIn	*msg;

    /*
    ** try to close up the file if it has been left open
    */
    CloseOutputFile(output);
    /*
    ** try to open the file
    */
    if(OpenOutputFile(output,"w")){
	/*
	** go to the beginning of the file
	*/
	fseek(output->fp, 0L, 0);
	ConditionalCloseOutputFile(output);
	/*
	** indicate that the file has been initialized
	*/
	output->initialize = FALSE;
    }
}


AscFileOutput(output,action)
struct ascfile_type *output;
Action		*action;
{
    switch(action->type){
    case RESET:
	/*
	** set the initialization flag
	*/
	if(!output->append){
	    output->initialize = TRUE;
	}
	break;
    case PROCESS:
	/*
	** has the file been initialized?
	*/
	if(output->initialize){
	    AscSetupFile(output);
	}
	/*
	** open the file and append data to it
	*/
	if(OpenOutputFile(output,"a")){
	    AscWriteOutput(output);
	    ConditionalCloseOutputFile(output);
	}
	break;
    case DELETE:
    case SAVE:
	CloseOutputFile(output);
	break;
    default:
	InvalidAction("FileOutput",output,action);
	break;
    }
}

AscWriteOutput(output)
struct ascfile_type *output;
{
FILE *fp;
MsgIn	*msg;
float	fval;

    fp = output->fp;
    if(!output->notime){
	fprintf(fp,"%g ",simulation_time);
    }
    MSGLOOP(output,msg){
	case 0:
	    fval = MsgValue(msg,float,0);
	    fprintf(fp,"%g ",fval);
	    break;
    }
    fprintf(fp,"\n");
    /*
    ** force it to disk if actioned
    */
    if(output->flush)
	fflush(fp);
}

