#include "struct_defs.h"
#define NODORS 10
#define TABCREATE 200

struct olf_receptor_type {
	SEGMENT_TYPE
	float	response[NODORS];
	float	Vm;
	float	Vmin;
	float	Vmax;
	float	max_rate;
	float	min_rate;
	float	state;
	float	gain;
	int		transfer_form;
};

struct olf_receptor2_type {
	SEGMENT_TYPE
	float	*response;
	float	modulation;
	int		nodors;
	short	allocated;
	double	Ik;
	double	Gk;
	float	Ek;
	double	X,Y;	/* State variables for time response */
	float	tau1;
	float	tau2;
	float	gmax;
	double	xconst1;
	double	xconst2;
	double	yconst1;
	double	yconst2;
	float	norm;
};

struct disk_in_type {
	SEGMENT_TYPE
	FILE	*fp;
	char	*filename;
	short	is_open;	/* is the file open yet ? */
	short	leave_open; /* leave the file open between cycles */
	short	loop;		/* Loop back to start when eof */
	int		nx,ny;		/* dimensions of array */
	short	allocated;	/* is the array allocated yet ? */
	float	**val;		/* array */
};

struct interpol_struct {
    double  xmin;
    double  xmax;
    int     xdivs;
    double  dx;
    double  *table;
    short   extrapolation_mode;
    short   allocated;
};

typedef struct interpol_struct Interpol;

struct tab_gate_type {
    SEGMENT_TYPE
    double	m;
	struct interpol_struct *alpha;
	short	alpha_alloced;
	struct interpol_struct *beta;
	short	beta_alloced;
    short	instantaneous;
};

struct table_type {
	ELEMENT_TYPE
	double	input;
	double	output;
	struct interpol_struct *table;
	short	alloced;
};
