#include "buf_ext.h"

int	DEBUG_GradedEvent = 0;

#define Field(F)	(buffer->F)

/* M.Wilson Caltech 6/88 */
GradedEvent (buffer,action)
register struct graded_type *buffer;
Action 	*action;
{
MsgIn	*msg;
double	scale;
double 	baseline;	
double 	grade;	
double 	rectify;	
int	status;
int	has_state;

    if(Debug(DEBUG_GradedEvent) > 1){
	ActionHeader("GradedEvent",buffer,action);
    }
    switch(action->type){
    case PROCESS:
	/*
	** set default values
	*/
	baseline = Field(baseline);
	rectify = Field(rectify);
	scale = Field(scale);
	if(scale == 0) scale = 1;
	/*
	** read messages
	*/
	for(msg=buffer->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    /*
	    ** type 0 : buffer state used to compute graded output
	    */
	    case 0:
		buffer->state = MsgValue(msg,double,0);
		break;
	    /*
	    ** type 1 : rectification baseline
	    */
	    case 1:
		baseline = MsgValue(msg,double,0);
		break;
	    }
	}
	/*
	** calculate graded output
	*/
	grade = (buffer->state - baseline)*scale;
	if(!rectify || grade >= 0){
	    /*
	    ** add an event to the potential buffer
	    */
	    PutEvent(buffer,grade, NULL, WRAP);
	}
	break;
    case RESET:
	ClearBuffer(buffer);
	break;
    case CHECK:
	status = 1;
	has_state = 0;
	for(msg=buffer->msg_in;msg;msg=msg->next){
	    switch(msg->type){
	    case 0:
		has_state = 1;
		break;
	    }
	}
	if(!has_state){
	    ErrorMessage("GradedEvent","No input.",buffer);
	}
	break;
    default:
	InvalidAction("GradedEvent",buffer,action);
	break;
    }
}
#undef Field

