// genesis

include squid_consts.g
include squid_proto.g

function squid_cmpt(path, length, diameter)
str path
float length, diameter		// um

    push	// save incoming path

    //
    //==============================
    // construct a new compartment
    //==============================
    //
    create compartment {path}
    set -env {path}                     \
	parent_cmpt     ""              \  
	child_cmpt_1    ""              \
	child_cmpt_2    ""              \ 
	length          {length}        \
	diameter        {diameter}      \
	angle           90 
    ce {path}
    
    
    // Add Na and K channels
    
    copy /proto/hh_channels/Na_squid Na
    copy /proto/hh_channels/K_squid K

    // Gates need an initial voltage (RESET) and
    // the current voltage (PROCESS):
    // We'll send them the compartment voltage in both cases,
    // But we'll have to make sure that the compartment is RESET
    // before the gates are RESET so that the initial value is correct.

    sendmsg {path}	{path}/Na	VOLTAGE Vm
    sendmsg {path}	{path}/Na/m	VOLTAGE Vm
    sendmsg {path}	{path}/Na/h	VOLTAGE Vm
    sendmsg {path}	{path}/Na/m	EREST   Vm
    sendmsg {path}	{path}/Na/h	EREST   Vm

    sendmsg {path}	{path}/K	VOLTAGE Vm
    sendmsg {path}	{path}/K/n	VOLTAGE Vm
    sendmsg {path}	{path}/K/n	EREST   Vm

    // The compartment needs the channel conductance
    // and equilibrium voltage

    sendmsg {path}/Na	{path}		CHANNEL Gk Ek
    sendmsg {path}/K	{path}		CHANNEL Gk Ek


    // compartment parameters

    float xarea = 1e-8*PI*diameter*diameter/4.0 // cm^2
    float area = 1e-8*length*PI*diameter	// cm^2

    set Em	{Vleak_squid}		// mV
    set Cm	{Cm_squid*area}		// uF
    set Rm	{1/(Gleak_squid*area)}	// kohm
    set Ra	{Ra_squid*length/xarea}	// kohm

    // channel parameters

    set Na	Ek	{VNa_squid}
    set Na	gbar	{GNa_squid*area} // mS

    set K	Ek	{VK_squid}
    set K	gbar	{GK_squid*area}	// mS

    pop		//restore path
end
