//genesis

// Setting the axonal propagation velocity
float CABLEVEL = 1	// m/sec

/* Usage :
** region_connect source_cells to destination_cells with connection_type
** relative_or_absolute_connection_mode
** Number_of_source_regions_being_defined
** Sign_of_this_region
** (range of source cells) xmin ymin xmax ymax
** Number_of_destination_regions_being_defined
** Sign_of_this_region
** (range of destination cells) xmin ymin xmax ymax
*/


echo Making connections from the retina to the lgn horiz cells.
region_connect /retina/recplane/rec[]/axon to \
	/lgn/horiz/soma[]/exc_syn with synapse -rel \
	1 1 	-1 -1	 1 1 \
	1 1 	{-LGN_SEPX * 1.2}	 {-LGN_SEPY * 0.6} \
			{LGN_SEPX * 1.2}		 {LGN_SEPY * 0.6}


echo Making connections from the retina to the lgn vert cells.
region_connect /retina/recplane/rec[]/axon to \
	/lgn/vert/soma[]/exc_syn with synapse -rel \
	1 1 	-1 -1	 1 1 \
	1 1 	{-LGN_SEPX * 0.6}	 {-LGN_SEPY * 1.2} \
			{LGN_SEPX * 0.6}	 {LGN_SEPY * 1.2}


echo setting weights and delays for ret-lgn connections.
// assigning delays using the RadialDelay function
/* Usage :
** RadialDelay list_of_axons propagation_velocity
*/
execute RadialDelay /retina/recplane/rec[]/axon {CABLEVEL}

// assigning weights using the ExpWeight function
/* Usage :
** ExpWeight list_of_axons rate_of_decay_of_exp Max_weight Min_weight
*/
execute ExpWeight /retina/recplane/rec[]/axon \
    { -1.0 / REC_SEPX } 10000.0 0.1

