//genesis

str quit_form = "Do you really want to quit ?"
str help_form = "Using the Neuron simulation kit"
str file_form = "file_form"
str select_form = "Select Level of analysis"
str multisim_form = "Neurons to be simulated simultaneously"
str chosencell = "Selected cell name"
str iocell = "Cell for IO"
str author = "Your Name"

function do_title_bar

	create xform /title_bar [0,0,1000,25] -nolabel
	ce ^
	disable .
	create xbutton quit [1%,2,14%,20] \
		-script popup_quit
	create xbutton help [16%,2,15%,20] \
		-script popup_help
	create xbutton file [32%,2,15%,20] \
		-script popup_file
	create xbutton "run cell" [48%,2,9%,20] \
		-script "set_level run_neuron"
	create xbutton "edit cell" [58%,2,9%,20] \
		-script "set_level neuron"
	create xbutton "edit compt" [68%,2,9%,20] \
		-script "set_level compt"
	create xbutton "edit channel" [78%,2,9%,20] \
		-script "set_level channel"
	create xbutton multisim [88%,2,11%,20] \
		-script popup_multisim
	
	create xform /{quit_form} [0,40,200,100]
	ce ^
	disable .
	create xbutton yes -script quit
	create xbutton no -script popdown_quit

	create xform /{help_form} [160,40,600,850] -notitle
	ce ^
	disable .
	create xlabel /{help_form}/header [1%,2,98%,25] -title {help_form}
	create xlabel /{help_form}/instr [1%,28,98%,25] \
		-title "Left and right buttons move up and down; double clicks move a page at a time"
	create xtext /{help_form}/text \
		[1%,55,98%,87%] -file README
	create xbutton "CANCEL" -script popdown_help

	create xform /{select_form} [480,40,300,100]
	ce ^
	disable .
	create xbutton "Single Neuron level" -script "set_level neuron"
	create xbutton "Compartment level" -script "set_level compt"
	create xbutton "Channel level" -script "set_level channel"
	create xbutton "CANCEL" -script popdown_select

	create xform /{multisim_form} [800,40,300,100]
	ce ^
	disable .
	create xbutton "CANCEL" -script popdown_multisim

	create xform /{file_form} [320,40,300,325] -nolabel
	ce ^
	disable .
	create xlabel "Cell Selection"
	create xdialog {chosencell} \
		-value /camit -script "choose_cell "<widget> 
	create xlabel "Cell Parameter IO"
	create xdialog {iocell} \
		-value /camit
	create xdialog source_file_name -value camit.p
	create xbutton "Load from file" -script do_cell_load
	create xdialog "Save to file" \
		-script "do_cell_save "<widget> -value newcamit.p
	create xdialog {author} -value "Upi Bhalla"
	create xbutton "New Cell" -script "do_new_cell "<widget> \
		-value "/newcell"
	create xlabel " "
	create xbutton "CANCEL" -script popdown_file
	create neutral /dummy
end

function popup_quit
	xshow_on_top /{quit_form}
end

function popup_help
	xshow_on_top /{help_form}
end

function popup_file
	xshow_on_top /{file_form}
end

function popup_select
	xshow_on_top /{select_form}
end

function popup_multisim
	xshow_on_top /{multisim_form}
end


function popdown_quit
	xhide /{quit_form}
end

function popdown_help
	xhide /{help_form}
end

function popdown_file
	xhide /{file_form}
end

function popdown_select
	xhide /{select_form}
end

function popdown_multisim
	xhide /{multisim_form}
end

function choose_cell(widget)
	str widget

    push /{file_form}
	xhide .
	str newcell = get({chosencell},value)

	if (!{exists({newcell})})
		echo {newcell} does not exist
		return
	end
	if (strcmp({cellpath},{newcell}) == 0)
		return
	end

	if ({exists({newcell}xout)})
		if (strcmp({analysis_level},"run_neuron") == 0)
			xshow_on_top {newcell}graph
			xshow_on_top {newcell}xout
		end
	end

	if (exists({cellpath}))
   		disable {cellpath}
		disable {cellpath}graph
		disable {cellpath}xout
		xhide {cellpath}graph
		xhide {cellpath}xout
	end

    cellpath = newcell
	if (!{exists({cellpath}xout)})
		do_xout
		do_xgraph
	end
   	enable {cellpath}
	enable {cellpath}graph
	enable {cellpath}xout
    reset

	set {cellpath}xout/draw/cell fatfix FALSE
    set {cellpath}xout/draw/cell path {cellpath}"/##[TYPE=compartment]"
	set {cellpath}xout/draw/cell fatfix TRUE
    set /compt_select/draw/cell path {cellpath}"/##[TYPE=compartment]"
	set /cell_run_control/field_path value {cellpath}/##[TYPE=compartment]
	pop
end

function do_cell_load
	str wid = "/" + {file_form} + "/source_file_name"
	
	push /{file_form}
	read_cell {get({wid},value)} {get({iocell},value)}
	reset
	push /{file_form}
    set {chosencell} value {get({iocell},value)}
    choose_cell {chosencell}
    pop
	xhide /{file_form}
end

function do_cell_save(widget)
	str widget

	push /{file_form}
	write_cell {get({widget},value)} {get({iocell},value)} \
		-author {get({author},value)}
    pop
	xhide /{file_form}
end

function do_new_cell(widget)
	str widget

	echo not yet implemented
end

function set_level(level)
	str level

	if (!{exists({cellpath})})
		echo {cellpath} is not defined yet : a cell must be loaded in.
		return
	end

	if ({strcmp({analysis_level},{level})} == 0)
		return
	end

	if ({strcmp({level},"run_neuron")} == 0)
		xshow_on_top /cell_run_control
		xshow_on_top {cellpath}xout
		xshow_on_top {cellpath}graph
		set {cellpath}xout/draw/cell         colfield Vm \
                            colmax 0.01 \
                            colmin -0.1 \
                            labelmode none
		set {cellpath}/##[TYPE=compartment] inject 0.0
		do_run_clickmode(/cell_run_control/Recording)

		xhide /compt_display
		xhide /compt_select
		xhide /compt_lib_form
	else
		if ({strcmp({analysis_level},"new")} == 0)
		xshow_on_top /compt_display
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
		xshow_on_top /compt_select
		xshow_on_top /compt_lib_form
		end
	end
	if ({strcmp({level},"neuron")} == 0)
		xshow_on_top /cell_params
	end
	if ({strcmp({level},"compt")} == 0)
		xshow_on_top /compt_params
	end
	if ({strcmp({level},"channel")} == 0)
		xshow_on_top /channel_params
	end

	if ({strcmp({analysis_level},"run_neuron")} == 0)
		xshow_on_top /compt_display
		set /compt_select/draw/cell path {cellpath}/##[TYPE=compartment]
		xshow_on_top /compt_select
		xshow_on_top /compt_lib_form

		xhide /cell_run_control
		xhide {cellpath}xout
		xhide {cellpath}graph
	end
	if ({strcmp({analysis_level},"neuron")} == 0)
		xhide /cell_params
	end
	if ({strcmp({analysis_level},"compt")} == 0)
		xhide /compt_params
	end
	if ({strcmp({analysis_level},"channel")} == 0)
		xhide /channel_params
	end

	analysis_level = level
end
