//genesis

function expscale(factor,form)
	float factor
	str form

	str field
	float value

	field = get({form}/field,value)
	value = get({form}/{field},value)

	value = value * factor
	set {form}/{field} value {value}
end

function linscale(factor,form)
	float	factor
	str form

	str field
	float value
	float v1,v2
	float r
	float l,t
	int il,it
	float corr

	field = get({form}/field,value)
	value = get({form}/{field},value)

	r = value
	r = abs({r})
	l = log({r}) / log(10)
	if (l < 0)
		il = l - 1
		it = pow(10,{-il})
	else
		il = l
		it = pow(10,{il})
	end
	t = il
	t = pow(10,{il})
	l = r / t
	if (l > 9.999)
		t = t * 10.0
		l = l / 10.0
		if (il < 0)
			it = it / 10
		else
			it = it * 10
		end
		il = il + 1
	end
//	echo l = {l}, il = {il},  r = {r}, t = {t}
	if ((l >= 0.999) && (l < 2))
		r = t * 0.1
	end
	if ((l >= 1.999) && (l < 5))
		r = t * 0.2
	end
	if (l >= 4.999)
		r = t * 0.5
	end
	if (value > 0)
		corr = 0.5
	else
		corr = -0.5
	end
	t = it
	if (il > 0)
		value = trunc({((value + r * factor) * 10.0 / t + corr)}) * t / 10.0
	else
		value = trunc({((value + r * factor) * t * 10.0 + corr)})/(t * 10.0)
	end
	set {form}/{field} value {value}
end

function overscale(graph,widget)
	str graph,widget
	if (get({widget},state) == 1)
		set {graph} overlay 1
	else
		set {graph} overlay 0
	end
end

function scalegraph(graph)
	str graph

	int x,y,w
	str temp

	temp = get({graph},form)
	x = get({temp},x)
	y = get({temp},y)
	w = get({temp},width)

	create xform {graph}_scale -title Scale [{x},{y},200,280]
	create xbutton {graph}/scale [0,0,40,20] \
		-script "xshow_on_top "{graph}_scale
	create xtoggle {graph}/overlay [{w - 100},0,90,20] \
		-script "overscale "{graph}" "<widget>
	set ^ label0 "do not overlay" label1 "overlay"

	push {graph}_scale

	create xbutton "<<" -script "expscale 0.5 "{graph}_scale [2%,35,20%,16]
	create xbutton "<" -script "linscale -1.0 "{graph}_scale [24%,35,20%,16]
	create xbutton " >" -script "linscale 1.0 "{graph}_scale [56%,35,20%,16]
	create xbutton " >>" -script "expscale 2.0 "{graph}_scale [78%,35,20%,16]
	create xdialog field -value xmin -script "setfield "<widget>

	create xdialog xmin -value {get({graph},xmin)}
	create xdialog xmax -value {get({graph},xmax)}
	create xdialog ymin -value {get({graph},ymin)}
	create xdialog ymax -value {get({graph},ymax)}
	create xbutton APPLY -script "applyscale "{graph}" "{graph}_scale" 0"
	create xbutton APPLY_AND_VANISH -script "applyscale "{graph}" "{graph}_scale" 1"
	
	pop
end

function setfield(widget)
	str widget

	str field

	field = get({widget},value)
	if (strcmp({field},xmin) == 0)
		set {widget} value xmax
	end
	if (strcmp({field},xmax) == 0)
		set {widget} value ymin
	end
	if (strcmp({field},ymin) == 0)
		set {widget} value ymax
	end
	if (strcmp({field},ymax) == 0)
		set {widget} value xmin
	end
end

function applyscale(graph,form,vanish)
	str graph,form
	int vanish

	float xmin,ymin,xmax,ymax

	xmin = get({form}/xmin,value)
	xmax = get({form}/xmax,value)
	ymin = get({form}/ymin,value)
	ymax = get({form}/ymax,value)
	
	if (xmin > xmax)
		set {form}/xmin value {xmax}
		set {form}/xmax value {xmin}
		xmin = get({form}/xmin,value)
		xmax = get({form}/xmax,value)
	end
	
	if (ymin > ymax)
		set {form}/ymin value {ymax}
		set {form}/ymax value {ymin}
		ymin = get({form}/ymin,value)
		ymax = get({form}/ymax,value)
	end

	if (xmin != get({graph},xmin))
		set {graph} xmin {xmin}
	end

	if (xmax != get({graph},xmax))
		set {graph} xmax {xmax}
	end

	if (ymin != get({graph},ymin))
		set {graph} ymin {ymin}
	end

	if (ymax != get({graph},ymax))
		set {graph} ymax {ymax}
	end

	/*
	set {graph} xmin {xmin} ymin {ymin} xmax {xmax} ymax {ymax}
	*/

	if (vanish)
		xhide {form}
	end
end

function do_xgraph
	create xform {cellpath}graph [430,500,590,360]
	push {cellpath}graph
	disable .
	create xgraph graph [1%,2,98%,98%] -range [0,-0.1,0.1,0.4]
	set graph yoffset 0.1 ymax 0.4
	useclock graph 9
	scalegraph({cellpath}graph/graph)
	pop
end
