/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/kr_slave_proc.c,v $
  SHORTNAME      :
  SNNS VERSION   : 4.1

  PURPOSE        :
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           :

  CHANGED BY     :
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.2 $
  LAST CHANGE    : $Date: 1995/11/16 07:25:54 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/

#include <stdio.h>
#include <stdlib.h>/* getenv, exit */
#ifdef sgi
#include <sym.h>
#include <exception.h>
#endif
#include <sys/types.h> /* open */
#include <sys/socket.h>
#include <netinet/in.h>
#include <rpc/rpc.h>
/*#include <sys/dirent.h>*/
#include <dirent.h>
#include <sys/param.h>
#include <netdb.h>
#include <unistd.h>

#ifndef rand
#include "random.h"	 /*  Randomize Library Function Prototypes  */
#endif

#include "kr_typ.h"	 /*  Kernel Types and Constants  */
#include "glob_typ.h"
#include "kr_const.h"	 /*  Constant Declarators for SNNS-Kernel  */
#include "kr_def.h"	 /*  Default Values  */

#include "kr_io.h"	 /*  Kernel I/O-Routines */
#include "kr_funcs.h"    /*  Function Prototypes */
#include "kernel.h"	 /*  Function Prototypes */
#include "kr_mem.h"      /*  Function Prototypes */
#include "version.h"	 /*  Version and Patchlevel  */
#include "kr_mac.h"	 /*  Kernel Macros  */
#include "kr_newpattern.h"   /* new style pattern handling */
#include "kr_inversion.h" /* inversion algorithm routines */
#include "cc_rcc.h"


#ifdef __linux__
#ifdef d_namlen
#undef  d_namlen
#endif
#endif
#include "kr_ui.h"

#include "kr_ui_rpc.h"
#include "kr_slave.h"
#include "ui_rpcsnns.h"
#include "ui_rpcP.h"
#include "kr_ui_rpc_main.h"

#include "kr_slave_proc.ph"

int *
sl_get_snns_kernel_40(sl_par_get_kernel *par, struct svc_req * cl)
{
    static int info;
    struct client Client;
    if (strcmp(par->xguihost, null_ptr)==0) {
	Client.xguihost = NULL;
    }else{
	Client.xguihost = par->xguihost;
    }
    Client.xguiprogramm = par->xguipnumber;
    Client.xguiversion = par->xguiversion;
    Client.xguiid = par->xguiid;
    Client.uid = par->uid;
    Client.pid = par->pid;
    info = make_xgui_callback(&Client, NOERROR);

    return (&info);
}

char**
sl_get_kernel_infotext_40(void *dummy, struct svc_req * cl)
{
    static char *res = NULL;
    char *hp;
    int    no_of_sites, no_of_links, no_of_STable_entries, no_of_FTable_entries;
    int    unit_bytes, site_bytes, link_bytes, 
           NTable_bytes, STable_bytes, FTable_bytes;

    if(res == NULL){
	res = calloc(1,7168); /* Max Message size + XDR_INFO < 8K */
    }
    hp = res;
    sprintf(hp,"RPC - Interface 4.0\n");hp +=strlen(hp);
    sprintf(hp,"\n%s :\n\n", krui_getVersion());hp +=strlen(hp);

    krui_getNetInfo(&no_of_sites, &no_of_links,
		    &no_of_STable_entries, &no_of_FTable_entries);

    sprintf(hp,"#input  units: %6d\n#output units: %6d\n#patterns    : %6d\n",
	    krui_getNoOfInputUnits(), krui_getNoOfOutputUnits(), 
	    krui_getNoOfPatterns());hp +=strlen(hp);
 
    sprintf(hp,"#sites       : %6d\n#links       : %6d\n",
	    no_of_sites, no_of_links);
    hp +=strlen(hp);
    sprintf(hp,"#STable entr.: %6d\n#FTable-Entr.: %6d\n\n",
	    no_of_STable_entries, no_of_FTable_entries);
    hp +=strlen(hp);

    krui_getMemoryManagerInfo(&unit_bytes, &site_bytes, &link_bytes,
			      &NTable_bytes, &STable_bytes, &FTable_bytes);
    sprintf(hp,"sizes in bytes:\nunits        : %7d\nsites        : %7d\nlinks        : %7d\n",
	    unit_bytes, site_bytes, link_bytes);
    hp +=strlen(hp);
    sprintf(hp,"NTable       : %7d\nSTable       : %7d\nFTable       : %7d\n\n"
	    ,NTable_bytes, STable_bytes, FTable_bytes);
    hp +=strlen(hp);
    sprintf(hp,"learning function  : %s\n", krui_getLearnFunc());
    hp +=strlen(hp);
    sprintf(hp,"update function    : %s\n", krui_getUpdateFunc());
    hp +=strlen(hp);
    sprintf(hp,"initialize function: %s\n\n\n", krui_getInitialisationFunc());
    hp +=strlen(hp);

    return (&res);
}

sl_kernel_info    *
sl_get_kernel_info_40(void *dummy, struct svc_req * cl)
{
    static kernel_info info;

    info.pid = getpid();
    info.uid = getuid();
    info.port = 0;
    return (&info);
}

int *
sl_set_rpc_kernel_config_40(sl_par_config *par, struct svc_req * cl)
{
    static int res = RPC_NO_ERROR;

    memcpy(&kernel_config,par,sizeof(par_config));
    timervalue = kernel_config.exittimeout;
    /* Make shure that this is a slave */
    kernelMode = kernel_config.kernelMode = COOP_S_KERNEL;
    config_received = TRUE;
    return (&res);
}

sl_par_config *
sl_get_rpc_kernel_config_40(int *par, struct svc_req * cl)
{
    int i;
    if(config_received)
	return (&kernel_config);
    else{
	kernel_config.isUDP = FALSE;
	kernel_config.timeout.tv_sec = 25;
	kernel_config.timeout.tv_usec = 0;
	kernel_config.timeoutlong.tv_sec = MAXWAITTIME;
	kernel_config.timeoutlong.tv_usec = 0;
	kernel_config.exittimeout= TIMEOUTVAL;
	kernel_config.switchtolocalall = 5;
	kernel_config.switchtolocalsingle = 10;
	kernel_config.status = S_IDLE;

	if(!patternloaded)
	    kernel_config.PATTERN_SET_FILE[0] = '\0';
	
	/* Set default values */
	kernel_config.ui_patternLoadMode = OUTPUT_ACT;
	kernel_config.ui_shuffleFlg = FALSE;
	for(i=0 ; i <= 5 ; i++){
	    kernel_config.subIPatSize[i] = 1;
	    kernel_config.subIPatPos[i]  = 1;
	    kernel_config.subIPatStep[i] = 1;
	    kernel_config.subOPatStep[i] = 1;
	    kernel_config.subOPatSize[i] = 1;
	    kernel_config.subOPatPos[i]  = 1;
	}
	kernel_config.ui_learnParameters[0] = 0.2;
	kernel_config.ui_updateParameters[0] = 0.0;
	kernel_config.ui_initParameters[0] = 1.0;
	kernel_config.ui_initParameters[1] = -1.0;
	
	kernel_config.ui_numberOfCycles = 1;
	kernel_config.ui_numberOfSteps = 1;

	kernel_config.noOfPatterns = (krui_getNoOfPatterns()>0) ? krui_getNoOfPatterns() : 0;
	kernel_config.noOfUnits = krui_getNoOfUnits();
	kernel_config.noOfInput = krui_getNoOfInputUnits();
	kernel_config.noOfOutput = krui_getNoOfOutputUnits();
	kernel_config.noOfHidden = krui_getNoOfTTypeUnits(HIDDEN);
    }
    return(&kernel_config);
}

sl_res_send_kernel_msg *
sl_send_kernel_msg_40(int *par, struct svc_req * cl)
{
    static res_send_kernel_msg res;
    switch(*par){
      case PING:
	res.return_value = RPC_NO_ERROR;
	break;
      case SHUTDOWN:
	res.return_value = RPC_NO_ERROR;
	QuitKernel(NOSAVE);
	break;
      default:
	res.return_value = RPC_UNKNOWN_OPTION;
	break;
    }
    
    return (&res);
}

sl_rpc_DIRP *
sl_rpc_opendir_40(char **dirname, struct svc_req * cl)
{
    static long resp;
    char *d1;
    if (strcmp(*dirname, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = *dirname;
    }
    resp = (long)opendir(d1);
    return(&resp);
}

sl_rpc_dirent *
sl_rpc_readdir_40(sl_rpc_DIRP **dirp, struct svc_req * cl)
{
    static sl_rpc_dirent res;
    struct dirent *resp;
    resp = readdir((DIR *)*dirp);
    if (resp == NULL) {
	res.last_entry = TRUE;
	res.d_name = null_ptr;
    }else{
	res.last_entry = FALSE;
#if ! defined __PARAGON__ && ! defined ultrix
	res.d_off = resp->d_off;
#endif
	res.d_reclen = resp->d_reclen;       
#if ! defined __linux__ && ! defined sgi
	res.d_fileno = resp->d_fileno;       
	res.d_namlen = resp->d_namlen;       
#endif
	if( resp->d_name == NULL){
	    res.d_name = null_ptr;
	}else{
	    res.d_name = &resp->d_name[0];
	}
    }
    return(&res);
}

int *
sl_rpc_closedir_40(sl_rpc_DIRP **dirp, struct svc_req * cl)
{
    static int res;
    res = closedir((DIR*)*dirp);
    return(&res);
}

char **
sl_rpc_getcwd_40(sl_par_getcwd *par, struct svc_req * cl)
{
    static char *res;
    char *d1;
    if (strcmp(par->buf, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->buf;
    }
    res = getcwd(d1,par->size);
    if(res == NULL) res = null_ptr;
    return(&res);
}

int *
sl_rpc_access_40(sl_par_access *par, struct svc_req * cl)
{
    static int res;
    char *d1;
    if (strcmp(par->path, null_ptr)==0) {
	d1 = NULL;
    }else{
	d1 = par->path;
    }
    res = access(d1,par->mode);
    return(&res);
}

sl_res_stat *
sl_rpc_stat_40(char  **path, struct svc_req * cl)
{
    static sl_res_stat res;
    char *d1;
    if (strcmp(*path, null_ptr)==0) {
        d1 = NULL;
    }else{
        d1 = *path;
    }
    res.return_value = stat(d1,&res);
    return(&res);
}



sl_rpc_krui_err   *
sl_download_file_40(sl_par_filetransfer *par, struct svc_req * cl)
{
    static bool opentmpfile=TRUE;
    static FILE *tempfile;
    static sl_rpc_krui_err res;
    static char *netname,buf[128];
    char buf2[135];
    char hostname[MAXHOSTDLEN];
    int  hostlen=16,setno;
    static int epoche=0,laufnr=0;

    if (epoche != par->epoche){
	/*reset Transfer */
	if(!opentmpfile)
	    fclose(tempfile);
	opentmpfile = TRUE;
	laufnr = 0;
	epoche = par->epoche;
    }
    if (par->laufnr != laufnr++){
	res = RPC_WRONG_PAKET;
	return(&res);
    }

    res = RPC_NO_ERROR;
    switch(par->Command){
      case TRANSFERNETWORK:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
	    tempfile = fopen(buf,"w");
	    if (tempfile == NULL) {
		res = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	fwrite(&par->fileblock[0],sizeof(char),par->bytes_used,tempfile);
	if(par->lastblock){
	    fclose(tempfile);
	    krui_deleteNet();
	    res = krui_loadNet(buf,&netname);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}
	break;
      case TRANSFERPATTERN:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
	    tempfile = fopen(buf,"w");
	    if (tempfile == NULL) {
		res = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	fwrite(&par->fileblock[0],sizeof(char),par->bytes_used,tempfile);
	if(par->lastblock){
	    fclose(tempfile);
	    res = krui_loadNewPatterns(buf,&setno);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}
	break;
      default:
	res = RPC_CANNOT_OPEN_FILE;
    }
    return(&res);
}

sl_res_filetransfer   *
sl_upload_file_40(sl_par_upload *par, struct svc_req * cl)
{
    static sl_res_filetransfer res;
    static bool opentmpfile=TRUE;
    static FILE *tempfile;
    char buf[135];
    char buf2[135];
    char hostname[MAXHOSTDLEN];
    int  hostlen=16;
    static int epoche=0,laufnr=0;

    res.error = RPC_NO_ERROR;
    if (epoche != par->epoche){
	/*reset Transfer */
	if(!opentmpfile)
	    fclose(tempfile);
	opentmpfile = TRUE;
	laufnr = 0;
	epoche = par->epoche;
    }
    res.epoche = epoche;
    res.laufnr = laufnr++;
    switch(par->command){
      case TRANSFERNETWORK:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.net",hostname,getpid());
	    /* Netzwerk sichern */
	    if(krui_saveNet(buf,NULL)!=KRERR_NO_ERROR){
		res.error = RPC_CANNOT_SAVE_FILE;
		return(&res);
	    }
	    tempfile = fopen(buf,"r");
	    if (tempfile == NULL) {
		res.error = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	res.bytes_used = fread(&res.fileblock[0],sizeof(char),FILEBLOCKSIZE-1,tempfile);
	if (feof(tempfile) != 0){
	    res.lastblock=TRUE;
	    fclose(tempfile);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}else{
	    res.lastblock=FALSE;
	}
	return(&res);
	break;
    case TRANSFERPATTERN:
	if(opentmpfile){
	    gethostname(hostname,hostlen);
	    sprintf(buf,"/tmp/%s.%d.pat",hostname,getpid());
	    /* Netzwerk sichern */
	    if(krui_saveNewPatterns(buf,par->setno)!=KRERR_NO_ERROR){
		res.error = RPC_CANNOT_SAVE_FILE;
		return(&res);
	    }
	    tempfile = fopen(buf,"r");
	    if (tempfile == NULL) {
		res.error = RPC_CANNOT_OPEN_FILE;
		return(&res);
	    }
	    opentmpfile = FALSE;
	}
	res.bytes_used = fread(&res.fileblock[0],sizeof(char),FILEBLOCKSIZE-1,tempfile);
	if (feof(tempfile) != 0){
	    res.lastblock=TRUE;
	    fclose(tempfile);
	    /* delete file */
	    sprintf(buf2,"/bin/rm -f %s",buf);
	    system(buf2);
	    opentmpfile = TRUE;
	}else{
	    res.lastblock=FALSE;
	}
	return(&res);
	break;
    }
    return(&res);
}


int *
sl_set_coopconfig_40(sl_parallel_kernels *conf, struct svc_req * cl)
{
    static int res;
    int i;
    char buf[65];
    bool found=FALSE;

   memcpy(&m_coopKernels[0],conf->kernels.kernels_val
	   ,conf->kernels.kernels_len*sizeof(parallel_kernel));

    m_anzCoopKernels = conf->kernels.kernels_len;
    for (i = 0 ; i < m_anzCoopKernels ; i++){
	m_coopKernels[i].kernelid = conf->kernels.kernels_val[i].kernelid;
	m_coopKernels[i].kernelno = conf->kernels.kernels_val[i].kernelno;
	m_coopKernels[i].host = strdup(conf->kernels.kernels_val[i].host);
	m_coopKernels[i].domain = strdup(conf->kernels.kernels_val[i].domain);
	m_coopKernels[i].hostaddr = 
	    strdup(conf->kernels.kernels_val[i].hostaddr);
	m_coopKernels[i].status = S_IDLE;
	m_coopKernels[i].coop_id = i; 
	if(m_coopKernelsCl[i]!= NULL)
	    clnt_destroy(m_coopKernelsCl[i]);
	m_coopKernelsCl[i] = NULL;
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
	m_coopKernelsLastT[i].tv_sec = 0L;
	m_coopKernelsLastT[i].tv_usec = 0L;
    }
     /* init the rest of the coopstructure */
    for (i = m_anzCoopKernels ;i < MAXPARAKERNELS ; i++){
	m_coopKernels[i].status = S_IDLE;
	if(m_coopKernelsCl[i]!= NULL)
	    clnt_destroy(m_coopKernelsCl[i]);
	m_coopKernelsCl[i] = NULL;
	m_coopKernelsStartT[i].tv_sec = 0L;
	m_coopKernelsStartT[i].tv_usec = 0L;
	m_coopKernelsLastT[i].tv_sec = 0L;
	m_coopKernelsLastT[i].tv_usec = 0L;
    }
#ifdef DEBUG
    printf("KernelMode is SLAVE\n");
#endif
    res = RPC_NO_ERROR;
    return(&res);
}

int *
sl_send_par_matrix_40(sl_par_matrix *par, struct svc_req * cl)
{
    static int res;

    res = RPC_NO_ERROR;
    switch(par->val_type){
      case VAL_WEIGHT:

	break;
      default:
	res = RPC_UNKNOWN_OPTION;
	break;
    }

    return(&res);
}

int *
sl_send_res_matrix_40(sl_res_matrix *par, struct svc_req * cl)
{
    static int res;

    res = RPC_NO_ERROR;
    switch(par->val_type){
      case VAL_WEIGHT:

	break;
      default:
	res = RPC_UNKNOWN_OPTION;
	break;
    }

    return(&res);
}


int *
sl_start_learning_40(sl_par_learning *par, struct svc_req * cl)
{
    static int res;

#ifdef DEBUG
    printf("Start Learning from Pattern %ld to %ld \n with CoopID:%d\n"
	   ,par->startpat,par->endpat,par->coop_id);
#endif
    res = RPC_NO_ERROR;
    
    /* send replay to the coop_master */
    if (!svc_sendreply(global_transp, xdr_int, &res)) {
	svcerr_systemerr(global_transp);
    }

    /* Start Learning */

    return(&res);
}

