/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/xgui/sources/RCS/d3_dither.c,v $
  SHORTNAME      : dither.c
  SNNS VERSION   : 4.0

  PURPOSE        : dithering of graylevels on a monochrome display
  NOTES          :

  AUTHOR         : Ralf Huebner
  DATE           : 1.12.1991

  CHANGED BY     : Sven Doering
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 2.3 $
  LAST CHANGE    : $Date: 1995/03/14 14:15:38 $

             Copyright (c) 1990-1995  SNNS Group, IPVR, Univ. Stuttgart, FRG

******************************************************************************/

#include "d3_dither.ph"

/*****************************************************************************
  FUNCTION : dither

  PURPOSE  : calculate the dither value
  RETURNS  : 0 if black or 1 if white
  NOTES    :

******************************************************************************/


int dither (int x, int y, float level)
{
    return (level * size*size > dither_matrix[(x % size) + size * (y % size)]);
}


/* end of file */
/* lines: 71 */

