/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.0/rpc/sources/RCS/kom_broadcast.c,v $
  SHORTNAME      : kom_broadcast
  SNNS VERSION   : 4.0

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.4 $
  LAST CHANGE    : $Date: 1995/05/08 10:29:08 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/
#include <sys/time.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#if ! defined ultrix && ! defined _HPUX_SOURCE
#include <rpc/pmap_rmt.h>
#endif
#include <sys/socket.h>
#include <stdio.h>
#include <errno.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>

#include "kom_broadcast.ph"

extern int errno;

/*****************************************************************************
  FUNCTION : kom_getbroadcastnets

  PURPOSE  :
  RETURNS  :
  NOTES    : The following is kludged-up support for simple rpc broadcasts.
             Someday a large, complicated system will replace these trivial 
	     routines which only support udp/ip .
	
	     sock    any valid socket will do 
	     buf     why allocxate more when we can use existing


  UPDATE   :
*****************************************************************************/

static int
kom_getbroadcastnets(struct in_addr *addrs, int sock, char *buf)
{
#ifdef linux
	struct sockaddr_in addr;

	get_myaddress(&addr);
	addrs[0] = inet_makeaddr(inet_netof(addr.sin_addr), INADDR_ANY);
	return 1;
#else
	struct ifconf ifc;
        struct ifreq ifreq, *ifr;
	struct sockaddr_in *sin;
        int n, i;

        ifc.ifc_len = UDPMSGSIZE;
        ifc.ifc_buf = buf;
        if (ioctl(sock, SIOCGIFCONF, (char *)&ifc) < 0) {
                perror("broadcast: ioctl (get interface configuration)");
                return (0);
        }
        ifr = ifc.ifc_req;
        for (i = 0, n = ifc.ifc_len/sizeof (struct ifreq); n > 0; n--, ifr++) {
                ifreq = *ifr;
                if (ioctl(sock, SIOCGIFFLAGS, (char *)&ifreq) < 0) {
                        perror("broadcast: ioctl (get interface flags)");
                        continue;
                }
                if ((ifreq.ifr_flags & IFF_BROADCAST) &&
		    (ifreq.ifr_flags & IFF_UP) &&
		    ifr->ifr_addr.sa_family == AF_INET) {
			sin = (struct sockaddr_in *)&ifr->ifr_addr;
#ifdef SIOCGIFBRDADDR   /* 4.3BSD */
			if (ioctl(sock, SIOCGIFBRDADDR, (char *)&ifreq) < 0) {
				addrs[i++] = inet_makeaddr(inet_netof
			    (sin->sin_addr), INADDR_ANY);
			} else {
				addrs[i++] = ((struct sockaddr_in*)
				  &ifreq.ifr_addr)->sin_addr;
			}
#else /* 4.2 BSD */
			addrs[i++] = inet_makeaddr(inet_netof
			  (sin->sin_addr.s_addr), INADDR_ANY);
#endif
		}
	}
	return (i);
#endif
}

/*****************************************************************************
  FUNCTION : kom_clnt_broadcast

  PURPOSE  : Broadcast a Paket in each Subnet, without waiting for results
  RETURNS  : The status of the Broadcast
  NOTES    :

  UPDATE   :
*****************************************************************************/

enum clnt_stat 
kom_clnt_broadcast(u_long prog, u_long vers, u_long proc, xdrproc_t xargs, caddr_t argsp)
/*	u_long		prog;		program number
	u_long		vers;		version number
	u_long		proc;		procedure number
	xdrproc_t	xargs;		xdr routine for args 
	caddr_t		argsp;		pointer to args 
*/
{
	enum clnt_stat stat = RPC_SUCCESS;
	AUTH *unix_auth = authunix_create_default();
	XDR xdr_stream;
	register XDR *xdrs = &xdr_stream;
	int outlen, inlen, fromlen, nets;
	int errcounter=0,counter;
	register int sock;
	int on = 1;
#ifdef FD_SETSIZE
	fd_set mask;
	fd_set readfds;
#else
	int readfds;
	register int mask;
#endif /* def FD_SETSIZE */
	register int i;
	bool_t done = FALSE;
	register u_long xid;
	u_long port;
	struct in_addr addrs[20];
	struct sockaddr_in baddr; /* broadcast address */
	struct rmtcallargs a;
	struct rpc_msg msg;
	struct timeval t; 
	char outbuf[MAX_BROADCAST_SIZE], inbuf[UDPMSGSIZE];

	/*
	 * initialization: create a socket, a broadcast address, and
	 * preserialize the arguments into a send buffer.
	 */
	if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
		perror("Cannot create socket for broadcast rpc");
		stat = RPC_CANTSEND;
		goto done_broadcast;
	}
#ifdef SO_BROADCAST
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &on, sizeof (on)) < 0) {
		perror("Cannot set socket option SO_BROADCAST");
		stat = RPC_CANTSEND;
		goto done_broadcast;
	}
#endif /* def SO_BROADCAST */
#ifdef FD_SETSIZE
	FD_ZERO(&mask);
	FD_SET(sock, &mask);
#else
	mask = (1 << sock);
#endif /* def FD_SETSIZE */
	nets = kom_getbroadcastnets(addrs, sock, inbuf);
	bzero((char *)&baddr, sizeof (baddr));
	baddr.sin_family = AF_INET;
	baddr.sin_port = htons(PMAPPORT);
	baddr.sin_addr.s_addr = htonl(INADDR_ANY);
/*	baddr.sin_addr.S_un.S_addr = htonl(INADDR_ANY); */
	(void)gettimeofday(&t, (struct timezone *)0);
	msg.rm_xid = xid = getpid() ^ t.tv_sec ^ t.tv_usec;
	msg.rm_direction = CALL;
	msg.rm_call.cb_rpcvers = RPC_MSG_VERSION;
	msg.rm_call.cb_prog = PMAPPROG;
	msg.rm_call.cb_vers = PMAPVERS;
	msg.rm_call.cb_proc = PMAPPROC_CALLIT;
	msg.rm_call.cb_cred = unix_auth->ah_cred;
	msg.rm_call.cb_verf = unix_auth->ah_verf;
	a.prog = prog;
	a.vers = vers;
	a.proc = proc;
	a.xdr_args = xargs;
	a.args_ptr = argsp;
	xdrmem_create(xdrs, outbuf, MAX_BROADCAST_SIZE, XDR_ENCODE);
	if ((! xdr_callmsg(xdrs, &msg)) || (! xdr_rmtcall_args(xdrs, &a))) {
		stat = RPC_CANTENCODEARGS;
		goto done_broadcast;
	}
	outlen = (int)xdr_getpos(xdrs);
	xdr_destroy(xdrs);
	/*
	 * Basic loop: broadcast a packet for each subnet
	 */
	for (i = 0; i < nets; i++) {
	    baddr.sin_addr = addrs[i];
	    if (sendto(sock, outbuf, outlen, 0,
		       (struct sockaddr *)&baddr,
		       sizeof (struct sockaddr)) != outlen) {
		perror("Cannot send broadcast packet");
		stat = RPC_CANTSEND;
		goto done_broadcast;
	    }
	}
done_broadcast:
	(void)close(sock);
	AUTH_DESTROY(unix_auth);
	return (stat);
}

/*****************************************************************************
  FUNCTION : kom_res_broadcast

  PURPOSE  : Broadcast a Paket in each Subnetfor each Message, 
             with waiting for results
  RETURNS  : The array of status for each target & msg 
  NOTES    : The prognumber in send_define_target must all the same, only the
             versnumber may differ.

  UPDATE   :
*****************************************************************************/
enum clnt_stat
kom_res_broadcast(int noOfTargets, send_define_target *targets, int noOfMsg, send_define_msg *messages, struct timeval timeout, struct timeval retry_timeout,send_control **status,result_proc res_proc)
{
  send_control *control;
  long         min_vers,max_vers; 
  register int i,j,msg_no,vers_no;
  static u_long paket_no = 1;

  enum clnt_stat stat = RPC_SUCCESS;
  AUTH *unix_auth = authunix_create_default();
  XDR xdr_stream;
  register XDR *xdrs = &xdr_stream;
  int outlen, inlen, fromlen, nets;
  register int sock;
  int on = 1;
#ifdef FD_SETSIZE
  fd_set mask;
  fd_set readfds;
#else
  int readfds;
  register int mask;
#endif /* def FD_SETSIZE */
  bool_t notdone = TRUE;
  register u_long xid;
  u_long port;
  struct in_addr addrs[20];
  struct sockaddr_in baddr, raddr; /* broadcast and response addresses */
  struct rmtcallargs a;
  struct rmtcallres r;
  struct rpc_msg msg;
  struct timeval t; 
  char outbuf[MAX_BROADCAST_SIZE], inbuf[UDPMSGSIZE];
  


  if(noOfTargets <= 0 || noOfMsg <= 0)
    return;

  *status =
    control = (send_control *)calloc(noOfTargets,sizeof(send_control));
  /* Init the control structure */
  for(i=0;  i < noOfTargets ; i++){
    control[i].paket_no = (u_long *)calloc(noOfMsg,sizeof(u_long));
    control[i].status = (int *)calloc(noOfMsg,sizeof(int));
    for(j=0;  j < noOfMsg ; j++){
      control[i].status[j] = KOM_NOT_SEND;
      control[i].paket_no[j] = 0;
    }      
    control[i].pakets_recv = 0;
    control[i].last_paket_no = 0;
  }
    
  /* Find the max and min versnumber */
  for(i=0, min_vers=targets[0].versnumber, max_vers=targets[0].versnumber;
      i < noOfTargets ; i++){
    if(min_vers > targets[i].versnumber)
      min_vers=targets[i].versnumber;
    if(max_vers < targets[i].versnumber)
      max_vers=targets[i].versnumber;
  }

  
  /*
   * initialization: create a socket, a broadcast address, and
   * preserialize the arguments into a send buffer.
   */
  if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
    perror("Cannot create socket for broadcast rpc");
    stat = RPC_CANTSEND;
    goto fatal_error;
  }
#ifdef SO_BROADCAST
  if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &on, sizeof (on)) < 0) {
    perror("Cannot set socket option SO_BROADCAST");
    stat = RPC_CANTSEND;
    goto fatal_error;
  }
#endif /* def SO_BROADCAST */
#ifdef FD_SETSIZE
  FD_ZERO(&mask);
  FD_SET(sock, &mask);
#else
  mask = (1 << sock);
#endif /* def FD_SETSIZE */
  nets = kom_getbroadcastnets(addrs, sock, inbuf);
  bzero((char *)&baddr, sizeof (baddr));
  baddr.sin_family = AF_INET;
  baddr.sin_port = htons(PMAPPORT);
  baddr.sin_addr.s_addr = htonl(INADDR_ANY);
  /*	baddr.sin_addr.S_un.S_addr = htonl(INADDR_ANY); */
  msg.rm_xid = xid = paket_no;
  msg.rm_direction = CALL;
  msg.rm_call.cb_rpcvers = RPC_MSG_VERSION;
  msg.rm_call.cb_prog = PMAPPROG;
  msg.rm_call.cb_vers = PMAPVERS;
  msg.rm_call.cb_proc = PMAPPROC_CALLIT;
  msg.rm_call.cb_cred = unix_auth->ah_cred;
  msg.rm_call.cb_verf = unix_auth->ah_verf;

  /* For each msg */
  a.prog = targets[0].prognumber;
  r.port_ptr = &port;
  for (msg_no = 0 ;msg_no < noOfMsg ; msg_no++){
    a.xdr_args = messages[msg_no].xdr_code;
    a.args_ptr = messages[msg_no].msg_p;
    a.proc = messages[msg_no].procnumber;
    r.xdr_results = messages[msg_no].xdr_decode;
    r.results_ptr = messages[msg_no].res_p;
    /* Broadcast for each Versionnumber */
    for(vers_no = min_vers ; vers_no <= max_vers ; vers_no++){
      a.vers = vers_no;
      xdrmem_create(xdrs, outbuf, MAX_BROADCAST_SIZE, XDR_ENCODE);
      if ((! xdr_callmsg(xdrs, &msg)) || (! xdr_rmtcall_args(xdrs, &a))) {
	stat = RPC_CANTENCODEARGS;
	goto fatal_error;
      }
      outlen = (int)xdr_getpos(xdrs);
      xdr_destroy(xdrs);
      for (i = 0; i < nets; i++) {
	baddr.sin_addr = addrs[i];
	if (sendto(sock, outbuf, outlen, 0,
		   (struct sockaddr *)&baddr,
		   sizeof (struct sockaddr)) != outlen) {
	  perror("Cannot send broadcast packet");
	  stat = RPC_CANTSEND;
	  goto fatal_error;
	}
      }
    }

    do{
    recv_again:
      msg.acpted_rply.ar_verf = _null_auth;
      msg.acpted_rply.ar_results.where = (caddr_t)&r;
      msg.acpted_rply.ar_results.proc = xdr_rmtcallres;
      readfds = mask;
      switch (select(_rpc_dtablesize(), &readfds, (int *)NULL, 
		     (int *)NULL, &timeout)) {
      
      case 0:			/* timed out */
	stat = RPC_TIMEDOUT;
fprintf(stderr,"Timeout\n");
	goto fatal_error;
      case -1:			/* some kind of error */
	if (errno == EINTR)
	  goto recv_again;
	perror("Broadcast select problem");
	stat = RPC_CANTRECV;
	goto fatal_error;

      } /* end of select results switch */
    try_again:
      fromlen = sizeof(struct sockaddr);
      inlen = recvfrom(sock, inbuf, UDPMSGSIZE, 0,
		       (struct sockaddr *)&raddr, &fromlen);
      if (inlen < 0) {
	if (errno == EINTR)
	  goto try_again;
	perror("Cannot receive reply to broadcast");
	stat = RPC_CANTRECV;
	goto fatal_error;
      }
      if (inlen < sizeof(u_long))
	goto recv_again;
      /*
       * see if reply transaction id matches sent id.
       * If so, decode the results.
       */
      xdrmem_create(xdrs, inbuf, (u_int)inlen, XDR_DECODE);
      if (xdr_replymsg(xdrs, &msg)) {
	if ((msg.rm_xid == xid) &&
	    (msg.rm_reply.rp_stat == MSG_ACCEPTED) &&
	    (msg.acpted_rply.ar_stat == SUCCESS)) {
	  raddr.sin_port = htons((u_short)port);
	  /* Call result function */
	  if (res_proc == NULL) {
	    stat = RPC_SUCCESS;
	    notdone = FALSE;
	  }else{
	    notdone = (*res_proc)(msg_no, messages[msg_no].res_p);
	  }
	}
	/* otherwise, we just ignore the errors ... */
      } 
      xdrs->x_op = XDR_FREE;
      msg.acpted_rply.ar_results.proc = xdr_void;
      (void)xdr_replymsg(xdrs, &msg);
      (void)(*messages[msg_no].xdr_decode)(xdrs, messages[msg_no].res_p);
      xdr_destroy(xdrs);
    } while(notdone) ;
  }

  (void)close(sock);
  AUTH_DESTROY(unix_auth);
  return (stat);
  
 fatal_error:
fprintf(stderr,"Fatal Error\n");
  (void)close(sock);
  AUTH_DESTROY(unix_auth);
  
  return (stat);
}

