##############################################################################
#
# Makefile for plplot under Unix.
#
# $Id: makefile.m4,v 1.17 1994/05/26 19:55:10 mjl Exp $
#
# $Log: makefile.m4,v $
# Revision 1.17  1994/05/26  19:55:10  mjl
# Fixed bug in install macro.
#
# Revision 1.16  1994/05/24  21:34:42  mjl
# Made the clean target do the usual thing.  Happy now?
#
# Revision 1.15  1994/05/24  20:46:29  mjl
# Added mklinks and pltek to install target.
#
# Revision 1.14  1994/05/24  20:36:27  furnish
# Fixed bug in installation.
#
# Revision 1.13  1994/05/24  19:56:13  mjl
# Override INSTALL_DIR if m4 macro PREFIX is defined.  Define values for
# TCL_DIRFLAG, BIN_DIRFLAG, LIB_DIRFLAG for files with a need to know.
# Geoff's changes: created macros and made changes to install target for
# install into subdirs bin, lib, doc, info, of INSTALL_DIR.
#
# Revision 1.12  1994/05/23  22:09:54  mjl
# Eliminated the "plplotio.h" header file (gone) from a list.
#
# Revision 1.11  1994/05/11  08:07:58  furnish
# Hack to allow system specific additions to the makefile.
#
# Revision 1.10  1994/04/25  19:06:38  mjl
# Fixed install target to install any example palette files.
#
# Revision 1.9  1994/04/08  12:46:39  mjl
# Fixed plplotTK.h install.
#
# Revision 1.8  1994/03/23  07:17:54  mjl
# Some minor fixes when using Tcl-DP.
#
# Revision 1.7  1993/12/08  21:08:25  mjl
# Changed install target to copy plplotX.h to INSTALL_DIR/include.
#
# Revision 1.6  1993/12/08  21:03:10  mjl
# Improved realclean target.
#
# Revision 1.5  1993/11/07  09:05:25  mjl
# changed some comment introducers to "dnl>" since the comments only
# describe macros (this way they disappear after processing with m4).
#
# Revision 1.4  1993/10/22  01:20:54  mjl
# Improvements to make build more general.
#
# Revision 1.3  1993/10/21  20:24:37  mjl
# Eliminated some cruft.
#
# Revision 1.2  1993/10/04  21:49:25  mjl
# Minor fixes.
#
# Revision 1.1  1993/10/04  17:42:34  mjl
# Master controller makefile for plplot.
#
##############################################################################

dnl> Set up the base m4 macros.

include(cf_basic.m4)

# Default install directory

INSTALL_DIR	= /usr/local/plplot

dnl> Set up local definitions

include(cf_plplot.m4)

dnl> Read config files and other setup

include(cf_unix.m4)

##############################################################################

# Dependent directories

PLLIB_DIR	= ../lib
PLFNT_DIR	= ../lib
PLLIB_PATH	= $(PLLIB_DIR)/
PLFNT_PATH	= $(PLFNT_DIR)/

# Install directories
# Can be set (a) above, (b) in cf_plplot.m4, or (c) by configure (using PREFIX)

ifdef({PREFIX},{
INSTALL_DIR	= PREFIX
})

LIB_DIR		= $(INSTALL_DIR)/lib
DOC_DIR		= $(INSTALL_DIR)/doc
BIN_DIR		= $(INSTALL_DIR)/bin
INFO_DIR	= $(INSTALL_DIR)/info
INCLUDE_DIR	= $(INSTALL_DIR)/{include}
TCL_DIR		= $(INSTALL_DIR)/tcl

# These are so that PLplot can find supporting files.

LIB_DIRFLAG	= -DLIB_DIR=\"$(LIB_DIR)\"
BIN_DIRFLAG	= -DBIN_DIR=\"$(BIN_DIR)\"
TCL_DIRFLAG	= -DTCL_DIR=\"$(TCL_DIR)\"

# Library names
# Add suffix of:
#	b	for baseline library (no X or TK)
#	X	with Xlib included
#	tk	with Xlib and TK and or Tcl-DP included
#
# Build those best suited to your system and softlink to libplplotf
# and libplplotd to create the system default.  Note: precision tag
# "f" or "d" already defined by cf_unix.m4.

TAG_INCLUDE	= b

if_xwin({
TAG_INCLUDE	= X
})

if_tk({
TAG_INCLUDE	= tk
})

if_dp({
TAG_INCLUDE	= tk
})

# The main plplot library.  Used in dependencies.

PLLIB		= $(PLLIB_PATH)libplplot$(TAG_PREC)$(TAG_INCLUDE).$(LIBSUF)

# These are what we link against.

PLLIB_LDC	= $(PLLIB)
PLLIB_LDF	= $(PLLIB)

# This is used for making the install versions of plrender & plserver

LIB_INSTALL	= -L$(LIB_DIR) -lplplot$(TAG_PREC)$(TAG_INCLUDE)

# Include dependencies and main targets.

include(cf_depend.m4)

##############################################################################

# "install" target
# It is usually not difficult to get a system administrator to give you
# ownership of a directory under /usr/local, such as /usr/local/plplot.
# The install directory will be created if necessary, as will subdirectories
# bin, lib, include, doc, man (eventually), and tcl.

install:
	-if [ ! -d $(INSTALL_DIR) ] ; then mkdir -p $(INSTALL_DIR); fi
	-if [ ! -d $(INCLUDE_DIR) ] ; then mkdir -p $(INCLUDE_DIR); fi
	-if [ ! -d $(LIB_DIR) ] ; then mkdir -p $(LIB_DIR); fi
	-if [ ! -d $(DOC_DIR) ] ; then mkdir -p $(DOC_DIR); fi
	-if [ ! -d $(BIN_DIR) ] ; then mkdir -p $(BIN_DIR); fi
	-if [ ! -d $(INFO_DIR) ] ; then mkdir -p $(INFO_DIR); fi
	-cp ../mklinks $(INSTALL_DIR)
	-cp ../lib/libplplot* ../lib/*.fnt $(LIB_DIR)
if_ranlib(dnl
{	ranlib $(LIB_DIR)/*.a
})	-cd ..; cp README* Changes.log COPYRIGHTS FAQ ToDo $(DOC_DIR)
	-cd ../scripts; cp pl* $(BIN_DIR)
	-cd ../{include}; \
	cp plplotP.h plplot.h plplotX.h plplotTK.h \
	   plevent.h plstream.h pdf.h \
		$(INCLUDE_DIR)
if_shr(dnl
{	$(LDC) $(LDC_FLAGS) plrender.o $(LIB_INSTALL) \
		-o plrender $(LDC_PATH) $(LDC_LIBS)
	$(LDC) $(LDC_FLAGS) pltek.o $(LIB_INSTALL) \
		-o pltek $(LDC_PATH) $(LDC_LIBS)
if_tk(dnl
{	-if [ ! -d $(TCL_DIR) ] ; then mkdir -p $(TCL_DIR); fi
	$(LDC) $(LDC_FLAGS) $(SERVER_OBJ) $(LIB_INSTALL) \
		-o plserver $(LDC_PATH) $(LDC_LIBS)
})})	-strip plrender pltek
	-cp plrender pltek $(BIN_DIR)
if_tk(dnl
{	-strip plserver
	-cp plserver $(BIN_DIR)
	-cd ../drivers/tk
	-cp *.tcl *.pal tclIndex $(TCL_DIR)
})

##############################################################################

# Auxiliary targets, unique to a given machine.

ifdef({SYSTEM_AUX_TARGETS},
SYSTEM_AUX_TARGETS
)

##############################################################################

# cleanup targets

dust:
	-rm $(CDEMOS) $(FDEMOS) *.plm* *.tek* *.ps 

realclean: clean

clean:
	-rm * ../lib/libpl*

##############################################################################

makefile:
	m4 MAKE_FLAGS makefile.m4 >Makefile

