#ifndef lint
static char SCCSid[] = "@(#) ./comm/merge.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/procset.h" 

/* @
    PIMergeH - Merge data together with a user defined combination function.
    Only the root has the result of the data (use a GSCATTER to send the
    data to everyone).

    Input parameters:
.   ldata, llen    - local data and length
.   gmaxlen        - size of gdata (result)
.   lmaxlen        - at least size of longest message; a good value is
                     gmaxlen.
.   combine        - user routine to combine values
.   pset           - processor set to merge over
.   ltmp           - temporary of size lmaxlen (used to receive data).  Must
                     have been allocated with MSGALLOCRECV
.   gtmp           - temporary of size gmaxlen (used to combine data).  Must
                     have been allocated with MSGALLOCSEND
.   datatype       - type of data in message.

    Output parameters:
.   gdata, glen    - result merged data.  gdata must be allocated with
    MSGALLOCSEND.

    Note:
   The form of the combine routine is
$   void combine( void *d1, int l1, void *d2, int l2, void *d3, int *l3 );
$   where d1 and d2 are input, and d3 is the result.  The length of the result
   is placed in l3.

   See Also:
   PIMergeC, GCOL, GCOLX, SpPAdd
@ */
void PIMergeH( ldata, llen, gmaxlen, combine, pset, gdata, glen, 
	      ltmp, lmaxlen, gtmp, datattype )
void    *ldata, *gdata, *ltmp, *gtmp;
int     llen, gmaxlen, lmaxlen, *glen;
ProcSet *pset;
{
char *p   = gdata;
int  ln, l2, gsize;
int  l_child, r_child, parent, myid, np;
int  msgup, msgdn;
void *g1 = gdata, *g2 = gtmp, *ttt;
#define SWAP(a,b) {ttt=a;a=b;b=ttt;}

gsize  = llen;
MEMCPY(gdata,ldata,llen);

/* Receive values from my children and accumulate */
if (!procset) {
    myid    = MYPROCID;
    np      = NUMNODES;
    l_child = 2 * myid + 1;
    r_child = l_child + 1;
    parent  = (myid-1)/2;
    if (myid == 0)      parent = -1;
    if (l_child >= np) l_child = -1;
    if (r_child >= np) r_child = -1;
    }
else {
    l_child = procset->l_child;
    r_child = procset->r_child;
    parent  = procset->parent;
    }
msgup = GMSGTYPE(procset,MSG_UP);
msgdn = GMSGTYPE(procset,MSG_DN);

if (l_child >= 0) {
    RECVSYNC(msgup,ltmp,lmaxlen,datatype);
    ln    = RECVLEN();
    l2    = lmaxlen;
    (*combine)( g1, gsize, ltmp, ln, g2, &l2 );
    gsize = l2;
    SWAP(g1,g2);
    }
if (r_child >= 0) {
    RECVSYNC(msgup,ltmp,lmaxlen,datatype);
    ln    = RECVLEN();
    l2    = lmaxlen;
    (*combine)( g1, gsize, ltmp, ln, g2, &l2 );
    gsize = l2;
    SWAP(g1,g2);
    }

/* Send to parent */
if (parent >= 0) {
    SENDSYNC(msgup,g1,gsize,parent,datatype);
    }
}
