/*
 */

#ifndef __PIHOSTS
#define __PIHOSTS

#define DEFAULTTOOLSHOSTS "/home/gropp/tools.n/comm/hosts"
#define DEFAULTPVMD       "/home/gropp/pvm/src/SUN4/pvmd"
#define DEFAULTPVMHOSTS   "/home/gropp/tools.n/comm/pvmhosts"
#define DEFAULTP4D        "/usr/local/p4/bin/start_server"
#define DEFAULTP4HOSTS    "/home/gropp/tools.n/comm/p4hosts"
#define DEFAULTPVMROOT    "/home/gropp/pvm/src"

/* Structure to hold data from the TOOLSHOSTS database */
#define PIMAX_HOST_NAME 129
typedef struct {
    char name[PIMAX_HOST_NAME];
    char arch[129], owner[12];
    int  hs, ms, he, me;
    char day[12];
    int  mem, cpu, pf, np, niceval, htype[4];
    } HOSTDATA;

/* 
   Known architectures 
 */
typedef enum { ARCHsun4, ARCHrs6000, ARCHintelnx, ARCHNeXT, 
               ARCHsun3, ARCHIRIX, ARCHfx28000, ARCHsymmetry,
               ARCHtc2000, ARCHdec5000, ARCHunknown  } Arch ;

#define MAXARCHES      11
/* Try to get the system's value of MAXHOSTNAMELEN */
#include <sys/param.h>
#if !defined(MAXHOSTNAMELEN) 
#define MAXHOSTNAMELEN 64
#endif
#if !defined(MAXPATHLEN) 
#define MAXPATHLEN 1024
#endif

/*
   Description of the host table datastructure 

   A host table contains two arrays: a list of Hosts, and a list of
   Architectures.  Every host also appears in the Architectures; 
   Architectures is basically a list of hosts sorted by architecture.

   One problem with the approach here is that you can NOT specify a different
   executable for different hosts in the same architecture.
 */
struct _Host {
  int          np, nice;
  Arch         arch;
  char         name[MAXHOSTNAMELEN];
  struct _Host *next;
};
typedef struct _Host Host;

typedef struct {
  int        ne;        /* number of entries */
  int        np;        /* number of processors */
  Host       **hosts;
  char       *fname;    /* name of executable */
} ArchTable;

typedef struct {
  int        ne;        /* number of entries */
  int        np;        /* number of processors */
  int        na;        /* number of architectures */
  ArchTable  archtable[MAXARCHES];
  Host       **hosts;
} HostTable;

extern HostTable *PIReadInHostTable();
extern HostTable *PIBuildHostTable();
extern void      PIDestroyHostTable();
extern Arch      PIStringToArch();
extern void      PIArchToString();
extern char      *PIExecutableName();
#endif
