/*
   This is a test program for the mesh communications code
 */

#include "tools.h"
#include "comm/comm.h"
#include "blkcm/bc.h"

#include "blkcm/mesh.h"
#include <stdio.h>

double *BuildDomain();

/* This is the main program.  To make it easier to use it in a parallel
   environment, it is actually called by PICall */
mtest( argc, argv )
int  argc;
char **argv;
{
BCPGM      *Program;
double     *p0, *p1, *p2, *p3;
int        nx, ny, mx, my, pgmn, i;

/*
   Allocate some meshes and set initial data (index location).  There are
   four domains arranged in a four-by-four pattern, with the edges connected
   periodically.

   +---+---+
   | 0 | 1 |
   +---+---+
   | 2 | 3 |
   +---+---+

   In the multiprocessor version of this test, there is one domain per
   processor.
 */
nx = 3;
ny = 4;
mx = 3 + 2;
my = 4 + 2;

/* Set up the communication programs */
#ifdef DISTRIBUTED_MEMORY
/* Note that these need to be done in pairs (a send and a receive) */
p0 = BuildDomain( nx, ny, mx, my, MYPROCID*nx*ny );
Program = BCBuildMesh( mx, my, 0, nx, ny, p0+(mx+1), BCBuildProcMap( 2, 2 ) );
#else
p0 = BuildDomain( nx, ny, mx, my, 0 );
p1 = BuildDomain( nx, ny, mx, my, nx*ny );
p2 = BuildDomain( nx, ny, mx, my, 2*nx*ny );
p3 = BuildDomain( nx, ny, mx, my, 3*nx*ny );
Program = BCalloc( 16 );
BCjoin2( Program, 0,  p0, BC_SOUTH, mx, my, nx, ny, 1, p2, BC_NORTH, 0, 2 );
BCjoin2( Program, 4,  p0, BC_EAST,  mx, my, nx, ny, 1, p1, BC_WEST, 0, 1 );
BCjoin2( Program, 8,  p1, BC_SOUTH, mx, my, nx, ny, 1, p3, BC_NORTH, 1, 3 );
BCjoin2( Program, 12, p3, BC_WEST,  mx, my, nx, ny, 1, p2, BC_EAST, 3, 2 );
#endif

/* Initialize the communication */
BCSetDefault( Program );
#ifdef p4
BCcompile( Program, 
	      BCOPTION_BUFFER | BCOPTION_TRIMMOVE );
#else
BCcompile( Program, 
	      BCOPTION_BUFFER | BCOPTION_PAIRSYNC | BCOPTION_TRIMMOVE );
#endif
/* print the program */
BCprint_pgms( Program, stdout );

/* Do the exchanges */
BCexec( Program, 0, 0 );

/* check the results */
#ifdef DISTRIBUTED_MEMORY
for (i=0; i<=4; i++) {
    if (GTOKEN(0,i)) {
        printf( "P%d\n", i );
        PrintDomain( nx, ny, mx, my, p0 );
        }
    }
#else
printf( "P0\n" );
PrintDomain( nx, ny, mx, my, p0 );
printf( "P1\n" );
PrintDomain( nx, ny, mx, my, p1 );
printf( "P2\n" );
PrintDomain( nx, ny, mx, my, p2 );
printf( "P3\n" );
PrintDomain( nx, ny, mx, my, p3 );
#endif
}

double *BuildDomain( nx, ny, mx, my, off )
int nx, ny, mx, my, off;
{
double *p, *p1;
int    n, i;
p = p1 = (double *)MALLOC( mx * my * sizeof(double) );
n = mx * my;
while (n--)
    *p1++ = 0.0;
p1 = p + 1 + mx;      /* buffer size of 1 assumed */
i  = off;
while (ny--) {
    n = nx;
    while (n--)
        *p1++ = i++;
    p1 += mx - nx;
    }
return p;
}

PrintDomain( nx, ny, mx, my, p )
int    nx, ny, mx, my;
double *p;
{
int    i, j;
double *p1;

/* Start from top down so that the vertical ordering is the same as
   the users' */
for (j=my-1; j>=0; j--) {
    p1 = p + j * mx;
    i  = mx;
    while (i--)
        printf( "%f ", *p1++ );
    printf( "\n" );
    }
}

main( argc, argv )
int  argc;
char **argv;
{
PICall( mtest, argc, argv );
exit( 0 );
}
