/* Interface to graphics for Fortran program */
#include <stdio.h>
#include "tools.h"
#include "comm/comm.h"

#if defined(FORTRANCAPS)
#define dispmesh_ DISPMESH
#define dispall_  DISPALL
#elif !defined(FORTRANUNDERSCORE)
#define dispmesh_ dispmesh
#define dispall_  dispall
#endif

/* 
   Display a mesh with ghost points.  Declared (in Fortran) as:
   mesh(si-sig:ei+eig,sj-sjg:ej+ejg)
 */
void dispmesh_( mesh, si, sig, ei, eig, sj, sjg, ej, ejg, maxi, maxj, nc )
double *mesh;
int    *si, *sig, *ei, *eig, *sj, *sjg, *ej, *ejg, *maxi, *maxj, *nc;
{
int i, ii, jj, lmx, lmy;
int Si, Ei, Sj, Ej;

/* Local sizes including ghost points */
lmx = *ei + *eig - (*si - *sig) + 1;
lmy = *ej + *ejg - (*sj - *sjg) + 1;
/* Local array limits */
Si  = *si - *sig;
Ei  = *ei + *eig;
Sj  = *sj - *sjg;
Ej  = *ej + *ejg;

#ifdef USEX
XBPQContour( mesh, (double *)0, (double *)0, 
	     *maxi, *maxj, *nc, *si, *ei, *sj, *ej, ALLPROCS );
#else
/* Print the output */
for (i=0; i<=NUMNODES; i++) {
    if (GTOKEN(ALLPROCS,i)) {
	printf( "Solution part for [%d,%d] x [%d,%d]\n", *si, *ei, *sj, *ej );
	for (jj = *sj; jj <= *ej; jj++) {
	    for (ii = *si; ii <= *ei; ii++) 
		printf( "%12.4e ", mesh[(jj-Sj)*lmx + (ii-Si)] );
	    printf( "\n" );
	    }
	fflush( stdout );
	}
    }
#endif
}

void dispall_( mesh, si, sig, ei, eig, sj, sjg, ej, ejg, maxi, maxj, nc )
double *mesh;
int    *si, *sig, *ei, *eig, *sj, *sjg, *ej, *ejg, *maxi, *maxj, *nc;
{
int i, ii, jj, lmx, lmy;
int Si, Ei, Sj, Ej;

/* Local sizes including ghost points */
lmx = *ei + *eig - (*si - *sig) + 1;
lmy = *ej + *ejg - (*sj - *sjg) + 1;
/* Local array limits */
Si  = *si - *sig;
Ei  = *ei + *eig;
Sj  = *sj - *sjg;
Ej  = *ej + *ejg;

for (i=0; i<=NUMNODES; i++) {
    if (GTOKEN(ALLPROCS,i)) {
	printf( "Solution part for [%d,%d] x [%d,%d]\n", Si, Ei, Sj, Ej );
	for (jj = Sj; jj <= Ej; jj++) {
	    for (ii = Si; ii <= Ei; ii++) 
		printf( "%12.4e ", mesh[(jj-Sj)*lmx + (ii-Si)] );
	    printf( "\n" );
	    }
	fflush( stdout );
	}
    }
}
